/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.abstracts;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.NotPlaceable;
import io.github.thebusybiscuit.slimefun4.core.attributes.Rechargeable;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import me.gallowsdove.foxymachines.FoxyMachines;
import me.gallowsdove.foxymachines.Items;
import me.gallowsdove.foxymachines.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public abstract class AbstractWand
extends SlimefunItem
implements NotPlaceable,
Rechargeable {
    private static final NamespacedKey MATERIAL_KEY = new NamespacedKey((Plugin)FoxyMachines.getInstance(), "wand_material");
    public static final Set<Material> BLACKLISTED = Set.of(Material.BARRIER, Material.SPAWNER, Material.COMMAND_BLOCK, Material.STRUCTURE_BLOCK, Material.REPEATING_COMMAND_BLOCK, Material.CHAIN_COMMAND_BLOCK, Material.JIGSAW);
    public static final Set<Material> WHITELISTED = Set.of(Material.GLASS, Material.ACACIA_LEAVES, Material.AZALEA_LEAVES, Material.BIRCH_LEAVES, Material.DARK_OAK_LEAVES, Material.FLOWERING_AZALEA_LEAVES, Material.JUNGLE_LEAVES, Material.OAK_LEAVES, Material.SPRUCE_LEAVES, Material.GRAY_STAINED_GLASS, Material.BLACK_STAINED_GLASS, Material.BLUE_STAINED_GLASS, Material.BROWN_STAINED_GLASS, Material.CYAN_STAINED_GLASS, Material.GREEN_STAINED_GLASS, Material.LIGHT_BLUE_STAINED_GLASS, Material.LIGHT_GRAY_STAINED_GLASS, Material.LIME_STAINED_GLASS, Material.MAGENTA_STAINED_GLASS, Material.ORANGE_STAINED_GLASS, Material.PINK_STAINED_GLASS, Material.PURPLE_STAINED_GLASS, Material.RED_STAINED_GLASS, Material.WHITE_STAINED_GLASS, Material.YELLOW_STAINED_GLASS);

    public AbstractWand(SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super((ItemGroup)Items.TOOLS_ITEM_GROUP, item, recipeType, recipe);
    }

    protected abstract float getCostPerBBlock();

    protected abstract boolean isRemoving();

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{this.onUse()});
    }

    @Nonnull
    protected ItemUseHandler onUse() {
        return e -> {
            Player player = e.getPlayer();
            ItemStack itemInInventory = player.getInventory().getItemInMainHand();
            ItemMeta meta = itemInInventory.getItemMeta();
            PersistentDataContainer container = meta.getPersistentDataContainer();
            if (player.isSneaking()) {
                Material material;
                if (!this.isRemoving() && e.getClickedBlock().isPresent() && ((material = ((Block)e.getClickedBlock().get()).getType()).isBlock() && material.isSolid() && material.isOccluding() && !BLACKLISTED.contains(material) || WHITELISTED.contains(material))) {
                    player.sendMessage(ChatColor.LIGHT_PURPLE + "Material set to: " + material);
                    container.set(MATERIAL_KEY, PersistentDataType.STRING, (Object)material.toString());
                    List lore = this.getItem().getItemMeta().getLore();
                    lore.set(lore.size() - 2, ChatColor.GRAY + "Material: " + ChatColor.YELLOW + material);
                    meta.setLore(lore);
                    itemInInventory.setItemMeta(meta);
                }
            } else {
                List<Location> locs;
                if (this.isRemoving() && !container.has(MATERIAL_KEY, PersistentDataType.STRING)) {
                    container.set(MATERIAL_KEY, PersistentDataType.STRING, (Object)Material.AIR.toString());
                }
                if ((locs = this.getLocations(player)).size() == 0) {
                    return;
                }
                PlayerInventory inventory = player.getInventory();
                if (!container.has(MATERIAL_KEY, PersistentDataType.STRING)) {
                    player.sendMessage(ChatColor.RED + "Select a building material with Shift + Right Click!");
                    return;
                }
                Material material = Material.getMaterial((String)((String)container.get(MATERIAL_KEY, PersistentDataType.STRING)));
                ItemStack blocks = new ItemStack(material, locs.size());
                if (this.isRemoving() || inventory.containsAtLeast(blocks, locs.size())) {
                    if (this.removeItemCharge(e.getItem(), this.getCostPerBBlock() * (float)locs.size())) {
                        inventory.removeItem(new ItemStack[]{blocks});
                        for (Location loc : locs) {
                            Bukkit.getScheduler().runTask((Plugin)FoxyMachines.getInstance(), () -> loc.getBlock().setType(material));
                        }
                    } else {
                        player.sendMessage(ChatColor.RED + "Your item doesn't have enough energy for that!");
                        player.sendMessage(ChatColor.RED + "Energy needed: " + this.getCostPerBBlock() * (float)locs.size());
                    }
                } else {
                    player.sendMessage(ChatColor.RED + "There aren't enough materials in your inventory!");
                    player.sendMessage(ChatColor.RED + "Current items: " + Utils.countItemInInventory((Inventory)inventory, blocks) + " Needed: " + locs.size());
                }
            }
        };
    }

    protected abstract List<Location> getLocations(@Nonnull Player var1);
}

