/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.implementation.multiblock;

import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.gallowsdove.foxymachines.Items;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class SacrificialAltarPiece
extends SlimefunItem {
    public SacrificialAltarPiece(@Nonnull SlimefunItemStack item, @Nonnull ItemStack[] recipe, int amount) {
        super(Items.ITEM_GROUP, item, RecipeType.ENHANCED_CRAFTING_TABLE, recipe, (ItemStack)new SlimefunItemStack(item, amount));
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{this.onBlockBreak()});
    }

    private BlockBreakHandler onBlockBreak() {
        return new BlockBreakHandler(false, false){

            @ParametersAreNonnullByDefault
            public void onPlayerBreak(BlockBreakEvent e, ItemStack item, List<ItemStack> drops) {
                Block b = SacrificialAltarPiece.this.findAltar(e.getBlock());
                if (b != null && BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"complete") != null && BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"complete").equals("true")) {
                    BlockStorage.addBlockInfo((Block)b, (String)"complete", (String)"false");
                    e.getPlayer().sendMessage(ChatColor.LIGHT_PURPLE + "Part of the altar has been broken, please repair it and reactivate it!");
                }
                BlockStorage.clearBlockInfo((Block)e.getBlock());
            }
        };
    }

    @Nullable
    private Block findAltar(@Nonnull Block b) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    Block block;
                    if (x == 0 && y == 0 && z == 0 || (block = b.getRelative(x, y, z)).getType() != Material.POLISHED_BLACKSTONE_PRESSURE_PLATE || BlockStorage.getLocationInfo((Location)block.getLocation(), (String)"id") == null || !BlockStorage.getLocationInfo((Location)block.getLocation(), (String)"id").equals("SACRIFICIAL_ALTAR_BLACKSTONE_PRESSURE_PLATE")) continue;
                    return block;
                }
            }
        }
        return null;
    }
}

