/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines;

import java.io.File;
import javax.annotation.Nonnull;
import me.gallowsdove.foxymachines.ItemSetup;
import me.gallowsdove.foxymachines.ResearchSetup;
import me.gallowsdove.foxymachines.abstracts.CustomBoss;
import me.gallowsdove.foxymachines.commands.KillallCommand;
import me.gallowsdove.foxymachines.commands.QuestCommand;
import me.gallowsdove.foxymachines.commands.SacrificialAltarCommand;
import me.gallowsdove.foxymachines.commands.SummonCommand;
import me.gallowsdove.foxymachines.implementation.machines.ForcefieldDome;
import me.gallowsdove.foxymachines.implementation.tools.BerryBushTrimmer;
import me.gallowsdove.foxymachines.infinitylib.common.Events;
import me.gallowsdove.foxymachines.infinitylib.common.Scheduler;
import me.gallowsdove.foxymachines.infinitylib.core.AbstractAddon;
import me.gallowsdove.foxymachines.infinitylib.metrics.bukkit.Metrics;
import me.gallowsdove.foxymachines.listeners.ArmorListener;
import me.gallowsdove.foxymachines.listeners.BerryBushListener;
import me.gallowsdove.foxymachines.listeners.BoostedRailListener;
import me.gallowsdove.foxymachines.listeners.BowListener;
import me.gallowsdove.foxymachines.listeners.ChunkLoaderListener;
import me.gallowsdove.foxymachines.listeners.ForcefieldListener;
import me.gallowsdove.foxymachines.listeners.PoseidonsFishingRodListener;
import me.gallowsdove.foxymachines.listeners.PositionSelectorListener;
import me.gallowsdove.foxymachines.listeners.RemoteControllerListener;
import me.gallowsdove.foxymachines.listeners.SacrificialAltarListener;
import me.gallowsdove.foxymachines.listeners.SwordListener;
import me.gallowsdove.foxymachines.tasks.GhostBlockTask;
import me.gallowsdove.foxymachines.tasks.MobTicker;
import me.gallowsdove.foxymachines.tasks.QuestTicker;

public class FoxyMachines
extends AbstractAddon {
    private static FoxyMachines instance;
    public String folderPath;

    public FoxyMachines() {
        super("GallowsDove", "FoxyMachines", "master", "auto-update");
    }

    @Override
    public void enable() {
        instance = this;
        Events.registerListener(new ChunkLoaderListener());
        Events.registerListener(new BoostedRailListener());
        Events.registerListener(new BerryBushListener());
        Events.registerListener(new ForcefieldListener());
        Events.registerListener(new RemoteControllerListener());
        Events.registerListener(new SacrificialAltarListener());
        Events.registerListener(new SwordListener());
        Events.registerListener(new PoseidonsFishingRodListener());
        Events.registerListener(new ArmorListener());
        Events.registerListener(new BowListener());
        Events.registerListener(new PositionSelectorListener());
        ItemSetup.INSTANCE.init();
        ResearchSetup.INSTANCE.init();
        this.folderPath = this.getDataFolder().getAbsolutePath() + File.separator + "data-storage" + File.separator;
        BerryBushTrimmer.loadTrimmedBlocks();
        ForcefieldDome.loadDomeLocations();
        Scheduler.run(() -> ForcefieldDome.INSTANCE.setupDomes());
        Scheduler.repeat(240, 10, new QuestTicker());
        Scheduler.repeat(100, (Runnable)((Object)new GhostBlockTask()));
        if (this.getConfig().getBoolean("custom-mobs")) {
            Scheduler.repeat(2, new MobTicker());
        }
        new Metrics(this, 10568);
        this.getAddonCommand().addSub(new KillallCommand()).addSub(new QuestCommand()).addSub(new SacrificialAltarCommand()).addSub(new SummonCommand());
    }

    @Override
    public void disable() {
        BerryBushTrimmer.saveTrimmedBlocks();
        ForcefieldDome.saveDomeLocations();
        if (this.getConfig().getBoolean("custom-mobs")) {
            CustomBoss.removeBossBars();
        }
    }

    @Nonnull
    public static FoxyMachines getInstance() {
        return instance;
    }
}

