/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.infinitylib.persistence;

import javax.annotation.Nonnull;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;

final class PersistentStackArray
implements PersistentDataType<String, ItemStack[]> {
    PersistentStackArray() {
    }

    @Nonnull
    public Class<String> getPrimitiveType() {
        return String.class;
    }

    @Nonnull
    public Class<ItemStack[]> getComplexType() {
        return ItemStack[].class;
    }

    @Nonnull
    public String toPrimitive(@Nonnull ItemStack[] complex, @Nonnull PersistentDataAdapterContext context) {
        YamlConfiguration config = new YamlConfiguration();
        config.set("length", (Object)complex.length);
        for (int i = 0; i < complex.length; ++i) {
            config.set(String.valueOf(i), (Object)complex[i]);
        }
        return config.saveToString();
    }

    @Nonnull
    public ItemStack[] fromPrimitive(@Nonnull String primitive, @Nonnull PersistentDataAdapterContext context) {
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.loadFromString(primitive);
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
            return new ItemStack[0];
        }
        ItemStack[] arr = new ItemStack[config.getInt("length")];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = config.getItemStack(String.valueOf(i));
        }
        return arr;
    }
}

