/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.implementation.machines;

import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.gallowsdove.foxymachines.FoxyMachines;
import me.gallowsdove.foxymachines.Items;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ElectricGoldRefinery
extends SlimefunItem
implements EnergyNetComponent {
    private static final int[] BORDER = new int[]{2, 3, 4, 5, 6, 7, 8, 14, 23, 32, 41, 47, 48, 49, 50, 51, 52, 53};
    private static final int[] BORDER_IN = new int[]{11, 12, 13, 20, 22, 29, 31, 38, 39, 40};
    private static final int[] BORDER_OUT = new int[]{15, 16, 17, 24, 26, 33, 35, 42, 43, 44};
    private static final int[] GOLD_INDEXES = new int[]{0, 9, 18, 27, 36, 45, 1, 10, 19, 28, 37, 46};
    private static final ItemStack[] GOLDS = new ItemStack[]{SlimefunItems.GOLD_4K, SlimefunItems.GOLD_6K, SlimefunItems.GOLD_8K, SlimefunItems.GOLD_10K, SlimefunItems.GOLD_12K, SlimefunItems.GOLD_14K, SlimefunItems.GOLD_16K, SlimefunItems.GOLD_18K, SlimefunItems.GOLD_20K, SlimefunItems.GOLD_22K, SlimefunItems.GOLD_24K};
    public static final int ENERGY_CONSUMPTION = 36;
    public static final int CAPACITY = 512;
    public static Map<Block, MachineRecipe> processing = new HashMap<Block, MachineRecipe>();
    public static Map<Block, Integer> progress = new HashMap<Block, Integer>();

    public ElectricGoldRefinery() {
        super(Items.CATEGORY, Items.ELECTRIC_GOLD_REFINERY, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{SlimefunItems.HARDENED_METAL_INGOT, SlimefunItems.ELECTRIC_MOTOR, SlimefunItems.HARDENED_METAL_INGOT, SlimefunItems.HEATING_COIL, SlimefunItems.ELECTRIC_SMELTERY, SlimefunItems.HEATING_COIL, SlimefunItems.HARDENED_METAL_INGOT, SlimefunItems.MEDIUM_CAPACITOR, SlimefunItems.HARDENED_METAL_INGOT});
        new BlockMenuPreset(this.getId(), "&6Electric Gold Refinery"){

            public void init() {
                ElectricGoldRefinery.this.constructMenu(this);
            }

            public void newInstance(@Nonnull BlockMenu menu, @Nonnull Block b) {
                int i = 0;
                while (i < 12) {
                    int j = i++;
                    menu.addMenuClickHandler(GOLD_INDEXES[j], (p, slot, item, action) -> {
                        BlockStorage.addBlockInfo((Block)b, (String)"gold_recipe", (String)Integer.toString(j));
                        this.newInstance(menu, b);
                        return false;
                    });
                }
                if (!BlockStorage.hasBlockInfo((Block)b) || BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"gold_recipe") == null || BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"gold_recipe").equals("11")) {
                    menu.replaceExistingItem(32, (ItemStack)new CustomItem(Material.RED_STAINED_GLASS_PANE, "&6Current Recipe: &cNONE", new String[]{"", "&e> Choose on the left to change it"}));
                } else {
                    switch (BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"gold_recipe")) {
                        case "0": {
                            menu.replaceExistingItem(32, (ItemStack)new CustomItem(Material.GOLD_INGOT, "&6Current Recipe: &fGold Ingot &7(4 Carat)", new String[]{"", "&e> Choose on the left to change it"}));
                            break;
                        }
                        case "1": {
                            menu.replaceExistingItem(32, (ItemStack)new CustomItem(Material.GOLD_INGOT, "&6Current Recipe: &fGold Ingot &7(6 Carat)", new String[]{"", "&e> Choose on the left to change it"}));
                            break;
                        }
                        case "2": {
                            menu.replaceExistingItem(32, (ItemStack)new CustomItem(Material.GOLD_INGOT, "&6Current Recipe: &fGold Ingot &7(8 Carat)", new String[]{"", "&e> Choose on the left to change it"}));
                            break;
                        }
                        case "3": {
                            menu.replaceExistingItem(32, (ItemStack)new CustomItem(Material.GOLD_INGOT, "&6Current Recipe: &fGold Ingot &7(10 Carat)", new String[]{"", "&e> Choose on the left to change it"}));
                            break;
                        }
                        case "4": {
                            menu.replaceExistingItem(32, (ItemStack)new CustomItem(Material.GOLD_INGOT, "&6Current Recipe: &fGold Ingot &7(12 Carat)", new String[]{"", "&e> Choose on the left to change it"}));
                            break;
                        }
                        case "5": {
                            menu.replaceExistingItem(32, (ItemStack)new CustomItem(Material.GOLD_INGOT, "&6Current Recipe: &fGold Ingot &7(14 Carat)", new String[]{"", "&e> Choose on the left to change it"}));
                            break;
                        }
                        case "6": {
                            menu.replaceExistingItem(32, (ItemStack)new CustomItem(Material.GOLD_INGOT, "&6Current Recipe: &fGold Ingot &7(16 Carat)", new String[]{"", "&e> Choose on the left to change it"}));
                            break;
                        }
                        case "7": {
                            menu.replaceExistingItem(32, (ItemStack)new CustomItem(Material.GOLD_INGOT, "&6Current Recipe: &fGold Ingot &7(18 Carat)", new String[]{"", "&e> Choose on the left to change it"}));
                            break;
                        }
                        case "8": {
                            menu.replaceExistingItem(32, (ItemStack)new CustomItem(Material.GOLD_INGOT, "&6Current Recipe: &fGold Ingot &7(20 Carat)", new String[]{"", "&e> Choose on the left to change it"}));
                            break;
                        }
                        case "9": {
                            menu.replaceExistingItem(32, (ItemStack)new CustomItem(Material.GOLD_INGOT, "&6Current Recipe: &fGold Ingot &7(22 Carat)", new String[]{"", "&e> Choose on the left to change it"}));
                            break;
                        }
                        case "10": {
                            menu.replaceExistingItem(32, (ItemStack)new CustomItem(Material.GOLD_INGOT, "&6Current Recipe: &fGold Ingot &7(24 Carat)", new String[]{"", "&e> Choose on the left to change it"}));
                            break;
                        }
                        case "11": {
                            menu.replaceExistingItem(32, (ItemStack)new CustomItem(Material.RED_STAINED_GLASS_PANE, "&6Current Recipe: &cNONE", new String[]{"", "&e> Choose on the left to change it"}));
                        }
                    }
                }
            }

            public boolean canOpen(@Nonnull Block b, @Nonnull Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), ProtectableAction.INTERACT_BLOCK);
            }

            public int[] getSlotsAccessedByItemTransport(@Nonnull ItemTransportFlow flow) {
                return new int[0];
            }

            public int[] getSlotsAccessedByItemTransport(@Nonnull DirtyChestMenu menu, @Nonnull ItemTransportFlow flow, @Nonnull ItemStack item) {
                if (flow == ItemTransportFlow.WITHDRAW) {
                    return ElectricGoldRefinery.this.getOutputSlots();
                }
                LinkedList<Integer> slots = new LinkedList<Integer>();
                for (int slot : ElectricGoldRefinery.this.getInputSlots()) {
                    ItemStack stack = menu.getItemInSlot(slot);
                    if (stack != null) {
                        if (!SlimefunUtils.isItemSimilar((ItemStack)stack, (ItemStack)item, (boolean)true, (boolean)false) || stack.getAmount() >= stack.getMaxStackSize()) continue;
                        slots.add(slot);
                        continue;
                    }
                    slots.add(slot);
                }
                if (slots.isEmpty()) {
                    return ElectricGoldRefinery.this.getInputSlots();
                }
                int[] array = new int[slots.size()];
                for (int i = 0; i < slots.size(); ++i) {
                    array[i] = (Integer)slots.get(i);
                }
                return array;
            }
        };
    }

    public int[] getInputSlots() {
        return new int[]{21, 30};
    }

    public int[] getOutputSlots() {
        return new int[]{25, 34};
    }

    @Nonnull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getCapacity() {
        return 512;
    }

    public int getEnergyConsumption() {
        return 36;
    }

    public ItemStack getProgressBar() {
        return new ItemStack(Material.GOLDEN_CHESTPLATE);
    }

    public MachineRecipe getProcessing(Block b) {
        return processing.get(b);
    }

    public boolean isProcessing(Block b) {
        return this.getProcessing(b) != null;
    }

    private BlockBreakHandler onBreak() {
        return new BlockBreakHandler(false, false){

            public void onPlayerBreak(@Nonnull BlockBreakEvent e, @Nonnull ItemStack item, @Nonnull List<ItemStack> drops) {
                Block b = e.getBlock();
                BlockMenu inv = BlockStorage.getInventory((Block)b);
                if (inv != null) {
                    inv.dropItems(b.getLocation(), ElectricGoldRefinery.this.getOutputSlots());
                    inv.dropItems(b.getLocation(), ElectricGoldRefinery.this.getInputSlots());
                }
            }
        };
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public void tick(@Nonnull Block b, @Nonnull SlimefunItem sf, @Nonnull Config data) {
                ElectricGoldRefinery.this.tick(b);
            }

            public boolean isSynchronized() {
                return false;
            }
        }, this.onBreak()});
    }

    protected void tick(@Nonnull Block b) {
        BlockMenu inv = BlockStorage.getInventory((Block)b);
        if (this.isProcessing(b)) {
            int timeleft = progress.get(b);
            if (timeleft > 0) {
                ChestMenuUtils.updateProgressbar((ChestMenu)inv, (int)23, (int)timeleft, (int)processing.get(b).getTicks(), (ItemStack)this.getProgressBar());
                if (this.isChargeable()) {
                    if (this.getCharge(b.getLocation()) < this.getEnergyConsumption()) {
                        return;
                    }
                    this.removeCharge(b.getLocation(), this.getEnergyConsumption());
                }
                progress.put(b, timeleft - 1);
            } else {
                inv.replaceExistingItem(23, (ItemStack)new CustomItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]));
                for (ItemStack output : processing.get(b).getOutput()) {
                    inv.pushItem(output.clone(), this.getOutputSlots());
                }
                progress.remove(b);
                processing.remove(b);
            }
        } else {
            MachineRecipe next = this.findNextRecipe(inv, BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"gold_recipe"));
            if (next != null) {
                processing.put(b, next);
                progress.put(b, next.getTicks());
            }
        }
    }

    @Nullable
    protected MachineRecipe findNextRecipe(@Nonnull BlockMenu menu, @Nullable String g) {
        if (g == null || Integer.parseInt(g) == 11) {
            return null;
        }
        int[] inputSlots = this.getInputSlots();
        ItemStack goldDust1 = menu.getItemInSlot(inputSlots[0]);
        ItemStack goldDust2 = menu.getItemInSlot(inputSlots[1]);
        ArrayList<Object> goldDustList = new ArrayList<Object>();
        if (goldDust1 != null && SlimefunUtils.isItemSimilar((ItemStack)goldDust1, (ItemStack)SlimefunItems.GOLD_DUST, (boolean)true, (boolean)false)) {
            goldDustList.add(goldDust1);
        } else {
            goldDustList.add(new SlimefunItemStack(SlimefunItems.GOLD_DUST, 0));
        }
        if (goldDust2 != null && SlimefunUtils.isItemSimilar((ItemStack)goldDust2, (ItemStack)SlimefunItems.GOLD_DUST, (boolean)true, (boolean)false)) {
            goldDustList.add(goldDust2);
        } else {
            goldDustList.add(new SlimefunItemStack(SlimefunItems.GOLD_DUST, 0));
        }
        int goldDusts = 0;
        int goldTier = Integer.parseInt(g);
        for (ItemStack itemStack : goldDustList) {
            goldDusts += itemStack.getAmount();
        }
        int goldCost = goldTier + 1;
        if (goldDusts >= goldCost) {
            ItemStack itemStack = GOLDS[goldTier];
            if (!menu.fits(itemStack, this.getOutputSlots())) {
                return null;
            }
            for (int i = 0; i < goldDustList.size(); ++i) {
                if (((ItemStack)goldDustList.get(i)).getAmount() == 0) continue;
                if (((ItemStack)goldDustList.get(i)).getAmount() >= goldCost) {
                    menu.consumeItem(inputSlots[i], goldCost);
                    break;
                }
                menu.consumeItem(inputSlots[i], ((ItemStack)goldDustList.get(i)).getAmount());
                goldCost -= ((ItemStack)goldDustList.get(i)).getAmount();
            }
            return new MachineRecipe((int)(3.0 + 0.5 * (double)goldTier), new ItemStack[]{new SlimefunItemStack(SlimefunItems.GOLD_DUST, goldTier)}, new ItemStack[]{itemStack});
        }
        return null;
    }

    protected void constructMenu(@Nonnull BlockMenuPreset preset) {
        for (int i : BORDER) {
            preset.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : BORDER_IN) {
            preset.addItem(i, (ItemStack)new SlimefunItemStack("_UI_INPUT_SLOT", Material.CYAN_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : BORDER_OUT) {
            preset.addItem(i, (ItemStack)new SlimefunItemStack("_UI_OUTPUT_SLOT", Material.ORANGE_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        preset.addItem(23, (ItemStack)new CustomItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        preset.addItem(46, (ItemStack)new CustomItem(Material.RED_STAINED_GLASS_PANE, "&cNONE", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        NamespacedKey key = new NamespacedKey((Plugin)FoxyMachines.getInstance(), "nonstackable");
        for (int i = 0; i < GOLDS.length; ++i) {
            ItemStack itemStack = GOLDS[i].clone();
            ItemMeta itemMeta = itemStack.getItemMeta();
            Byte value = 1;
            itemMeta.getPersistentDataContainer().set(key, PersistentDataType.BYTE, (Object)value);
            itemStack.setItemMeta(itemMeta);
            preset.addItem(GOLD_INDEXES[i], itemStack, ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : this.getOutputSlots()) {
            preset.addMenuClickHandler(i, (ChestMenu.MenuClickHandler)new ChestMenu.AdvancedMenuClickHandler(){

                public boolean onClick(Player p, int slot, ItemStack cursor, ClickAction action) {
                    return false;
                }

                public boolean onClick(InventoryClickEvent e, Player p, int slot, ItemStack cursor, ClickAction action) {
                    return cursor == null || cursor.getType() == Material.AIR;
                }
            });
        }
    }
}

