/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.implementation.mobs;

import java.util.Collection;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import me.gallowsdove.foxymachines.FoxyMachines;
import me.gallowsdove.foxymachines.Items;
import me.gallowsdove.foxymachines.abstracts.CustomBoss;
import me.gallowsdove.foxymachines.abstracts.CustomMob;
import me.gallowsdove.foxymachines.utils.Utils;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class HeadlessHorseman
extends CustomBoss {
    private static final NamespacedKey PATTERN_KEY = new NamespacedKey((Plugin)FoxyMachines.getInstance(), "pattern");

    public HeadlessHorseman() {
        super("HEADLESS_HORSEMAN", ChatColor.RED + "Headless Horseman", EntityType.SKELETON, 1, EntityDamageEvent.DamageCause.BLOCK_EXPLOSION, EntityDamageEvent.DamageCause.ENTITY_EXPLOSION, EntityDamageEvent.DamageCause.THORNS);
    }

    @Override
    public void onSpawn(@Nonnull LivingEntity spawned) {
        super.onSpawn(spawned);
        spawned.setInvisible(true);
        CustomMob mob = CustomMob.getByID("SKELETON_HORSE");
        SkeletonHorse horse = (SkeletonHorse)mob.spawn(spawned.getLocation());
        horse.addPassenger((Entity)spawned);
        EntityEquipment equipment = spawned.getEquipment();
        equipment.setArmorContents(new ItemStack[]{new ItemStack(Material.NETHERITE_BOOTS), new ItemStack(Material.NETHERITE_LEGGINGS), new ItemStack(Material.NETHERITE_CHESTPLATE), new ItemStack(Material.CARVED_PUMPKIN)});
        spawned.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(28.0);
        spawned.getPersistentDataContainer().set(PATTERN_KEY, PersistentDataType.SHORT, (Object)AttackPattern.LIGHTNING);
    }

    @Override
    @Nonnull
    protected CustomBoss.BossBarStyle getBossBarStyle() {
        return new CustomBoss.BossBarStyle("Headless Horseman", BarColor.RED, BarStyle.SOLID, BarFlag.PLAY_BOSS_MUSIC);
    }

    @Override
    protected void onTarget(@Nonnull EntityTargetEvent e) {
        if (!(e.getTarget() instanceof Player)) {
            e.setCancelled(true);
        }
    }

    @Override
    protected void onAttack(@Nonnull EntityDamageByEntityEvent e) {
        if (!e.isCancelled()) {
            Utils.dealDamageBypassingArmor((LivingEntity)e.getEntity(), (e.getDamage() - e.getFinalDamage()) * 0.12);
        }
    }

    @Override
    public void onBossPattern(@Nonnull LivingEntity mob) {
        super.onBossPattern(mob);
        short pattern = (short)ThreadLocalRandom.current().nextInt(7);
        if (pattern < 2) {
            pattern = AttackPattern.LIGHTNING;
        } else if (pattern < 5) {
            pattern = AttackPattern.SHOOT;
            if (mob.isInsideVehicle() && mob.getVehicle() instanceof LivingEntity) {
                ((LivingEntity)mob.getVehicle()).addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 100, 100));
            }
        } else {
            pattern = AttackPattern.SUMMON;
        }
        mob.getPersistentDataContainer().set(PATTERN_KEY, PersistentDataType.SHORT, (Object)pattern);
    }

    @Override
    public void onBossDamaged(@Nonnull EntityDamageEvent e) {
        super.onBossDamaged(e);
        Skeleton headlessHorseman = (Skeleton)e.getEntity();
        if (headlessHorseman.isInsideVehicle()) {
            e.setCancelled(true);
        }
    }

    @Override
    public void onMobTick(@Nonnull LivingEntity entity, int tick) {
        Skeleton headlessHorseman = (Skeleton)entity;
        short pattern = (Short)entity.getPersistentDataContainer().get(PATTERN_KEY, PersistentDataType.SHORT);
        if ((tick + 4) % 5 == 0) {
            Collection entities = headlessHorseman.getWorld().getNearbyEntities(headlessHorseman.getLocation(), 30.0, 20.0, 30.0);
            for (Entity player : entities) {
                if (!(player instanceof Player) || ((Player)player).getGameMode() != GameMode.SURVIVAL) continue;
                headlessHorseman.setTarget((LivingEntity)player);
            }
        }
        if (pattern == AttackPattern.SHOOT) {
            if (headlessHorseman.getTarget() != null) {
                Player target = (Player)headlessHorseman.getTarget();
                if (tick % 5 == 0) {
                    Arrow arrow = (Arrow)entity.launchProjectile(Arrow.class);
                    arrow.setDamage(22.0);
                    arrow.setColor(Color.RED);
                    arrow.setGlowing(true);
                    arrow.setSilent(true);
                    arrow.setGravity(false);
                    try {
                        arrow.setVelocity(target.getLocation().toVector().subtract(headlessHorseman.getLocation().toVector()).normalize().multiply(1.64));
                    }
                    catch (IllegalArgumentException player) {}
                }
            }
        } else if (pattern == AttackPattern.LIGHTNING) {
            if (headlessHorseman.getTarget() != null && tick % 8 == 0) {
                Player player = (Player)headlessHorseman.getTarget();
                Location loc = player.getLocation().clone();
                Location l = headlessHorseman.getLocation();
                if (Math.sqrt((loc.getX() - l.getX()) * (loc.getX() - l.getX()) + (loc.getY() - l.getY()) * (loc.getY() - l.getY()) + (loc.getZ() - l.getZ()) * (loc.getZ() - l.getZ())) < 26.0) {
                    FoxyMachines.getInstance().runSync(() -> {
                        loc.getWorld().strikeLightningEffect(loc);
                        if (player.isValid()) {
                            Location playerLoc = player.getLocation();
                            if (Math.sqrt((loc.getX() - playerLoc.getX()) * (loc.getX() - playerLoc.getX()) + (loc.getY() - playerLoc.getY()) * (loc.getY() - playerLoc.getY())) < 0.72) {
                                EntityDamageEvent e = new EntityDamageEvent((Entity)player, EntityDamageEvent.DamageCause.CUSTOM, 12.0);
                                Bukkit.getServer().getPluginManager().callEvent((Event)e);
                                if (!e.isCancelled()) {
                                    player.damage(12.4);
                                    Utils.dealDamageBypassingArmor((LivingEntity)player, 1.72);
                                }
                            }
                        }
                    }, 4L);
                }
            }
        } else if (pattern == AttackPattern.SUMMON && tick == 25) {
            this.spawnHelldogs(headlessHorseman.getLocation());
        }
    }

    @Override
    public void onDeath(@Nonnull EntityDeathEvent e) {
        super.onDeath(e);
        e.getDrops().clear();
        Location loc = e.getEntity().getLocation();
        loc.getWorld().dropItemNaturally(loc, (ItemStack)new SlimefunItemStack(Items.VILE_PUMPKIN, 1));
        ((ExperienceOrb)loc.getWorld().spawn(loc, ExperienceOrb.class)).setExperience(2000 + ThreadLocalRandom.current().nextInt(800));
    }

    private void spawnHelldogs(Location loc) {
        int i;
        CustomMob mob = CustomMob.getByID("HELLDOG");
        assert (mob != null);
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (i = 0; i < 3; ++i) {
            mob.spawn(new Location(loc.getWorld(), loc.getX() + random.nextDouble(-1.0, 1.0), loc.getY() + random.nextDouble(0.6, 1.2), loc.getZ() + random.nextDouble(-1.0, 1.0)));
        }
        for (i = 0; i < 20; ++i) {
            loc.getWorld().spawnParticle(Particle.FLAME, loc, 1, random.nextDouble(-1.5, 1.5), random.nextDouble(-1.2, 2.4), random.nextDouble(-1.5, 1.5), 0.0);
        }
    }

    public static class AttackPattern {
        public static short LIGHTNING = 0;
        public static short SHOOT = 1;
        public static short SUMMON = (short)2;
    }
}

