/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import me.gallowsdove.foxymachines.ItemSetup;
import me.gallowsdove.foxymachines.ResearchSetup;
import me.gallowsdove.foxymachines.abstracts.CustomBoss;
import me.gallowsdove.foxymachines.commands.KillallCommand;
import me.gallowsdove.foxymachines.commands.QuestCommand;
import me.gallowsdove.foxymachines.commands.SacrificialAltarCommand;
import me.gallowsdove.foxymachines.commands.SummonCommand;
import me.gallowsdove.foxymachines.implementation.machines.ForcefieldDome;
import me.gallowsdove.foxymachines.implementation.tools.BerryBushTrimmer;
import me.gallowsdove.foxymachines.infinitylib.AbstractAddon;
import me.gallowsdove.foxymachines.infinitylib.bstats.bukkit.Metrics;
import me.gallowsdove.foxymachines.infinitylib.commands.AbstractCommand;
import me.gallowsdove.foxymachines.listeners.ArmorListener;
import me.gallowsdove.foxymachines.listeners.BerryBushListener;
import me.gallowsdove.foxymachines.listeners.BoostedRailListener;
import me.gallowsdove.foxymachines.listeners.BowListener;
import me.gallowsdove.foxymachines.listeners.ChunkLoaderListener;
import me.gallowsdove.foxymachines.listeners.ForcefieldListener;
import me.gallowsdove.foxymachines.listeners.PoseidonsFishingRodListener;
import me.gallowsdove.foxymachines.listeners.RemoteControllerListener;
import me.gallowsdove.foxymachines.listeners.SacrificialAltarListener;
import me.gallowsdove.foxymachines.listeners.SwordListener;
import me.gallowsdove.foxymachines.tasks.GhostBlockTask;
import me.gallowsdove.foxymachines.tasks.MobTicker;
import me.gallowsdove.foxymachines.tasks.QuestTicker;

public class FoxyMachines
extends AbstractAddon {
    private static FoxyMachines instance;
    public String folderPath;

    @Override
    public void enable() {
        instance = this;
        this.registerListener(new ChunkLoaderListener(), new BoostedRailListener(), new BerryBushListener(), new ForcefieldListener(), new RemoteControllerListener(), new SacrificialAltarListener(), new SwordListener(), new PoseidonsFishingRodListener(), new ArmorListener(), new BowListener());
        ItemSetup.INSTANCE.init();
        ResearchSetup.INSTANCE.init();
        this.folderPath = this.getDataFolder().getAbsolutePath() + File.separator + "data-storage" + File.separator;
        BerryBushTrimmer.loadTrimmedBlocks();
        ForcefieldDome.loadDomeLocations();
        this.runSync(() -> ForcefieldDome.INSTANCE.setupDomes());
        this.scheduleRepeatingAsync(new QuestTicker(), 10L, 240L);
        this.scheduleRepeatingSync((Runnable)((Object)new GhostBlockTask()), 100L);
        if (this.getConfig().getBoolean("custom-mobs")) {
            this.scheduleRepeatingSync(new MobTicker(), 2L);
        }
    }

    @Override
    protected Metrics setupMetrics() {
        return new Metrics(this, 8991);
    }

    @Override
    @Nonnull
    protected String getGithubPath() {
        return "GallowsDove/FoxyMachines/master";
    }

    @Override
    protected List<AbstractCommand> setupSubCommands() {
        ArrayList<AbstractCommand> commands = new ArrayList<AbstractCommand>(Arrays.asList(new QuestCommand(), new SacrificialAltarCommand()));
        if (this.getConfig().getBoolean("custom-mobs")) {
            commands.add(new SummonCommand());
            commands.add(new KillallCommand());
        }
        return commands;
    }

    @Override
    public void disable() {
        BerryBushTrimmer.saveTrimmedBlocks();
        ForcefieldDome.saveDomeLocations();
        if (this.getConfig().getBoolean("custom-mobs")) {
            CustomBoss.removeBossBars();
        }
    }

    @Override
    public String getAutoUpdatePath() {
        return "auto-update";
    }

    @Nonnull
    public static FoxyMachines getInstance() {
        return instance;
    }
}

