/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.implementation.mobs;

import java.util.Collection;
import javax.annotation.Nonnull;
import me.gallowsdove.foxymachines.abstracts.CustomMob;
import me.gallowsdove.foxymachines.utils.Utils;
import org.bukkit.DyeColor;
import org.bukkit.GameMode;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;

public class Helldog
extends CustomMob {
    public Helldog() {
        super("HELLDOG", "Helldog", EntityType.WOLF, 52);
    }

    @Override
    public void onSpawn(@Nonnull LivingEntity spawned) {
        Wolf wolf = (Wolf)spawned;
        wolf.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(28.0);
        wolf.setRemoveWhenFarAway(true);
        wolf.setAngry(true);
        wolf.setCollarColor(DyeColor.RED);
    }

    @Override
    public void onMobTick(@Nonnull LivingEntity entity, int tick) {
        Wolf helldog = (Wolf)entity;
        Collection entities = helldog.getWorld().getNearbyEntities(helldog.getLocation(), 1.54, 1.54, 1.54);
        for (Entity player : entities) {
            if (!(player instanceof Player) || ((Player)player).getGameMode() != GameMode.SURVIVAL || tick % 10 != 0) continue;
            helldog.attack(player);
        }
        if (tick % 20 == 0) {
            entities = helldog.getWorld().getNearbyEntities(helldog.getLocation(), 16.0, 16.0, 16.0);
            for (Entity player : entities) {
                if (!(player instanceof Player) || ((Player)player).getGameMode() != GameMode.SURVIVAL) continue;
                helldog.setTarget((LivingEntity)player);
            }
        }
    }

    @Override
    public void onDeath(@Nonnull EntityDeathEvent e) {
        e.getDrops().clear();
    }

    @Override
    protected void onAttack(@Nonnull EntityDamageByEntityEvent e) {
        if (!e.isCancelled()) {
            Utils.dealDamageBypassingArmor((LivingEntity)e.getEntity(), (e.getDamage() - e.getFinalDamage()) * 0.2);
        }
    }

    @Override
    protected void onTarget(@Nonnull EntityTargetEvent e) {
        if (!(e.getTarget() instanceof Player)) {
            e.setCancelled(true);
        }
    }
}

