/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.infinitylib;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import me.gallowsdove.foxymachines.infinitylib.bstats.bukkit.Metrics;
import me.gallowsdove.foxymachines.infinitylib.commands.AbstractCommand;
import me.gallowsdove.foxymachines.infinitylib.slimefun.utils.TickerUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Config;
import me.mrCookieSlime.Slimefun.cscorelib2.updater.GitHubBuildsUpdater;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class AbstractAddon
extends JavaPlugin
implements SlimefunAddon {
    private int globalTick = 0;
    private Metrics metrics;

    @OverridingMethodsMustInvokeSuper
    public void onEnable() {
        this.scheduleRepeatingSync(() -> ++this.globalTick, TickerUtils.TICKS);
        PluginCommand command = Objects.requireNonNull(this.getCommand(this.getName().toLowerCase(Locale.ROOT)), "Make sure to set a command with the plugin's name in your plugin.yml");
        ArrayList<AbstractCommand> commands = new ArrayList<AbstractCommand>(this.getSubCommands());
        commands.add(new AddonInfoCommand(this));
        new CommandHelper(command, commands);
        if (SlimefunPlugin.getMinecraftVersion() != MinecraftVersion.UNIT_TEST) {
            this.saveDefaultConfig();
            Objects.requireNonNull(this.getConfig().getDefaults()).set("auto-update", (Object)true);
            for (String key : this.getConfig().getKeys(true)) {
                if (this.getConfig().getDefaults().contains(key)) continue;
                this.getConfig().set(key, null);
            }
            this.getConfig().options().copyDefaults(true).copyHeader(true);
            this.saveConfig();
            if (this.getConfig().getBoolean("auto-update")) {
                if (this.getDescription().getVersion().startsWith("DEV - ")) {
                    new GitHubBuildsUpdater((Plugin)this, this.getFile(), this.getGithubPath()).start();
                }
            } else {
                this.runSync(() -> this.log("#######################################", "Auto Updates have been disabled for " + this.getName(), "You will receive no support for bugs", "Until you update to the latest version!", "#######################################"));
            }
            if (this.getMetricsID() != -1) {
                this.metrics = new Metrics((Plugin)this, this.getMetricsID());
                this.metrics.addCustomChart(new Metrics.SimplePie("auto_updates", () -> String.valueOf(this.getConfig().getBoolean("auto-update"))));
            }
        }
    }

    protected abstract int getMetricsID();

    protected abstract String getGithubPath();

    protected abstract List<AbstractCommand> getSubCommands();

    @Nonnull
    public final JavaPlugin getJavaPlugin() {
        return this;
    }

    @Nonnull
    public final String getBugTrackerURL() {
        return "https://github.com/" + this.getGithubPath().substring(0, this.getGithubPath().lastIndexOf(47)) + "/issues";
    }

    public final void log(String ... messages) {
        this.log(Level.INFO, messages);
    }

    public final void log(Level level, String ... messages) {
        for (String msg : messages) {
            this.getLogger().log(level, msg);
        }
    }

    public final void registerListener(Listener ... listeners) {
        for (Listener listener : listeners) {
            Bukkit.getPluginManager().registerEvents(listener, (Plugin)this);
        }
    }

    public final void runSync(Runnable runnable) {
        Bukkit.getScheduler().runTask((Plugin)this, runnable);
    }

    public final void runSync(Runnable runnable, long delay) {
        Bukkit.getScheduler().runTaskLater((Plugin)this, runnable, delay);
    }

    public final void scheduleRepeatingSync(Runnable runnable, long interval) {
        Bukkit.getScheduler().runTaskTimer((Plugin)this, runnable, 0L, interval);
    }

    public final void scheduleRepeatingSync(Runnable runnable, long delay, long interval) {
        Bukkit.getScheduler().runTaskTimer((Plugin)this, runnable, delay, interval);
    }

    public final void runAsync(Runnable runnable) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, runnable);
    }

    public final void runAsync(Runnable runnable, long delay) {
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this, runnable, delay);
    }

    public final void scheduleRepeatingAsync(Runnable runnable, long interval) {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, runnable, 0L, interval);
    }

    public final void scheduleRepeatingAsync(Runnable runnable, long delay, long interval) {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, runnable, delay, interval);
    }

    public final void addSubCommands(String command, AbstractCommand ... commands) {
        new CommandHelper(Objects.requireNonNull(this.getCommand(command), () -> "No such command '" + command + "'!"), new ArrayList<AbstractCommand>(Arrays.asList(commands)));
    }

    public final NamespacedKey getKey(String s) {
        return new NamespacedKey((Plugin)this, s);
    }

    public final Config loadConfig(String name) {
        return new Config((Plugin)this, name);
    }

    public final Config loadConfigWithDefaults(String name) {
        return this.attachConfigDefaults(this.loadConfig(name), name);
    }

    public final Config attachConfigDefaults(Config config, String resource) {
        config.getConfiguration().setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(Objects.requireNonNull(this.getResource(resource), () -> "Failed to get default resource " + resource + "!"))));
        config.getConfiguration().options().copyDefaults(true).copyHeader(true);
        config.save();
        return config;
    }

    public final int getConfigInt(String path, int min, int max) {
        int val = this.getConfig().getInt(path);
        if (val < min || val > max) {
            val = Objects.requireNonNull(this.getConfig().getDefaults()).getInt(path);
            this.getConfig().set(path, (Object)val);
            this.log(Level.WARNING, "Config value at " + path + " was out of bounds, resetting to default!");
        }
        return val;
    }

    public final double getConfigDouble(String path, double min, double max) {
        double val = this.getConfig().getDouble(path);
        if (val < min || val > max) {
            val = Objects.requireNonNull(this.getConfig().getDefaults()).getDouble(path);
            this.getConfig().set(path, (Object)val);
            this.log(Level.WARNING, "Config value at " + path + " was out of bounds, resetting to default!");
        }
        return val;
    }

    public int getGlobalTick() {
        return this.globalTick;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    private static final class AddonInfoCommand
    extends AbstractCommand {
        private final String[] message;

        private AddonInfoCommand(AbstractAddon addon) {
            super("info", "Gives addon version information", false);
            this.message = new String[]{"", ChatColors.color((String)("&b" + addon.getName() + " Info")), ChatColors.color((String)("&bSlimefun Version: &7" + Objects.requireNonNull(SlimefunPlugin.instance()).getPluginVersion())), ChatColors.color((String)"&bSlimefun Discord: &7Discord.gg/slimefun"), ChatColors.color((String)("&bAddon Version: &7" + addon.getPluginVersion())), ChatColors.color((String)"&bAddon Community: &7Discord.gg/SqD3gg5SAU"), ChatColors.color((String)("&bGithub: &7" + addon.getBugTrackerURL())), ""};
        }

        @Override
        public void onExecute(@Nonnull CommandSender sender, @Nonnull String[] args) {
            sender.sendMessage(this.message);
        }

        @Override
        public void onTab(@Nonnull CommandSender sender, @Nonnull String[] args, @Nonnull List<String> tabs) {
        }
    }

    private static final class CommandHelper
    implements TabExecutor {
        private final Map<String, AbstractCommand> commands = new HashMap<String, AbstractCommand>();

        private CommandHelper(PluginCommand command, List<AbstractCommand> abstractCommands) {
            command.setExecutor((CommandExecutor)this);
            command.setTabCompleter((TabCompleter)this);
            abstractCommands.add(new HelpCommand(command));
            for (AbstractCommand abstractCommand : abstractCommands) {
                this.commands.put(abstractCommand.name, abstractCommand);
            }
        }

        public boolean onCommand(@Nonnull CommandSender sender, @Nonnull Command command, @Nonnull String label, @Nonnull String[] args) {
            AbstractCommand command1;
            if (args.length > 0 && (command1 = this.commands.get(args[0])) != null && command1.hasPerm(sender)) {
                command1.onExecute(sender, args);
                return true;
            }
            return false;
        }

        public List<String> onTabComplete(@Nonnull CommandSender sender, @Nonnull Command command, @Nonnull String alias, String[] args) {
            AbstractCommand command1;
            if (args.length == 1) {
                ArrayList<String> strings = new ArrayList<String>();
                for (AbstractCommand command12 : this.commands.values()) {
                    if (!command12.hasPerm(sender)) continue;
                    strings.add(command12.name);
                }
                return CommandHelper.createReturnList(strings, args[0]);
            }
            if (args.length > 1 && (command1 = this.commands.get(args[0])) != null && command1.hasPerm(sender)) {
                ArrayList<String> strings = new ArrayList<String>();
                command1.onTab(sender, args, strings);
                return CommandHelper.createReturnList(strings, args[args.length - 1]);
            }
            return Collections.emptyList();
        }

        @Nonnull
        private static List<String> createReturnList(@Nonnull List<String> strings, @Nonnull String string) {
            String input = string.toLowerCase(Locale.ROOT);
            LinkedList<String> returnList = new LinkedList<String>();
            for (String item : strings) {
                if (item.toLowerCase(Locale.ROOT).contains(input)) {
                    returnList.add(item);
                    if (returnList.size() < 64) continue;
                    break;
                }
                if (!item.equalsIgnoreCase(input)) continue;
                return Collections.emptyList();
            }
            return returnList;
        }

        private final class HelpCommand
        extends AbstractCommand
        implements Listener {
            private final String command;
            private final String help;
            private final String header;
            private final String aliases;

            private HelpCommand(PluginCommand command) {
                super("help", "Displays this", false);
                Bukkit.getPluginManager().registerEvents((Listener)this, command.getPlugin());
                this.help = "/help " + command.getName();
                this.command = ChatColor.GOLD + "/" + command.getName() + " ";
                this.aliases = ChatColors.color((String)("&6Aliases: &e" + command.getAliases()));
                this.header = ChatColors.color((String)("&7----------&b " + command.getPlugin().getName() + " Help &7----------"));
            }

            @Override
            public void onExecute(@Nonnull CommandSender sender, @Nonnull String[] args) {
                sender.sendMessage("");
                sender.sendMessage(this.header);
                sender.sendMessage("");
                for (AbstractCommand command : CommandHelper.this.commands.values()) {
                    if (!command.hasPerm(sender)) continue;
                    sender.sendMessage(this.command + command.name + ChatColor.YELLOW + " - " + command.description);
                }
                sender.sendMessage("");
                sender.sendMessage(this.aliases);
                sender.sendMessage("");
            }

            @Override
            public void onTab(@Nonnull CommandSender sender, @Nonnull String[] args, @Nonnull List<String> tabs) {
            }

            @EventHandler
            public void onCommand(PlayerCommandPreprocessEvent e) {
                if (e.getMessage().equalsIgnoreCase(this.help)) {
                    this.onExecute((CommandSender)e.getPlayer(), new String[0]);
                    e.setCancelled(true);
                }
            }
        }
    }
}

