/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.implementation.machines;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockUseHandler;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.gallowsdove.foxymachines.FoxyMachines;
import me.gallowsdove.foxymachines.Items;
import me.gallowsdove.foxymachines.utils.EmptySphereBlocks;
import me.gallowsdove.foxymachines.utils.SimpleLocation;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public final class ForcefieldDome
extends SlimefunItem
implements EnergyNetComponent {
    public static HashSet<Block> FORCEFIELD_BLOCKS = new HashSet();
    public static final int ENERGY_CONSUMPTION = 6000;
    private static final Set<Material> MATERIALS_TO_REPLACE = Set.of(Material.AIR, Material.CAVE_AIR, Material.WATER, Material.LAVA);
    public static ArrayList<SimpleLocation> domeLocations = new ArrayList();
    public static ForcefieldDome INSTANCE = new ForcefieldDome();

    public ForcefieldDome() {
        super(Items.CATEGORY, Items.FORCEFIELD_DOME, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{Items.SWEETENED_SWEET_INGOT, Items.FORCEFIELD_STABILIZER, Items.SWEETENED_SWEET_INGOT, Items.FORCEFIELD_STABILIZER, Items.FORCEFIELD_ENGINE, Items.FORCEFIELD_STABILIZER, Items.SWEETENED_SWEET_INGOT, Items.FORCEFIELD_STABILIZER, Items.SWEETENED_SWEET_INGOT});
        this.addItemHandler(new ItemHandler[]{this.onTick(), this.onPlace(), this.onUse(), this.onBreak()});
    }

    @Nonnull
    private BlockTicker onTick() {
        return new BlockTicker(){

            public void tick(@Nonnull Block b, @Nonnull SlimefunItem sf, @Nonnull Config data) {
                Location l = b.getLocation();
                String active = BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"active");
                if (ForcefieldDome.this.getCharge(l) <= 6000 && active.equals("true")) {
                    ForcefieldDome.this.setDomeInactive(b);
                }
                if (active.equals("true")) {
                    ForcefieldDome.this.removeCharge(l, 6000);
                }
            }

            public boolean isSynchronized() {
                return true;
            }
        };
    }

    @Nonnull
    private BlockPlaceHandler onPlace() {
        return new BlockPlaceHandler(false){

            public void onPlayerPlace(@Nonnull BlockPlaceEvent e) {
                Block b = e.getBlockPlaced();
                BlockStorage.addBlockInfo((Block)b, (String)"owner", (String)e.getPlayer().getUniqueId().toString());
                BlockStorage.addBlockInfo((Block)b, (String)"active", (String)"false");
                BlockStorage.addBlockInfo((Block)b, (String)"cooldown", (String)"false");
                domeLocations.add(new SimpleLocation(b));
                ForcefieldDome.saveDomeLocations();
            }
        };
    }

    @Nonnull
    private BlockBreakHandler onBreak() {
        return new BlockBreakHandler(false, false){

            public void onPlayerBreak(@Nonnull BlockBreakEvent e, @Nonnull ItemStack item, @Nonnull List<ItemStack> list) {
                Block b = e.getBlock();
                ForcefieldDome.this.setDomeInactive(b);
                SimpleLocation loc = new SimpleLocation(b);
                if (domeLocations.contains(loc)) {
                    domeLocations.remove(loc);
                    ForcefieldDome.saveDomeLocations();
                }
            }
        };
    }

    @Nonnull
    public BlockUseHandler onUse() {
        return new BlockUseHandler(){

            public void onRightClick(@Nonnull PlayerRightClickEvent e) {
                if (!SlimefunUtils.isItemSimilar((ItemStack)e.getPlayer().getInventory().getItemInMainHand(), (ItemStack)Items.REMOTE_CONTROLLER, (boolean)true, (boolean)false)) {
                    Block b = (Block)e.getClickedBlock().get();
                    if (BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"cooldown").equals("false")) {
                        String active = BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"active");
                        if (active.equals("false")) {
                            if (ForcefieldDome.this.getCharge(b.getLocation()) >= 6000) {
                                ForcefieldDome.this.setDomeActive(b);
                                e.getPlayer().sendMessage(ChatColor.LIGHT_PURPLE + "The dome has been activated.");
                                BlockStorage.addBlockInfo((Block)b, (String)"cooldown", (String)"true");
                                Bukkit.getScheduler().runTaskLater((Plugin)FoxyMachines.getInstance(), () -> BlockStorage.addBlockInfo((Block)b, (String)"cooldown", (String)"false"), 200L);
                            } else {
                                e.getPlayer().sendMessage(ChatColor.LIGHT_PURPLE + "You don't have enough energy.");
                            }
                        } else {
                            ForcefieldDome.this.setDomeInactive(b);
                            e.getPlayer().sendMessage(ChatColor.LIGHT_PURPLE + "The dome has been deactivated.");
                            BlockStorage.addBlockInfo((Block)b, (String)"cooldown", (String)"true");
                            Bukkit.getScheduler().runTaskLater((Plugin)FoxyMachines.getInstance(), () -> BlockStorage.addBlockInfo((Block)b, (String)"cooldown", (String)"false"), 200L);
                        }
                    } else {
                        e.getPlayer().sendMessage(ChatColor.LIGHT_PURPLE + "You must wait at least 10 seconds before activating the dome again.");
                    }
                    e.cancel();
                }
            }
        };
    }

    @Nonnull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getCapacity() {
        return 24000;
    }

    private void setDomeActive(@Nonnull Block b) {
        ArrayList<Block> domeBlocks = EmptySphereBlocks.get(b, 32);
        for (Block block : domeBlocks) {
            UUID uuid = UUID.fromString(BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"owner"));
            if (!SlimefunPlugin.getProtectionManager().hasPermission(Bukkit.getOfflinePlayer((UUID)uuid), block, ProtectableAction.BREAK_BLOCK)) continue;
            if (MATERIALS_TO_REPLACE.contains(block.getType())) {
                block.setType(Material.BARRIER);
                continue;
            }
            if (block.getType() == Material.BARRIER) continue;
            FORCEFIELD_BLOCKS.add(block);
        }
        BlockStorage.addBlockInfo((Block)b, (String)"active", (String)"true");
    }

    private void setDomeInactive(@Nonnull Block b) {
        ArrayList<Block> domeBlocks = EmptySphereBlocks.get(b, 32);
        for (Block block : domeBlocks) {
            UUID uuid = UUID.fromString(BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"owner"));
            if (!SlimefunPlugin.getProtectionManager().hasPermission(Bukkit.getOfflinePlayer((UUID)uuid), block, ProtectableAction.BREAK_BLOCK)) continue;
            if (block.getType() == Material.BARRIER) {
                block.setType(Material.AIR);
                continue;
            }
            FORCEFIELD_BLOCKS.remove(block);
        }
        BlockStorage.addBlockInfo((Block)b, (String)"active", (String)"false");
    }

    public void switchActive(@Nonnull Block b, @Nonnull Player p) {
        if (BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"cooldown").equals("false")) {
            String active = BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"active");
            if (active.equals("false")) {
                if (this.getCharge(b.getLocation()) >= 6000) {
                    this.setDomeActive(b);
                    p.sendMessage(ChatColor.LIGHT_PURPLE + "The dome has been activated.");
                    BlockStorage.addBlockInfo((Block)b, (String)"cooldown", (String)"true");
                    Bukkit.getScheduler().runTaskLater((Plugin)FoxyMachines.getInstance(), () -> BlockStorage.addBlockInfo((Block)b, (String)"cooldown", (String)"false"), 200L);
                } else {
                    p.sendMessage(ChatColor.LIGHT_PURPLE + "You don't have enough energy.");
                }
            } else {
                this.setDomeInactive(b);
                p.sendMessage(ChatColor.LIGHT_PURPLE + "The dome has been deactivated.");
                BlockStorage.addBlockInfo((Block)b, (String)"cooldown", (String)"true");
                Bukkit.getScheduler().runTaskLater((Plugin)FoxyMachines.getInstance(), () -> BlockStorage.addBlockInfo((Block)b, (String)"cooldown", (String)"false"), 200L);
            }
        } else {
            p.sendMessage(ChatColor.LIGHT_PURPLE + "You must wait at least 10 seconds before activating the dome again.");
        }
    }

    public void setupDomes() {
        for (SimpleLocation loc : domeLocations) {
            World w = Bukkit.getServer().getWorld(UUID.fromString(loc.getWorldUUID()));
            if (w == null) {
                domeLocations.remove(loc);
                continue;
            }
            Block b = w.getBlockAt(loc.getX(), loc.getY(), loc.getZ());
            if (BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"active").equals("true")) {
                this.setDomeActive(b);
            }
            BlockStorage.addBlockInfo((Block)b, (String)"cooldown", (String)"false");
        }
    }

    public static void saveDomeLocations() throws IOException {
        Gson gson = new Gson();
        String pluginFolder = FoxyMachines.getInstance().folderPath;
        File file = new File(pluginFolder + File.separator + "domedata");
        File filePath = new File(pluginFolder);
        filePath.mkdirs();
        if (!file.exists()) {
            file.createNewFile();
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(file, false));
        writer.write(gson.toJson(domeLocations));
        writer.close();
    }

    public static void loadDomeLocations() throws IOException {
        Gson gson = new Gson();
        File file = new File(FoxyMachines.getInstance().folderPath + "domedata");
        File filePath = new File(FoxyMachines.getInstance().folderPath);
        filePath.mkdirs();
        if (!file.exists()) {
            file.createNewFile();
        }
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String json = reader.readLine();
        reader.close();
        Type type = new TypeToken<ArrayList<SimpleLocation>>(){}.getType();
        domeLocations = (ArrayList)gson.fromJson(json, type);
        if (domeLocations == null) {
            domeLocations = new ArrayList();
        }
    }
}

