/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.infinitylib.slimefun.presets;

import java.text.DecimalFormat;
import javax.annotation.Nonnull;
import me.gallowsdove.foxymachines.infinitylib.core.PluginUtils;

public final class LorePreset {
    private static final DecimalFormat FORMAT = new DecimalFormat("###,###,###,###,###,###.#");

    @Nonnull
    public static String energyPerSecond(int energy) {
        return "&8\u21e8 &e\u26a1 &7" + LorePreset.roundHundreds((float)energy * PluginUtils.TICK_RATIO) + " J/s";
    }

    @Nonnull
    public static String energyBuffer(int energy) {
        return "&8\u21e8 &e\u26a1 &7" + LorePreset.format(energy) + " J Buffer";
    }

    @Nonnull
    public static String energy(int energy) {
        return "&8\u21e8 &e\u26a1 &7" + LorePreset.format(energy) + " J ";
    }

    @Nonnull
    public static String speed(int speed) {
        return "&8\u21e8 &b\u26a1 &7Speed: &b" + speed + 'x';
    }

    @Nonnull
    public static String storesItem(int amount) {
        return "&6Capacity: &e" + LorePreset.format(amount) + " &eitems";
    }

    @Nonnull
    public static String roundHundreds(double number) {
        return LorePreset.format((double)Math.round(number * 100.0) / 100.0);
    }

    @Nonnull
    public static String format(double number) {
        return FORMAT.format(number);
    }

    private LorePreset() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

