/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.implementation.mobs;

import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import me.gallowsdove.foxymachines.abstracts.CustomBoss;
import me.gallowsdove.foxymachines.abstracts.CustomMob;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class RiddenSkeletonHorse
extends CustomMob {
    private static final Set<EntityDamageEvent.DamageCause> RESISTANCES = Set.of(new EntityDamageEvent.DamageCause[]{EntityDamageEvent.DamageCause.CRAMMING, EntityDamageEvent.DamageCause.POISON, EntityDamageEvent.DamageCause.BLOCK_EXPLOSION, EntityDamageEvent.DamageCause.ENTITY_EXPLOSION});

    public RiddenSkeletonHorse() {
        super("SKELETON_HORSE", "Skeleton Horse", EntityType.SKELETON_HORSE, 2048);
    }

    @Override
    public void onSpawn(@Nonnull LivingEntity spawned) {
        spawned.setCustomName("");
        spawned.setCustomNameVisible(false);
        spawned.setRemoveWhenFarAway(false);
        spawned.getAttribute(Attribute.GENERIC_ARMOR).setBaseValue(50.0);
        spawned.addPotionEffect(new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 999999999, 4, false, false));
    }

    @Override
    protected void onHit(@Nonnull EntityDamageEvent e) {
        if (RESISTANCES.contains(e.getCause())) {
            e.setCancelled(true);
        }
        SkeletonHorse horse = (SkeletonHorse)e.getEntity();
        if (!e.isCancelled()) {
            for (Entity entity : horse.getPassengers()) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity passenger = (LivingEntity)entity;
                CustomMob mob = RiddenSkeletonHorse.getByEntity(entity);
                if (!(mob instanceof CustomBoss)) continue;
                CustomBoss boss = (CustomBoss)mob;
                double finalHealth = horse.getHealth() + passenger.getHealth() - e.getFinalDamage();
                if (!(finalHealth > 0.0)) continue;
                boss.updateBossBar(passenger, finalHealth / (passenger.getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue() + horse.getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue()));
            }
        }
    }

    @Override
    protected void onDeath(@Nonnull EntityDeathEvent e) {
        e.getDrops().clear();
        List passengers = e.getEntity().getPassengers();
        for (Entity passenger : passengers) {
            if (!(passenger instanceof LivingEntity)) continue;
            ((LivingEntity)passenger).setHealth(0.0);
        }
    }

    @Override
    protected int getSpawnChance() {
        return 0;
    }
}

