/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.abstracts;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.gallowsdove.foxymachines.FoxyMachines;
import me.gallowsdove.foxymachines.infinitylib.core.PluginUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.cscorelib2.data.PersistentDataAPI;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntitySpellCastEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public abstract class CustomMob {
    public static final Map<String, CustomMob> MOBS = new HashMap<String, CustomMob>();
    private static final NamespacedKey KEY = new NamespacedKey((Plugin)FoxyMachines.getInstance(), "mob");
    @Nonnull
    private final String id;
    @Nonnull
    private final String name;
    @Nonnull
    private final EntityType type;
    private final int health;

    @Nullable
    public static CustomMob getByID(@Nonnull String id) {
        return MOBS.get(id);
    }

    @Nullable
    public static CustomMob getByEntity(@Nonnull Entity entity) {
        String id = PersistentDataAPI.getString((PersistentDataHolder)entity, (NamespacedKey)KEY);
        return id == null ? null : CustomMob.getByID(id);
    }

    public CustomMob(@Nonnull String id, @Nonnull String name, @Nonnull EntityType type, int health) {
        this.id = id;
        Validate.notNull((Object)this.id);
        this.name = ChatColors.color((String)name);
        Validate.notNull((Object)this.name);
        this.type = type;
        Validate.notNull((Object)this.type);
        Validate.isTrue((boolean)type.isAlive(), (String)("Entity type " + type + " is not alive!"));
        this.health = health;
        Validate.isTrue((this.health > 0 ? 1 : 0) != 0);
        Validate.isTrue((this.getSpawnChance() >= 0 && this.getSpawnChance() <= 100 ? 1 : 0) != 0);
        Validate.notNull((Object)this.getSpawnOffset());
        MOBS.put(id, this);
    }

    @Nonnull
    public final LivingEntity spawn(@Nonnull Location loc) {
        LivingEntity entity = (LivingEntity)loc.getWorld().spawnEntity(loc, this.type);
        PersistentDataAPI.setString((PersistentDataHolder)entity, (NamespacedKey)KEY, (String)this.id);
        Objects.requireNonNull(entity.getAttribute(Attribute.GENERIC_MAX_HEALTH)).setBaseValue((double)this.health);
        entity.setHealth((double)this.health);
        entity.setCustomName(this.name);
        entity.setCustomNameVisible(true);
        entity.setRemoveWhenFarAway(true);
        this.onSpawn(entity);
        return entity;
    }

    public void onUniqueTick() {
    }

    protected void onSpawn(@Nonnull LivingEntity spawned) {
    }

    public void onMobTick(@Nonnull LivingEntity mob) {
    }

    protected void onHit(@Nonnull EntityDamageEvent e) {
    }

    protected void onAttack(@Nonnull EntityDamageByEntityEvent e) {
    }

    protected void onInteract(@Nonnull PlayerInteractEntityEvent e) {
    }

    protected void onTarget(@Nonnull EntityTargetEvent e) {
    }

    protected void onDeath(@Nonnull EntityDeathEvent e) {
    }

    protected void onCastSpell(EntitySpellCastEvent e) {
    }

    protected void onDamage(EntityDamageEvent e) {
    }

    protected abstract int getSpawnChance();

    protected int getMaxMobsPerGroup() {
        return 1;
    }

    protected boolean getSpawnInLightLevel(int lightLevel) {
        return lightLevel <= 7;
    }

    protected Vector getSpawnOffset() {
        return new Vector();
    }

    @Nonnull
    public EntityType getType() {
        return this.type;
    }

    static {
        PluginUtils.registerListener(new Listener(){

            @EventHandler
            public void onTarget(@Nonnull EntityTargetEvent e) {
                CustomMob customMob = CustomMob.getByEntity(e.getEntity());
                if (customMob != null) {
                    customMob.onTarget(e);
                }
            }

            @EventHandler
            public void onInteract(@Nonnull PlayerInteractEntityEvent e) {
                CustomMob customMob = CustomMob.getByEntity(e.getRightClicked());
                if (customMob != null) {
                    customMob.onInteract(e);
                }
            }

            @EventHandler
            public void onHit(@Nonnull EntityDamageByEntityEvent e) {
                CustomMob customMob = CustomMob.getByEntity(e.getDamager());
                if (customMob != null) {
                    customMob.onAttack(e);
                }
            }

            @EventHandler
            public void onDamaged(@Nonnull EntityDamageEvent e) {
                CustomMob customMob = CustomMob.getByEntity(e.getEntity());
                if (customMob != null) {
                    customMob.onHit(e);
                }
            }

            @EventHandler
            public void onDeath(@Nonnull EntityDeathEvent e) {
                CustomMob customMob = CustomMob.getByEntity((Entity)e.getEntity());
                if (customMob != null) {
                    customMob.onDeath(e);
                }
            }

            @EventHandler
            public void onSpellCast(@Nonnull EntitySpellCastEvent e) {
                CustomMob customMob = CustomMob.getByEntity((Entity)e.getEntity());
                if (customMob != null) {
                    customMob.onCastSpell(e);
                }
            }

            @EventHandler
            public void onDamage(@Nonnull EntityDamageEvent e) {
                CustomMob customMob = CustomMob.getByEntity(e.getEntity());
                if (customMob != null) {
                    customMob.onDamage(e);
                }
            }
        });
    }
}

