/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.utils;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.gallowsdove.foxymachines.FoxyMachines;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SimpleLocation {
    private static final NamespacedKey WORLD_KEY = new NamespacedKey((Plugin)FoxyMachines.getInstance(), "forcefield_world");
    private static final NamespacedKey X_KEY = new NamespacedKey((Plugin)FoxyMachines.getInstance(), "forcefield_x");
    private static final NamespacedKey Y_KEY = new NamespacedKey((Plugin)FoxyMachines.getInstance(), "forcefield_y");
    private static final NamespacedKey Z_KEY = new NamespacedKey((Plugin)FoxyMachines.getInstance(), "forcefield_z");
    private final int x;
    private final int y;
    private final int z;
    private final String worldUUID;

    @Nonnull
    public Block toBlock() {
        return Bukkit.getServer().getWorld(UUID.fromString(this.worldUUID)).getBlockAt(this.x, this.y, this.z);
    }

    public void storePersistently(@Nonnull PersistentDataContainer container) {
        container.set(X_KEY, PersistentDataType.INTEGER, (Object)this.x);
        container.set(Y_KEY, PersistentDataType.INTEGER, (Object)this.y);
        container.set(Z_KEY, PersistentDataType.INTEGER, (Object)this.z);
        container.set(WORLD_KEY, PersistentDataType.STRING, (Object)this.worldUUID);
    }

    @Nullable
    public static SimpleLocation fromPersistentStorage(@Nonnull PersistentDataContainer container) {
        if (container.has(WORLD_KEY, PersistentDataType.STRING)) {
            return new SimpleLocation((Integer)container.get(X_KEY, PersistentDataType.INTEGER), (Integer)container.get(Y_KEY, PersistentDataType.INTEGER), (Integer)container.get(Z_KEY, PersistentDataType.INTEGER), (String)container.get(WORLD_KEY, PersistentDataType.STRING));
        }
        return null;
    }

    public SimpleLocation(int x, int y, int z, String worldUUID) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.worldUUID = worldUUID;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleLocation)) {
            return false;
        }
        SimpleLocation other = (SimpleLocation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getY() != other.getY()) {
            return false;
        }
        if (this.getZ() != other.getZ()) {
            return false;
        }
        String this$worldUUID = this.getWorldUUID();
        String other$worldUUID = other.getWorldUUID();
        return !(this$worldUUID == null ? other$worldUUID != null : !this$worldUUID.equals(other$worldUUID));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleLocation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getY();
        result = result * 59 + this.getZ();
        String $worldUUID = this.getWorldUUID();
        result = result * 59 + ($worldUUID == null ? 43 : $worldUUID.hashCode());
        return result;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public String getWorldUUID() {
        return this.worldUUID;
    }
}

