/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.implementation.tools;

import io.github.thebusybiscuit.slimefun4.core.handlers.ItemDropHandler;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.gallowsdove.foxymachines.Items;
import me.gallowsdove.foxymachines.infinitylib.core.PluginUtils;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class UnbreakableRune
extends SimpleSlimefunItem<ItemDropHandler> {
    private static final double RANGE = 1.5;

    public UnbreakableRune() {
        super(Items.category, Items.UNBREAKABLE_RUNE, RecipeType.ANCIENT_ALTAR, new ItemStack[]{Items.DAMIENIUM, Items.MAGIC_LUMP_5, Items.DAMIENIUM, SlimefunItems.ESSENCE_OF_AFTERLIFE, SlimefunItems.LIGHTNING_RUNE, SlimefunItems.ESSENCE_OF_AFTERLIFE, Items.DAMIENIUM, Items.MAGIC_LUMP_5, Items.DAMIENIUM});
    }

    @Nonnull
    public ItemDropHandler getItemHandler() {
        return (e, p, item) -> {
            if (this.isItem(item.getItemStack())) {
                if (!SlimefunUtils.canPlayerUseItem((Player)p, (ItemStack)Items.UNBREAKABLE_RUNE, (boolean)true)) {
                    return true;
                }
                PluginUtils.runSync(() -> this.activate(p, item), 20L);
                return true;
            }
            return false;
        };
    }

    private void activate(@Nonnull Player p, @Nonnull Item rune) {
        if (!rune.isValid()) {
            return;
        }
        Location l = rune.getLocation();
        Collection entities = l.getWorld().getNearbyEntities(l, 1.5, 1.5, 1.5, this::findCompatibleItem);
        Optional optional = entities.stream().findFirst();
        if (optional.isPresent()) {
            Item item = (Item)optional.get();
            ItemStack itemStack = item.getItemStack();
            if (itemStack.getAmount() == 1) {
                l.getWorld().strikeLightningEffect(l);
                PluginUtils.runSync(() -> {
                    if (rune.isValid() && item.isValid() && itemStack.getAmount() == 1) {
                        l.getWorld().createExplosion(l, 0.0f);
                        l.getWorld().playSound(l, Sound.ENTITY_GENERIC_EXPLODE, 0.3f, 1.0f);
                        item.remove();
                        rune.remove();
                        UnbreakableRune.setUnbreakable(itemStack);
                        l.getWorld().dropItemNaturally(l, itemStack);
                        p.sendMessage(ChatColor.LIGHT_PURPLE + "Your item is now Unbreakable.");
                    } else {
                        p.sendMessage(ChatColor.LIGHT_PURPLE + "Your item could not be made Unbreakable");
                    }
                }, 10L);
            } else {
                p.sendMessage(ChatColor.LIGHT_PURPLE + "Your item could not be made Unbreakable");
            }
        }
    }

    private boolean findCompatibleItem(Entity entity) {
        if (entity instanceof Item) {
            Item item = (Item)entity;
            return !UnbreakableRune.isUnbreakable(item.getItemStack()) && !this.isItem(item.getItemStack());
        }
        return false;
    }

    public static void setUnbreakable(@Nullable ItemStack item) {
        if (item != null && item.getType() != Material.AIR && !UnbreakableRune.isUnbreakable(item)) {
            ItemMeta meta = item.getItemMeta();
            meta.setUnbreakable(true);
            item.setItemMeta(meta);
        }
    }

    public static boolean isUnbreakable(@Nullable ItemStack item) {
        if (item != null && item.getType() != Material.AIR) {
            if (item.hasItemMeta()) {
                return item.getItemMeta().isUnbreakable();
            }
            return false;
        }
        return false;
    }
}

