/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.infinitylib;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.io.File;
import java.util.Objects;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import me.gallowsdove.foxymachines.infinitylib.bstats.bukkit.Metrics;
import me.mrCookieSlime.Slimefun.cscorelib2.updater.GitHubBuildsUpdater;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class PluginUtils {
    private static JavaPlugin plugin = null;
    private static SlimefunAddon addon = null;
    private static int currentTick = 0;
    private static long timings = 0L;
    private static String prefix = null;
    public static final int TICKER_DELAY = SlimefunPlugin.getCfg().getInt("URID.custom-ticker-delay");
    public static final float TICK_RATIO = 20.0f / (float)TICKER_DELAY;

    public static void setup(@Nonnull String messagePrefix, @Nonnull SlimefunAddon slimefunAddon, @Nonnull String url, @Nonnull File file) {
        Validate.notNull((Object)messagePrefix);
        Validate.notNull((Object)slimefunAddon);
        Validate.notNull((Object)url);
        Validate.notNull((Object)file);
        addon = slimefunAddon;
        plugin = addon.getJavaPlugin();
        prefix = ChatColor.GRAY + "[" + prefix + ChatColor.GRAY + "] " + ChatColor.WHITE;
        plugin.saveDefaultConfig();
        Objects.requireNonNull(plugin.getConfig().getDefaults()).set("auto-update", (Object)true);
        PluginUtils.clearUnused((ConfigurationSection)plugin.getConfig(), (ConfigurationSection)plugin.getConfig().getDefaults());
        plugin.getConfig().options().copyDefaults(true).copyHeader(true);
        plugin.saveConfig();
        if (plugin.getConfig().getBoolean("auto-update")) {
            if (plugin.getDescription().getVersion().startsWith("DEV - ")) {
                new GitHubBuildsUpdater((Plugin)plugin, file, url).start();
            }
        } else {
            PluginUtils.runSync(() -> PluginUtils.log("#######################################", "Auto Updates have been disabled for " + plugin.getName(), "You will receive no support for bugs", "Until you update to the latest version!", "#######################################"));
        }
    }

    @Nonnull
    public static Metrics setupMetrics(int id) {
        Metrics metrics = new Metrics((Plugin)plugin, id);
        metrics.addCustomChart(new Metrics.SimplePie("auto_updates", () -> String.valueOf(plugin.getConfig().getBoolean("auto-update"))));
        return metrics;
    }

    private static void clearUnused(ConfigurationSection config, ConfigurationSection defaultConfig) {
        Objects.requireNonNull(config);
        Objects.requireNonNull(defaultConfig);
        for (String key : config.getKeys(false)) {
            if (!defaultConfig.contains(key)) {
                config.set(key, null);
                continue;
            }
            if (!config.isConfigurationSection(key)) continue;
            PluginUtils.clearUnused(config.getConfigurationSection(key), defaultConfig.getConfigurationSection(key));
        }
    }

    @Nonnull
    public static NamespacedKey getKey(@Nonnull String key) {
        return new NamespacedKey((Plugin)plugin, key);
    }

    public static void log(@Nonnull Level level, String ... logs) {
        for (String log : logs) {
            plugin.getLogger().log(level, log);
        }
    }

    public static void log(String ... logs) {
        PluginUtils.log(Level.INFO, logs);
    }

    public static void registerListener(@Nonnull Listener listener) {
        Bukkit.getPluginManager().registerEvents(listener, (Plugin)plugin);
    }

    public static void startTicker(@Nonnull Runnable onTick) {
        PluginUtils.scheduleRepeatingSync(() -> {
            long time = System.currentTimeMillis();
            currentTick = currentTick == 6000 ? 1 : ++currentTick;
            onTick.run();
            timings = System.currentTimeMillis() - time;
        }, TICKER_DELAY);
    }

    public static void runSync(@Nonnull Runnable runnable) {
        Bukkit.getScheduler().runTask((Plugin)plugin, runnable);
    }

    public static void runSync(@Nonnull Runnable runnable, long delay) {
        Bukkit.getScheduler().runTaskLater((Plugin)plugin, runnable, delay);
    }

    public static void scheduleRepeatingSync(@Nonnull Runnable runnable, long interval) {
        Bukkit.getScheduler().runTaskTimer((Plugin)plugin, runnable, 0L, interval);
    }

    public static void scheduleRepeatingSync(@Nonnull Runnable runnable, long delay, long interval) {
        Bukkit.getScheduler().runTaskTimer((Plugin)plugin, runnable, delay, interval);
    }

    public static void runAsync(@Nonnull Runnable runnable) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, runnable);
    }

    public static void runAsync(@Nonnull Runnable runnable, long delay) {
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)plugin, runnable, delay);
    }

    public static void scheduleRepeatingAsync(@Nonnull Runnable runnable, long interval) {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, runnable, 0L, interval);
    }

    public static void scheduleRepeatingAsync(@Nonnull Runnable runnable, long delay, long interval) {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, runnable, delay, interval);
    }

    private PluginUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static JavaPlugin getPlugin() {
        return plugin;
    }

    public static SlimefunAddon getAddon() {
        return addon;
    }

    public static int getCurrentTick() {
        return currentTick;
    }

    public static long getTimings() {
        return timings;
    }

    public static String getPrefix() {
        return prefix;
    }
}

