/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.infinitylib.recipes.shaped;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.gallowsdove.foxymachines.infinitylib.misc.MapHolder;
import me.gallowsdove.foxymachines.infinitylib.recipes.shaped.ShapedOutput;
import me.gallowsdove.foxymachines.infinitylib.recipes.shaped.ShapedRecipe;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.apache.commons.lang.Validate;
import org.bukkit.inventory.ItemStack;

public final class ShapedRecipeMap
extends MapHolder<ShapedRecipe, ItemStack> {
    public void put(@Nonnull ItemStack[] recipe, @Nonnull ItemStack output) {
        Validate.isTrue((recipe.length == 9 ? 1 : 0) != 0);
        this.map.put(new ShapedRecipe(recipe), output);
    }

    @Nullable
    public ShapedOutput get(@Nonnull ItemStack[] input) {
        Validate.isTrue((input.length == 9 ? 1 : 0) != 0);
        int[] amounts = new int[9];
        for (int i = 0; i < 9; ++i) {
            if (input[i] == null) continue;
            amounts[i] = input[i].getAmount();
        }
        ItemStack output = (ItemStack)this.map.get(new ShapedRecipe(input));
        return output == null ? null : new ShapedOutput(output, amounts);
    }

    @Nullable
    public ShapedOutput get(@Nonnull BlockMenu menu, @Nonnull int[] slots) {
        Validate.isTrue((slots.length == 9 ? 1 : 0) != 0);
        ItemStack[] stacks = new ItemStack[9];
        int[] amounts = new int[9];
        for (int i = 0; i < 9; ++i) {
            ItemStack item = menu.getItemInSlot(slots[i]);
            if (item == null) continue;
            stacks[i] = item;
            amounts[i] = stacks[i].getAmount();
        }
        ItemStack output = (ItemStack)this.map.get(new ShapedRecipe(stacks));
        return output == null ? null : new ShapedOutput(output, amounts);
    }
}

