/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.infinitylib.recipes.shaped;

import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import me.gallowsdove.foxymachines.infinitylib.items.StackUtils;
import me.gallowsdove.foxymachines.infinitylib.recipes.shaped.Shape;
import org.bukkit.inventory.ItemStack;

final class ShapedRecipe {
    private final String[] ids;
    private final Shape shape;
    private final int hashCode;

    ShapedRecipe(@Nonnull ItemStack[] items) {
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        String[] ids = new String[9];
        int shapeInt = 0;
        Shape shape = null;
        AtomicInteger digit = new AtomicInteger(1);
        for (int i = 0; i < 9; ++i) {
            shapeInt *= 10;
            if (items[i] == null) continue;
            ids[i] = StackUtils.getIDorType(items[i]);
            shapeInt += map.computeIfAbsent(ids[i], k -> digit.getAndIncrement()).intValue();
            if (digit.intValue() != 4) continue;
            shape = Shape.FULL;
            break;
        }
        if (shape == null) {
            shape = Shape.get(shapeInt);
        }
        int hashCode = 0;
        if (shape == Shape.FULL) {
            for (String id : ids) {
                if (id == null) continue;
                hashCode += id.hashCode();
            }
        } else {
            ids = new String[map.size()];
            if (shape == Shape.SHAPELESS) {
                int i = 0;
                for (Map.Entry entry : map.entrySet()) {
                    ids[i++] = (String)entry.getKey();
                    hashCode += ((Integer)entry.getValue()).hashCode();
                }
            } else {
                for (Map.Entry entry : map.entrySet()) {
                    ids[((Integer)entry.getValue()).intValue() - 1] = (String)entry.getKey();
                    hashCode += ((Integer)entry.getValue()).hashCode();
                }
            }
        }
        this.shape = shape;
        this.ids = ids;
        this.hashCode = hashCode + shape.hashCode();
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof ShapedRecipe)) {
            return false;
        }
        ShapedRecipe recipe = (ShapedRecipe)obj;
        if (recipe.shape != this.shape) {
            return false;
        }
        for (int i = 0; i < this.ids.length; ++i) {
            if (Objects.equals(recipe.ids[i], this.ids[i])) continue;
            return false;
        }
        return true;
    }
}

