/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.infinitylib.items;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.Range;

public final class StackUtils {
    private static final NamespacedKey dataKey = SlimefunPlugin.getItemDataService().getKey();

    @Nullable
    public static String getIDofNullable(@Nullable ItemStack item) {
        if (item == null) {
            return null;
        }
        return StackUtils.getID(item);
    }

    @Nullable
    public static String getIDorTypeOfNullable(@Nullable ItemStack item) {
        if (item == null) {
            return null;
        }
        return StackUtils.getIDorType(item);
    }

    @Nullable
    public static String getID(@Nonnull ItemStack item) {
        if (item instanceof SlimefunItemStack) {
            return ((SlimefunItemStack)item).getItemId();
        }
        return StackUtils.getID(item.getItemMeta().getPersistentDataContainer());
    }

    @Nonnull
    public static String getIDorType(@Nonnull ItemStack item) {
        String id = StackUtils.getID(item);
        if (id == null) {
            return item.getType().toString();
        }
        return id;
    }

    @Nullable
    public static String getID(@Nonnull PersistentDataContainer container) {
        return (String)container.get(dataKey, PersistentDataType.STRING);
    }

    @Nonnull
    public static String getIDorType(@Nonnull PersistentDataContainer container, @Nonnull ItemStack item) {
        String id = StackUtils.getID(container);
        if (id == null) {
            return item.getType().toString();
        }
        return id;
    }

    @Nullable
    public static ItemStack getItemByNullableID(@Nullable String id) {
        if (id == null) {
            return null;
        }
        return StackUtils.getItemByID(id, 1);
    }

    @Nullable
    public static ItemStack getItemByNullableIDorType(@Nullable String id) throws IllegalArgumentException {
        if (id == null) {
            return null;
        }
        return StackUtils.getItemByIDorType(id, 1);
    }

    @Nullable
    public static ItemStack getItemByNullableID(@Nullable String id, @Range(from=1L, to=64L) int amount) {
        if (id == null) {
            return null;
        }
        return StackUtils.getItemByID(id, amount);
    }

    @Nullable
    public static ItemStack getItemByNullableIDorType(@Nullable String id, @Range(from=1L, to=64L) int amount) {
        if (id == null) {
            return null;
        }
        return StackUtils.getItemByIDorType(id, amount);
    }

    @Nullable
    public static ItemStack getItemByID(@Nonnull String id) {
        return StackUtils.getItemByID(id, 1);
    }

    @Nullable
    public static ItemStack getItemByID(@Nonnull String id, @Range(from=1L, to=64L) int amount) {
        SlimefunItem sfItem = SlimefunItem.getByID((String)id);
        if (sfItem != null) {
            return new CustomItem(sfItem.getItem(), amount);
        }
        return null;
    }

    @Nullable
    public static ItemStack getItemByIDorType(@Nonnull String id) {
        return StackUtils.getItemByIDorType(id, 1);
    }

    @Nullable
    public static ItemStack getItemByIDorType(@Nonnull String id, @Range(from=1L, to=64L) int amount) {
        SlimefunItem sfItem = SlimefunItem.getByID((String)id);
        if (sfItem != null) {
            return new CustomItem(sfItem.getItem(), amount);
        }
        Material material = Material.getMaterial((String)id);
        if (material != null) {
            return new ItemStack(material, amount);
        }
        return null;
    }

    @Nonnull
    public static ItemStack removeEnchants(@Nonnull ItemStack item) {
        for (Enchantment e : item.getEnchantments().keySet()) {
            item.removeEnchantment(e);
        }
        return item;
    }

    private StackUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

