/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.infinitylib.misc;

import com.google.common.math.IntMath;
import java.lang.reflect.Array;
import javax.annotation.Nonnull;

public final class CollectionUtils {
    @Nonnull
    public static <T> T[][] combinationsOf(@Nonnull T[] array) {
        Class<?> arrayClass = array.getClass();
        Class<?> componentClass = arrayClass.getComponentType();
        int length = array.length;
        Object[][] combos = (Object[][])Array.newInstance(arrayClass, IntMath.factorial((int)length));
        if (length == 1) {
            combos[0] = array;
        } else if (length != 0) {
            Object[] old = array;
            int index = 0;
            while (index < combos.length) {
                for (int swap = 0; swap < length - 1; ++swap) {
                    Object[] current = (Object[])Array.newInstance(componentClass, length);
                    for (int fill = 0; fill < length; ++fill) {
                        if (fill == swap) {
                            current[fill] = old[fill + 1];
                            current[fill + 1] = old[fill];
                            ++fill;
                            continue;
                        }
                        current[fill] = old[fill];
                    }
                    int n = index++;
                    old = current;
                    combos[n] = current;
                }
            }
        }
        return combos;
    }

    private CollectionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

