/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.implementation.machines;

import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.gallowsdove.foxymachines.Items;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class PotionMixer
extends SlimefunItem
implements EnergyNetComponent {
    private static final int[] BORDER = new int[]{3, 4, 5, 27, 28, 29, 33, 34, 35, 36, 37, 38, 42, 43, 44};
    private static final int[] BORDER_IN = new int[]{0, 1, 2, 6, 7, 8, 9, 11, 12, 14, 15, 17, 18, 19, 20, 24, 25, 26};
    private static final int[] BORDER_OUT = new int[]{21, 22, 23, 30, 32, 39, 40, 41};
    public static final int ENERGY_CONSUMPTION = 28;
    public static final int CAPACITY = 128;
    public static Map<Block, MachineRecipe> processing = new HashMap<Block, MachineRecipe>();
    public static Map<Block, Integer> progress = new HashMap<Block, Integer>();
    protected final List<MachineRecipe> recipes = new ArrayList<MachineRecipe>();

    public PotionMixer() {
        super(Items.category, Items.POTION_MIXER, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{SlimefunItems.CARBONADO, SlimefunItems.GOLD_24K, SlimefunItems.CARBONADO, SlimefunItems.ELECTRIC_MOTOR, new ItemStack(Material.BREWING_STAND), SlimefunItems.ELECTRIC_MOTOR, SlimefunItems.GOLD_24K, SlimefunItems.MEDIUM_CAPACITOR, SlimefunItems.GOLD_24K});
        new BlockMenuPreset(this.getId(), "&6Potion Mixer"){

            public void init() {
                PotionMixer.this.constructMenu(this);
            }

            public boolean canOpen(Block b, Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), ProtectableAction.INTERACT_BLOCK);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return new int[0];
            }

            public int[] getSlotsAccessedByItemTransport(DirtyChestMenu menu, ItemTransportFlow flow, ItemStack item) {
                if (flow == ItemTransportFlow.WITHDRAW) {
                    return PotionMixer.this.getOutputSlots();
                }
                ArrayList<Integer> slots = new ArrayList<Integer>();
                for (int slot : PotionMixer.this.getInputSlots()) {
                    if (menu.getItemInSlot(slot) == null) continue;
                    slots.add(slot);
                }
                slots.sort(PotionMixer.this.compareSlots(menu));
                int[] array = new int[slots.size()];
                for (int i = 0; i < slots.size(); ++i) {
                    array[i] = (Integer)slots.get(i);
                }
                return array;
            }
        };
        PotionMixer.registerBlockHandler((String)this.getId(), (p, b, stack, reason) -> {
            BlockMenu inv = BlockStorage.getInventory((Block)b);
            if (inv != null) {
                inv.dropItems(b.getLocation(), this.getOutputSlots());
                inv.dropItems(b.getLocation(), this.getInputSlots());
            }
            return true;
        });
    }

    private Comparator<Integer> compareSlots(DirtyChestMenu menu) {
        return Comparator.comparingInt(slot -> menu.getItemInSlot(slot.intValue()).getAmount());
    }

    public int[] getInputSlots() {
        return new int[]{10, 16};
    }

    public int[] getOutputSlots() {
        return new int[]{31};
    }

    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getCapacity() {
        return 128;
    }

    public int getEnergyConsumption() {
        return 28;
    }

    public String getMachineIdentifier() {
        return "POTION_MIXER";
    }

    public List<MachineRecipe> getMachineRecipes() {
        return this.recipes;
    }

    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> displayRecipes = new ArrayList<ItemStack>(this.recipes.size() * 2);
        for (MachineRecipe recipe : this.recipes) {
            if (recipe.getInput().length != 1) continue;
            displayRecipes.add(recipe.getInput()[0]);
            displayRecipes.add(recipe.getOutput()[0]);
        }
        return displayRecipes;
    }

    public ItemStack getProgressBar() {
        return new ItemStack(Material.GOLDEN_HOE);
    }

    public MachineRecipe getProcessing(Block b) {
        return processing.get(b);
    }

    public boolean isProcessing(Block b) {
        return this.getProcessing(b) != null;
    }

    public void registerRecipe(MachineRecipe recipe) {
        recipe.setTicks(recipe.getTicks());
        this.recipes.add(recipe);
    }

    public void registerRecipe(int seconds, ItemStack[] input, ItemStack[] output) {
        this.registerRecipe(new MachineRecipe(seconds, input, output));
    }

    public void registerRecipe(int seconds, ItemStack input, ItemStack output) {
        this.registerRecipe(new MachineRecipe(seconds, new ItemStack[]{input}, new ItemStack[]{output}));
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public void tick(Block b, SlimefunItem sf, Config data) {
                PotionMixer.this.tick(b);
            }

            public boolean isSynchronized() {
                return false;
            }
        }});
    }

    protected void tick(Block b) {
        BlockMenu inv = BlockStorage.getInventory((Block)b);
        if (this.isProcessing(b)) {
            int timeleft = progress.get(b);
            if (timeleft > 0) {
                ChestMenuUtils.updateProgressbar((ChestMenu)inv, (int)13, (int)timeleft, (int)processing.get(b).getTicks(), (ItemStack)this.getProgressBar());
                if (this.isChargeable()) {
                    if (this.getCharge(b.getLocation()) < this.getEnergyConsumption()) {
                        return;
                    }
                    this.removeCharge(b.getLocation(), this.getEnergyConsumption());
                }
                progress.put(b, timeleft - 1);
            } else {
                inv.replaceExistingItem(13, (ItemStack)new CustomItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]));
                for (ItemStack output : processing.get(b).getOutput()) {
                    inv.pushItem(output.clone(), this.getOutputSlots());
                }
                progress.remove(b);
                processing.remove(b);
            }
        } else {
            MachineRecipe next = this.findNextRecipe(inv);
            if (next != null) {
                processing.put(b, next);
                progress.put(b, next.getTicks());
            }
        }
    }

    protected PotionEffect[] getCustomEffectsFromBaseData(PotionData potionData, boolean lingering) {
        PotionType type = potionData.getType();
        boolean extended = potionData.isExtended();
        boolean upgraded = potionData.isUpgraded();
        int d = 1;
        if (lingering) {
            d = 4;
        }
        switch (type) {
            case FIRE_RESISTANCE: {
                if (extended) {
                    return new PotionEffect[]{new PotionEffect(PotionEffectType.FIRE_RESISTANCE, 9600 / d, 0)};
                }
                return new PotionEffect[]{new PotionEffect(PotionEffectType.FIRE_RESISTANCE, 3600 / d, 0)};
            }
            case INSTANT_DAMAGE: {
                if (upgraded) {
                    return new PotionEffect[]{new PotionEffect(PotionEffectType.HARM, 0, 1)};
                }
                return new PotionEffect[]{new PotionEffect(PotionEffectType.HARM, 0, 0)};
            }
            case INSTANT_HEAL: {
                if (upgraded) {
                    return new PotionEffect[]{new PotionEffect(PotionEffectType.HEAL, 0, 1)};
                }
                return new PotionEffect[]{new PotionEffect(PotionEffectType.HEAL, 0, 0)};
            }
            case INVISIBILITY: {
                if (extended) {
                    return new PotionEffect[]{new PotionEffect(PotionEffectType.INVISIBILITY, 9600 / d, 0)};
                }
                return new PotionEffect[]{new PotionEffect(PotionEffectType.INVISIBILITY, 3600 / d, 0)};
            }
            case JUMP: {
                if (extended) {
                    return new PotionEffect[]{new PotionEffect(PotionEffectType.JUMP, 9600 / d, 0)};
                }
                if (upgraded) {
                    return new PotionEffect[]{new PotionEffect(PotionEffectType.JUMP, 1800 / d, 1)};
                }
                return new PotionEffect[]{new PotionEffect(PotionEffectType.JUMP, 3600 / d, 0)};
            }
            case LUCK: {
                return new PotionEffect[]{new PotionEffect(PotionEffectType.LUCK, 6000 / d, 0)};
            }
            case NIGHT_VISION: {
                if (extended) {
                    return new PotionEffect[]{new PotionEffect(PotionEffectType.NIGHT_VISION, 9600 / d, 0)};
                }
                return new PotionEffect[]{new PotionEffect(PotionEffectType.NIGHT_VISION, 3600 / d, 0)};
            }
            case POISON: {
                if (extended) {
                    return new PotionEffect[]{new PotionEffect(PotionEffectType.POISON, 900 / d, 0)};
                }
                if (upgraded) {
                    return new PotionEffect[]{new PotionEffect(PotionEffectType.POISON, 420 / d, 1)};
                }
                return new PotionEffect[]{new PotionEffect(PotionEffectType.POISON, 1800 / d, 0)};
            }
            case REGEN: {
                if (extended) {
                    return new PotionEffect[]{new PotionEffect(PotionEffectType.REGENERATION, 900 / d, 0)};
                }
                if (upgraded) {
                    return new PotionEffect[]{new PotionEffect(PotionEffectType.REGENERATION, 440 / d, 1)};
                }
                return new PotionEffect[]{new PotionEffect(PotionEffectType.REGENERATION, 1800 / d, 0)};
            }
            case SLOW_FALLING: {
                if (extended) {
                    return new PotionEffect[]{new PotionEffect(PotionEffectType.SLOW_FALLING, 4800 / d, 0)};
                }
                return new PotionEffect[]{new PotionEffect(PotionEffectType.SLOW_FALLING, 1800 / d, 0)};
            }
            case SLOWNESS: {
                if (extended) {
                    return new PotionEffect[]{new PotionEffect(PotionEffectType.SLOW, 4800 / d, 0)};
                }
                if (upgraded) {
                    return new PotionEffect[]{new PotionEffect(PotionEffectType.SLOW, 400 / d, 3)};
                }
                return new PotionEffect[]{new PotionEffect(PotionEffectType.SLOW, 1800 / d, 0)};
            }
            case SPEED: {
                if (extended) {
                    return new PotionEffect[]{new PotionEffect(PotionEffectType.SPEED, 9600 / d, 0)};
                }
                if (upgraded) {
                    return new PotionEffect[]{new PotionEffect(PotionEffectType.SPEED, 1800 / d, 1)};
                }
                return new PotionEffect[]{new PotionEffect(PotionEffectType.SPEED, 3600 / d, 0)};
            }
            case STRENGTH: {
                if (extended) {
                    return new PotionEffect[]{new PotionEffect(PotionEffectType.INCREASE_DAMAGE, 9600 / d, 0)};
                }
                if (upgraded) {
                    return new PotionEffect[]{new PotionEffect(PotionEffectType.INCREASE_DAMAGE, 1800 / d, 1)};
                }
                return new PotionEffect[]{new PotionEffect(PotionEffectType.INCREASE_DAMAGE, 3600 / d, 0)};
            }
            case TURTLE_MASTER: {
                if (extended) {
                    return new PotionEffect[]{new PotionEffect(PotionEffectType.SLOW, 800 / d, 3), new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 800 / d, 2)};
                }
                if (upgraded) {
                    return new PotionEffect[]{new PotionEffect(PotionEffectType.SLOW, 400 / d, 5), new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 400 / d, 3)};
                }
                return new PotionEffect[]{new PotionEffect(PotionEffectType.SLOW, 400 / d, 3), new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 400 / d, 2)};
            }
            case WATER_BREATHING: {
                if (extended) {
                    return new PotionEffect[]{new PotionEffect(PotionEffectType.WATER_BREATHING, 9600 / d, 0)};
                }
                return new PotionEffect[]{new PotionEffect(PotionEffectType.WATER_BREATHING, 3600 / d, 0)};
            }
            case WEAKNESS: {
                if (extended) {
                    return new PotionEffect[]{new PotionEffect(PotionEffectType.WEAKNESS, 4800 / d, 0)};
                }
                return new PotionEffect[]{new PotionEffect(PotionEffectType.WEAKNESS, 1800 / d, 0)};
            }
        }
        return new PotionEffect[0];
    }

    protected MachineRecipe findNextRecipe(BlockMenu menu) {
        int[] slots = this.getInputSlots();
        ItemStack potion1 = menu.getItemInSlot(slots[0]);
        ItemStack potion2 = menu.getItemInSlot(slots[1]);
        if (potion1 != null && potion2 != null && (potion1.getType() == Material.POTION && potion2.getType() == Material.POTION || potion1.getType() == Material.SPLASH_POTION && potion2.getType() == Material.SPLASH_POTION || potion1.getType() == Material.LINGERING_POTION && potion2.getType() == Material.LINGERING_POTION)) {
            boolean lingering = false;
            if (potion1.getType() == Material.LINGERING_POTION) {
                lingering = true;
            }
            ItemStack potion = potion1.clone();
            potion.setAmount(1);
            PotionMeta potionMeta = (PotionMeta)potion1.getItemMeta();
            PotionMeta potion2Meta = (PotionMeta)potion2.getItemMeta();
            ArrayList potion1Effects = new ArrayList(potionMeta.getCustomEffects());
            List potion2Effects = potion2Meta.getCustomEffects();
            for (int i = 0; i < potion2Effects.size(); ++i) {
                for (int j = 0; j < potion1Effects.size(); ++j) {
                    if (((PotionEffect)potion1Effects.get(j)).getType() != ((PotionEffect)potion2Effects.get(i)).getType()) continue;
                    if (((PotionEffect)potion1Effects.get(j)).getAmplifier() > ((PotionEffect)potion2Effects.get(i)).getAmplifier()) {
                        potion2Effects.set(i, (PotionEffect)potion1Effects.get(j));
                    }
                    potion1Effects.remove(j);
                    break;
                }
                potionMeta.addCustomEffect((PotionEffect)potion2Effects.get(i), true);
            }
            for (PotionEffect effect : this.getCustomEffectsFromBaseData(potionMeta.getBasePotionData(), lingering)) {
                potionMeta.addCustomEffect(effect, false);
            }
            for (PotionEffect effect : this.getCustomEffectsFromBaseData(potion2Meta.getBasePotionData(), lingering)) {
                for (PotionEffect effect2 : potionMeta.getCustomEffects()) {
                    if (effect.getType() != effect2.getType() || effect.getAmplifier() <= effect2.getAmplifier()) continue;
                    potionMeta.addCustomEffect(effect, true);
                    break;
                }
                potionMeta.addCustomEffect(effect, false);
            }
            ArrayList<String> lore = new ArrayList<String>(){
                {
                    this.add("Not usable in Brewing Stand");
                }
            };
            potionMeta.setBasePotionData(new PotionData(PotionType.UNCRAFTABLE, false, false));
            switch (potion1.getType()) {
                case POTION: {
                    potionMeta.setDisplayName(ChatColor.AQUA + "Combined Potion");
                    break;
                }
                case LINGERING_POTION: {
                    lore.add(ChatColor.RED + "The time shown is incorrect due to a Minecraft");
                    lore.add(ChatColor.RED + "bug, multiply it by 4 to get the real time.");
                    potionMeta.setDisplayName(ChatColor.AQUA + "Combined Lingering Potion");
                    break;
                }
                case SPLASH_POTION: {
                    potionMeta.setDisplayName(ChatColor.AQUA + "Combined Splash Potion");
                }
            }
            potionMeta.setLore((List)lore);
            potionMeta.setColor(Color.AQUA);
            potion.setItemMeta((ItemMeta)potionMeta);
            if (!menu.fits(potion, this.getOutputSlots())) {
                return null;
            }
            for (int inputSlot : this.getInputSlots()) {
                menu.consumeItem(inputSlot);
            }
            return new MachineRecipe((1 + potionMeta.getCustomEffects().size()) * 12, new ItemStack[]{potion1, potion2}, new ItemStack[]{potion});
        }
        return null;
    }

    protected void constructMenu(BlockMenuPreset preset) {
        for (int i : BORDER) {
            preset.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : BORDER_IN) {
            preset.addItem(i, (ItemStack)new SlimefunItemStack("_UI_INPUT_SLOT", Material.CYAN_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : BORDER_OUT) {
            preset.addItem(i, (ItemStack)new SlimefunItemStack("_UI_OUTPUT_SLOT", Material.ORANGE_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        preset.addItem(13, (ItemStack)new CustomItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        for (int i : this.getOutputSlots()) {
            preset.addMenuClickHandler(i, (ChestMenu.MenuClickHandler)new ChestMenu.AdvancedMenuClickHandler(){

                public boolean onClick(Player p, int slot, ItemStack cursor, ClickAction action) {
                    return false;
                }

                public boolean onClick(InventoryClickEvent e, Player p, int slot, ItemStack cursor, ClickAction action) {
                    return cursor == null || cursor.getType() == Material.AIR;
                }
            });
        }
    }
}

