/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.fluffymachines.items.tools;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.Rechargeable;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.ncbpfluffybear.fluffymachines.FluffyMachines;
import io.ncbpfluffybear.fluffymachines.utils.Utils;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PortableCharger
extends SimpleSlimefunItem<ItemUseHandler>
implements Listener,
Rechargeable {
    private final int[] BORDER = new int[]{5, 6, 7, 14, 16, 23, 24, 25};
    private final int POWER_SLOT = 11;
    private final int CHARGE_SLOT = 15;
    private final int INV_SIZE = 27;
    private final float CHARGE_CAPACITY;
    private final float CHARGE_SPEED;
    private final Plugin plugin = FluffyMachines.getInstance();

    public PortableCharger(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int chargeCapacity, int chargeSpeed) {
        super(category, item, recipeType, recipe);
        this.CHARGE_CAPACITY = chargeCapacity;
        this.CHARGE_SPEED = chargeSpeed;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)FluffyMachines.getInstance());
    }

    @Nonnull
    public ItemUseHandler getItemHandler() {
        return e -> {
            e.cancel();
            final Player p = e.getPlayer();
            final ItemStack chargerItem = e.getItem();
            final Rechargeable charger = (Rechargeable)SlimefunItem.getByItem((ItemStack)chargerItem);
            final Inventory inventory = Bukkit.createInventory(null, (int)27, (String)(ChatColor.GOLD + "Portable Charger"));
            ItemStack backgroundItem = Utils.buildNonInteractable(Material.GRAY_STAINED_GLASS_PANE, null, new String[0]);
            ItemStack borderItem = Utils.buildNonInteractable(Material.YELLOW_STAINED_GLASS_PANE, null, new String[0]);
            ItemStack powerItem = Utils.buildNonInteractable(Material.GLOWSTONE, "&4Power", new String[0]);
            for (int i = 0; i < 27; ++i) {
                inventory.setItem(i, backgroundItem);
            }
            for (int slot : this.BORDER) {
                inventory.setItem(slot, borderItem);
            }
            inventory.setItem(11, powerItem);
            this.updateSlot(inventory, 11, "&6&lPower Remaining", "&e" + charger.getItemCharge(chargerItem) + "J");
            inventory.clear(15);
            p.openInventory(inventory);
            new BukkitRunnable(){

                public void run() {
                    ItemStack deviceItem = inventory.getItem(15);
                    SlimefunItem sfItem = SlimefunItem.getByItem((ItemStack)deviceItem);
                    if (sfItem instanceof PortableCharger) {
                        p.closeInventory();
                        Utils.send((CommandSender)p, "&cYou can not charge a portable charger");
                    }
                    if (sfItem instanceof Rechargeable) {
                        Rechargeable device = (Rechargeable)sfItem;
                        float neededCharge = device.getMaxItemCharge(deviceItem) - device.getItemCharge(deviceItem);
                        float availableCharge = charger.getItemCharge(chargerItem);
                        if (p.getGameMode() == GameMode.CREATIVE && neededCharge > 0.0f) {
                            device.setItemCharge(deviceItem, device.getMaxItemCharge(deviceItem));
                        } else if (neededCharge > 0.0f && availableCharge > 0.0f) {
                            if (neededCharge >= PortableCharger.this.CHARGE_SPEED && availableCharge >= PortableCharger.this.CHARGE_SPEED) {
                                PortableCharger.this.transferCharge(charger, chargerItem, device, deviceItem, PortableCharger.this.CHARGE_SPEED);
                            } else {
                                PortableCharger.this.transferCharge(charger, chargerItem, device, deviceItem, Math.min(neededCharge, availableCharge));
                            }
                        } else if (neededCharge == 0.0f) {
                            Utils.send((CommandSender)p, "&cThis item is already full!");
                        } else {
                            Utils.send((CommandSender)p, "&cYour charger does not have enough power!");
                        }
                        PortableCharger.this.updateSlot(inventory, 11, "&6&lPower Remaining", "&e" + charger.getItemCharge(chargerItem) + "J");
                    }
                    if (!inventory.getViewers().contains(p)) {
                        this.cancel();
                        ItemStack forgottenItem = inventory.getItem(15);
                        if (forgottenItem != null) {
                            Utils.send((CommandSender)p, "&cHey! You left something in the charger! Dropping it now...");
                            Utils.giveOrDropItem(p, forgottenItem);
                        }
                    }
                }
            }.runTaskTimer(this.plugin, 0L, 20L);
        };
    }

    @EventHandler
    public void onChargerItemClick(InventoryClickEvent e) {
        SlimefunItem sfItem1 = SlimefunItem.getByItem((ItemStack)e.getCurrentItem());
        SlimefunItem sfItem2 = SlimefunItem.getByItem((ItemStack)e.getCursor());
        if ((sfItem1 instanceof PortableCharger || sfItem2 instanceof PortableCharger) && e.getWhoClicked().getOpenInventory().getTitle().contains("Portable Charger")) {
            e.setCancelled(true);
        }
    }

    public void updateSlot(Inventory inventory, int slot, String name, String ... lore) {
        ItemStack item = inventory.getItem(slot);
        ItemMeta slotMeta = item.getItemMeta();
        if (name != null) {
            slotMeta.setDisplayName(ChatColors.color((String)name));
        } else {
            slotMeta.setDisplayName(" ");
        }
        if (lore.length > 0) {
            ArrayList<String> lines = new ArrayList<String>();
            for (String line : lore) {
                lines.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
            }
            slotMeta.setLore(lines);
        }
        item.setItemMeta(slotMeta);
        inventory.setItem(slot, item);
    }

    public void transferCharge(Rechargeable charger, ItemStack chargerItem, Rechargeable device, ItemStack deviceItem, float charge) {
        charger.removeItemCharge(chargerItem, charge);
        device.addItemCharge(deviceItem, charge);
    }

    public float getMaxItemCharge(ItemStack itemStack) {
        return this.CHARGE_CAPACITY;
    }

    public boolean isDisenchantable() {
        return false;
    }

    public static enum Type {
        SMALL(128, 8),
        MEDIUM(512, 32),
        BIG(1024, 64),
        LARGE(8192, 512),
        CARBONADO(65526, 4096);

        public final int chargeCapacity;
        public final int chargeSpeed;

        public int getChargeCapacity() {
            return this.chargeCapacity;
        }

        public int getChargeSpeed() {
            return this.chargeSpeed;
        }

        private Type(int chargeCapacity, int chargeSpeed) {
            this.chargeCapacity = chargeCapacity;
            this.chargeSpeed = chargeSpeed;
        }
    }
}

