/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.fluffymachines.machines;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.backpacks.SlimefunBackpack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.List;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class BackpackLoader
extends SlimefunItem
implements EnergyNetComponent {
    public static final int ENERGY_CONSUMPTION = 16;
    public static final int CAPACITY = 48;
    private static final int[] PLAIN_BORDER = new int[]{38, 39, 40, 41, 42, 47, 48, 49, 50, 51};
    private static final int[] INPUT_BORDER = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17, 18, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35};
    private static final int[] OUTPUT_BORDER = new int[]{43, 44, 52};
    private static final int[] BACKPACK_BORDER = new int[]{36, 37, 46};
    private static final int[] INPUT_SLOTS = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25};
    private static final int[] OUTPUT_SLOTS = new int[]{53};
    private static final int BACKPACK_SLOT = 45;

    public BackpackLoader(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.addItemHandler(new ItemHandler[]{this.onBreak()});
        new BlockMenuPreset(this.getId(), "&eBackpack Loader"){

            public void init() {
                BackpackLoader.buildBorder(this, PLAIN_BORDER, INPUT_BORDER, OUTPUT_BORDER);
                for (int i : BACKPACK_BORDER) {
                    this.addItem(i, (ItemStack)new CustomItemStack(new ItemStack(Material.YELLOW_STAINED_GLASS_PANE), " ", new String[0]), (p, slot, item, action) -> false);
                }
            }

            public boolean canOpen(@Nonnull Block b, @Nonnull Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), Interaction.INTERACT_BLOCK);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return new int[0];
            }

            public int[] getSlotsAccessedByItemTransport(DirtyChestMenu menu, ItemTransportFlow flow, ItemStack item) {
                if (flow == ItemTransportFlow.WITHDRAW) {
                    return BackpackLoader.this.getOutputSlots();
                }
                return BackpackLoader.this.getInputSlots();
            }
        };
    }

    private BlockBreakHandler onBreak() {
        return new BlockBreakHandler(false, false){

            public void onPlayerBreak(@Nonnull BlockBreakEvent e, @Nonnull ItemStack item, @Nonnull List<ItemStack> drops) {
                Block b = e.getBlock();
                BlockMenu inv = BlockStorage.getInventory((Block)b);
                if (inv != null) {
                    inv.dropItems(b.getLocation(), BackpackLoader.this.getInputSlots());
                    inv.dropItems(b.getLocation(), BackpackLoader.this.getOutputSlots());
                    inv.dropItems(b.getLocation(), new int[]{45});
                }
            }
        };
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public void tick(Block b, SlimefunItem sf, Config data) {
                BackpackLoader.this.tick(b);
            }

            public boolean isSynchronized() {
                return false;
            }
        }});
    }

    private void tick(@Nonnull Block b) {
        ItemStack bpItem;
        SlimefunItem sfItem;
        if (this.getCharge(b.getLocation()) < 16) {
            return;
        }
        BlockMenu inv = BlockStorage.getInventory((Block)b);
        boolean invalidItem = false;
        if (inv.getItemInSlot(45) == null) {
            for (int inputSlot : this.getInputSlots()) {
                ItemStack backpackItem = inv.getItemInSlot(inputSlot);
                if (backpackItem == null || !(SlimefunItem.getByItem((ItemStack)backpackItem) instanceof SlimefunBackpack)) continue;
                List lore = backpackItem.getItemMeta().getLore();
                for (String s : lore) {
                    if (!s.equals(ChatColor.GRAY + "ID: <ID>")) continue;
                    invalidItem = true;
                    break;
                }
                if (!invalidItem) {
                    this.moveItem(inv, inputSlot, 45);
                } else if (inv.getItemInSlot(this.getOutputSlots()[0]) == null) {
                    this.moveItem(inv, inputSlot, this.getOutputSlots()[0]);
                }
                return;
            }
        }
        int occupiedInputSlot = 0;
        for (int inputSlot : this.getInputSlots()) {
            if (inv.getItemInSlot(inputSlot) != null && !(SlimefunItem.getByItem((ItemStack)inv.getItemInSlot(inputSlot)) instanceof SlimefunBackpack) && !Tag.SHULKER_BOXES.isTagged((Keyed)inv.getItemInSlot(inputSlot).getType())) {
                occupiedInputSlot = inputSlot;
                break;
            }
            if (inputSlot != this.getInputSlots()[13]) continue;
            return;
        }
        if ((sfItem = SlimefunItem.getByItem((ItemStack)(bpItem = inv.getItemInSlot(45)))) instanceof SlimefunBackpack) {
            ItemStack transferItem = inv.getItemInSlot(occupiedInputSlot);
            int finalOccupiedInputSlot = occupiedInputSlot;
            PlayerProfile.getBackpack((ItemStack)bpItem, backpack -> {
                Inventory bpinv = backpack.getInventory();
                int bpSlot = bpinv.firstEmpty();
                if (bpSlot == -1) {
                    if (inv.getItemInSlot(OUTPUT_SLOTS[0]) == null) {
                        this.moveItem(inv, 45, OUTPUT_SLOTS[0]);
                    }
                    return;
                }
                if (bpinv.getItem(bpSlot) == null) {
                    inv.replaceExistingItem(finalOccupiedInputSlot, null);
                    bpinv.setItem(bpSlot, transferItem);
                    this.removeCharge(b.getLocation(), 16);
                }
            });
        }
    }

    private void moveItem(BlockMenu inv, int slot1, int slot2) {
        ItemStack transferItem = inv.getItemInSlot(slot1);
        inv.replaceExistingItem(slot1, null);
        inv.pushItem(transferItem, new int[]{slot2});
    }

    @Nonnull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getCapacity() {
        return 48;
    }

    public int[] getInputSlots() {
        return INPUT_SLOTS;
    }

    public int[] getOutputSlots() {
        return OUTPUT_SLOTS;
    }

    static void buildBorder(BlockMenuPreset preset, int[] plainBorder, int[] inputBorder, int[] outputBorder) {
        for (int i : plainBorder) {
            preset.addItem(i, (ItemStack)new CustomItemStack(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " ", new String[0]), (p, slot, item, action) -> false);
        }
        for (int i : inputBorder) {
            preset.addItem(i, (ItemStack)new CustomItemStack(new ItemStack(Material.CYAN_STAINED_GLASS_PANE), " ", new String[0]), (p, slot, item, action) -> false);
        }
        for (int i : outputBorder) {
            preset.addItem(i, (ItemStack)new CustomItemStack(new ItemStack(Material.ORANGE_STAINED_GLASS_PANE), " ", new String[0]), (p, slot, item, action) -> false);
        }
    }
}

