/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.fluffymachines.items;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemDropHandler;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.ncbpfluffybear.fluffymachines.FluffyMachines;
import io.ncbpfluffybear.fluffymachines.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class FireproofRune
extends SimpleSlimefunItem<ItemDropHandler> {
    private static final double RANGE = 1.5;
    private static final NamespacedKey FIREPROOF_KEY = new NamespacedKey((Plugin)FluffyMachines.getInstance(), "fireproof");
    private static final String FIREPROOF_LORE = ChatColor.RED + "Fireproof";

    public FireproofRune(ItemGroup category, SlimefunItemStack item, RecipeType type, ItemStack[] recipe) {
        super(category, item, type, recipe);
    }

    @Nonnull
    public ItemDropHandler getItemHandler() {
        return (e, p, item) -> {
            if (this.isItem(item.getItemStack())) {
                if (!this.canUse(p, true)) {
                    return true;
                }
                Utils.runSync(() -> this.activate(p, item), 20L);
                return true;
            }
            return false;
        };
    }

    private void activate(Player p, Item rune) {
        if (!rune.isValid()) {
            return;
        }
        Location l = rune.getLocation();
        Collection entities = l.getWorld().getNearbyEntities(l, 1.5, 1.5, 1.5, this::findCompatibleItem);
        Optional optional = entities.stream().findFirst();
        if (optional.isPresent()) {
            Item item = (Item)optional.get();
            ItemStack itemStack = item.getItemStack();
            if (itemStack.getAmount() == 1) {
                l.getWorld().strikeLightningEffect(l);
                Utils.runSync(() -> {
                    if (rune.isValid() && item.isValid() && itemStack.getAmount() == 1) {
                        l.getWorld().createExplosion(l, 0.0f);
                        l.getWorld().playSound(l, Sound.ENTITY_GENERIC_EXPLODE, 0.3f, 1.0f);
                        item.remove();
                        rune.remove();
                        FireproofRune.setFireproof(itemStack);
                        l.getWorld().dropItemNaturally(l, itemStack);
                        Utils.send((CommandSender)p, "&aYour item is now fireproof");
                    } else {
                        Utils.send((CommandSender)p, "&cYour item could not be made fireproof");
                    }
                }, 10L);
            } else {
                Utils.send((CommandSender)p, "&cYour item could not be made fireproof");
            }
        }
    }

    private boolean findCompatibleItem(Entity entity) {
        if (entity instanceof Item) {
            Item item = (Item)entity;
            return !FireproofRune.isFireproof(item.getItemStack()) && !this.isItem(item.getItemStack());
        }
        return false;
    }

    public static void setFireproof(@Nullable ItemStack item) {
        if (item != null && item.getType() != Material.AIR) {
            boolean isFireproof = FireproofRune.isFireproof(item);
            ItemMeta meta = item.getItemMeta();
            PersistentDataContainer container = meta.getPersistentDataContainer();
            if (!isFireproof) {
                container.set(FIREPROOF_KEY, PersistentDataType.BYTE, (Object)1);
                List lore = meta.hasLore() ? meta.getLore() : new ArrayList();
                lore.add(FIREPROOF_LORE);
                meta.setLore(lore);
                item.setItemMeta(meta);
            }
        }
    }

    public static boolean isFireproof(@Nullable ItemStack item) {
        if (item != null && item.getType() != Material.AIR) {
            ItemMeta meta = item.hasItemMeta() ? item.getItemMeta() : null;
            return FireproofRune.hasFireproofFlag(meta);
        }
        return false;
    }

    private static boolean hasFireproofFlag(@Nullable ItemMeta meta) {
        if (meta != null) {
            PersistentDataContainer container = meta.getPersistentDataContainer();
            return container.has(FIREPROOF_KEY, PersistentDataType.BYTE);
        }
        return false;
    }
}

