/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.fluffymachines.multiblocks.components;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.ncbpfluffybear.fluffymachines.objects.NonHopperableBlock;
import io.ncbpfluffybear.fluffymachines.utils.Utils;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class SuperheatedFurnace
extends NonHopperableBlock {
    private static final int[] inputBorder = new int[]{0, 2, 9, 11, 18, 19, 20};
    private static final int[] dustOutputBorder = new int[]{3, 5, 12, 14, 21, 22, 23};
    private static final int[] ingotOutputBorder = new int[]{6, 8, 15, 17, 24, 25, 26};
    private static final int INPUT_SLOT = 10;
    private static final int DUST_OUTPUT_SLOT = 13;
    private static final int INGOT_OUTPUT_SLOT = 16;
    private static final int INPUT_INDICATOR = 1;
    private static final int DUST_INDICATOR = 4;
    private static final int INGOT_INDICATOR = 7;
    private static final int MAX_STORAGE = 138240;
    private static final Material netherite = Material.NETHERITE_BLOCK;
    private final int MAX_STACK_SIZE = 64;
    private static final SlimefunItemStack[] dusts = new SlimefunItemStack[]{SlimefunItems.COPPER_DUST, SlimefunItems.GOLD_DUST, SlimefunItems.IRON_DUST, SlimefunItems.LEAD_DUST, SlimefunItems.ALUMINUM_DUST, SlimefunItems.ZINC_DUST, SlimefunItems.TIN_DUST, SlimefunItems.SILVER_DUST, SlimefunItems.MAGNESIUM_DUST};
    private static final SlimefunItemStack[] ingots = new SlimefunItemStack[]{SlimefunItems.COPPER_INGOT, SlimefunItems.LEAD_INGOT, SlimefunItems.ALUMINUM_INGOT, SlimefunItems.ZINC_INGOT, SlimefunItems.TIN_INGOT, SlimefunItems.SILVER_INGOT, SlimefunItems.MAGNESIUM_INGOT};
    private final int OVERFLOW_AMOUNT = 3240;
    private final ItemSetting<Boolean> breakOnlyWhenEmpty = new ItemSetting((SlimefunItem)this, "break-only-when-empty", (Object)false);

    public SuperheatedFurnace(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.addItemHandler(new ItemHandler[]{this.onBreak()});
        this.addItemSetting(new ItemSetting[]{this.breakOnlyWhenEmpty});
        new BlockMenuPreset(this.getId(), "&cFoundry"){

            public void init() {
                SuperheatedFurnace.this.constructMenu(this);
            }

            public void newInstance(@Nonnull BlockMenu menu, @Nonnull Block b) {
                if (BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"stored") == null) {
                    menu.replaceExistingItem(4, (ItemStack)new CustomItemStack(Material.GUNPOWDER, "&6Dust Available: &e0", new String[]{"&a> &eLeft Click &ahere to retrieve 1", "&a> &eLeft Click &ahere to retrieve 64"}));
                    menu.replaceExistingItem(7, (ItemStack)new CustomItemStack(Material.IRON_INGOT, "&6Ingots Available: &e0", new String[]{"&a> &eRight Click &ahere to retrieve 1", "&a> &eLeft Click &ahere to retrieve 64"}));
                    menu.replaceExistingItem(1, (ItemStack)new CustomItemStack(Material.CHEST, "&6Melted Dust: &e0 &7(0%)", new String[]{"&bType: None", "&7Stacks: 0"}));
                    BlockStorage.addBlockInfo((Block)b, (String)"stored", (String)"0");
                }
                menu.addMenuClickHandler(1, (p, slot, item, action) -> false);
                menu.addMenuClickHandler(4, (p, slot, item, action) -> {
                    SuperheatedFurnace.this.retrieveDust(menu, b, action.isRightClicked());
                    return false;
                });
                menu.addMenuClickHandler(7, (p, slot, item, action) -> {
                    SuperheatedFurnace.this.retrieveIngot(menu, b, action.isRightClicked());
                    return false;
                });
            }

            public boolean canOpen(@Nonnull Block b, @Nonnull Player p) {
                return (p.hasPermission("slimefun.inventory.bypass") || Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), Interaction.INTERACT_BLOCK)) && SuperheatedFurnace.this.getBlockInfo(b.getLocation(), "accessible") != null && SuperheatedFurnace.this.getBlockInfo(b.getLocation(), "ignited") != null && SuperheatedFurnace.this.checkStructure(b);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow itemTransportFlow) {
                return new int[0];
            }

            public int[] getSlotsAccessedByItemTransport(DirtyChestMenu menu, ItemTransportFlow flow, ItemStack item) {
                if (flow == ItemTransportFlow.INSERT) {
                    return new int[]{10};
                }
                if (flow == ItemTransportFlow.WITHDRAW) {
                    return new int[]{13, 16};
                }
                return new int[0];
            }
        };
    }

    private BlockBreakHandler onBreak() {
        return new BlockBreakHandler(false, false){

            public void onPlayerBreak(@Nonnull BlockBreakEvent e, @Nonnull ItemStack item, @Nonnull List<ItemStack> drops) {
                Block b = e.getBlock();
                Player p = e.getPlayer();
                BlockMenu inv = BlockStorage.getInventory((Block)b);
                if (inv != null) {
                    Entity en;
                    int itemCount = 0;
                    int stored = Integer.parseInt(SuperheatedFurnace.this.getBlockInfo(b.getLocation(), "stored"));
                    String type = SuperheatedFurnace.this.getBlockInfo(b.getLocation(), "type");
                    if (((Boolean)SuperheatedFurnace.this.breakOnlyWhenEmpty.getValue()).booleanValue() && stored != 0) {
                        Utils.send((CommandSender)p, "&cThis barrel can't be broken since it has items inside it!");
                        e.setCancelled(true);
                        return;
                    }
                    for (Entity en2 : p.getNearbyEntities(5.0, 5.0, 5.0)) {
                        if (!(en2 instanceof Item)) continue;
                        ++itemCount;
                    }
                    if (itemCount > 5) {
                        Utils.send((CommandSender)p, "&cPlease remove nearby items before breaking this superheated furnace!");
                        e.setCancelled(true);
                        return;
                    }
                    inv.dropItems(b.getLocation(), new int[]{10});
                    inv.dropItems(b.getLocation(), new int[]{13});
                    inv.dropItems(b.getLocation(), new int[]{16});
                    if (stored > 0) {
                        int stackSize = 64;
                        ItemStack dust = SlimefunItem.getById((String)(type + "_DUST")).getItem();
                        if (stored > 3240) {
                            int toRemove;
                            Utils.send((CommandSender)p, "&eThere are more than 3240 items in this superheated furnace! Dropping 3240 items instead!");
                            for (toRemove = 3240; toRemove >= stackSize; toRemove -= stackSize) {
                                b.getWorld().dropItemNaturally(b.getLocation(), (ItemStack)new CustomItemStack(dust, stackSize));
                            }
                            if (toRemove > 0) {
                                b.getWorld().dropItemNaturally(b.getLocation(), (ItemStack)new CustomItemStack(dust, toRemove));
                            }
                            BlockStorage.addBlockInfo((Block)b, (String)"stored", (String)String.valueOf(stored - 3240));
                            e.setCancelled(true);
                            SuperheatedFurnace.this.updateIndicator(b);
                            return;
                        }
                        while (stored >= stackSize) {
                            b.getWorld().dropItemNaturally(b.getLocation(), (ItemStack)new CustomItemStack(dust, stackSize));
                            stored -= stackSize;
                        }
                        if (stored > 0) {
                            b.getWorld().dropItemNaturally(b.getLocation(), (ItemStack)new CustomItemStack(dust, stored));
                        }
                        if (BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"stand") != null) {
                            Bukkit.getEntity((UUID)UUID.fromString(BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"stand"))).remove();
                        }
                        BlockStorage.addBlockInfo((Block)b, (String)"stored", (String)"0");
                        SuperheatedFurnace.this.updateIndicator(b);
                        return;
                    }
                    if (BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"stand") != null && (en = Bukkit.getEntity((UUID)UUID.fromString(BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"stand")))) != null) {
                        en.remove();
                    }
                }
            }
        };
    }

    protected void constructMenu(BlockMenuPreset preset) {
        for (int i : dustOutputBorder) {
            preset.addItem(i, (ItemStack)new CustomItemStack(new ItemStack(Material.ORANGE_STAINED_GLASS_PANE), " ", new String[0]), (p, slot, item, action) -> false);
        }
        for (int i : inputBorder) {
            preset.addItem(i, (ItemStack)new CustomItemStack(new ItemStack(Material.CYAN_STAINED_GLASS_PANE), " ", new String[0]), (p, slot, item, action) -> false);
        }
        for (int i : ingotOutputBorder) {
            preset.addItem(i, (ItemStack)new CustomItemStack(new ItemStack(Material.RED_STAINED_GLASS_PANE), " ", new String[0]), (p, slot, item, action) -> false);
        }
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public void tick(Block b, SlimefunItem sf, Config data) {
                SuperheatedFurnace.this.tick(b);
            }

            public boolean isSynchronized() {
                return false;
            }
        }});
    }

    protected void tick(Block b) {
        BlockMenu inv = BlockStorage.getInventory((Block)b);
        ItemStack inputItem = inv.getItemInSlot(10);
        if (inputItem != null) {
            int amount = inputItem.getAmount();
            String type = this.getBlockInfo(b.getLocation(), "type");
            SlimefunItem sfItem = SlimefunItem.getByItem((ItemStack)inputItem);
            int stored = Integer.parseInt(this.getBlockInfo(b.getLocation(), "stored"));
            if (type == null) {
                if (sfItem != null) {
                    if (sfItem.getId().endsWith("_DUST")) {
                        for (SlimefunItemStack dust : dusts) {
                            if (sfItem != dust.getItem()) continue;
                            inv.consumeItem(10, amount);
                            this.registerDust(b, dust.getItemId().replace("_DUST", ""), amount);
                            break;
                        }
                    } else if (sfItem.getId().endsWith("_INGOT")) {
                        for (SlimefunItemStack ingot : ingots) {
                            if (sfItem != ingot.getItem()) continue;
                            inv.consumeItem(10, amount);
                            this.registerDust(b, ingot.getItemId().replace("_INGOT", ""), amount);
                            break;
                        }
                    } else if (sfItem.getId().equals(SlimefunItems.GOLD_4K.getItemId())) {
                        inv.consumeItem(10, amount);
                        this.registerDust(b, "GOLD", amount);
                    }
                } else if (inputItem.getType() == Material.IRON_INGOT && inputItem.getItemMeta().equals(new ItemStack(Material.IRON_INGOT).getItemMeta())) {
                    inv.consumeItem(10, amount);
                    this.registerDust(b, "IRON", amount);
                }
            } else if (sfItem != null && (sfItem.getId().equals(type + "_DUST") || sfItem.getId().equals(type + "_INGOT") || type.equals("GOLD") && sfItem.getId().equals(SlimefunItems.GOLD_4K.getItemId())) || type.equals("IRON") && inputItem.getType() == Material.IRON_INGOT && inputItem.getItemMeta().equals(new ItemStack(Material.IRON_INGOT).getItemMeta()) && stored + amount < 138240) {
                inv.consumeItem(10, amount);
                this.addDust(b, amount);
            }
        }
    }

    private void registerDust(Block b, String type, int amount) {
        int stored = Integer.parseInt(this.getBlockInfo(b.getLocation(), "stored"));
        this.setBlockInfo(b, "stored", String.valueOf(stored + amount));
        this.setBlockInfo(b, "type", type);
        this.updateIndicator(b);
    }

    private void addDust(Block b, int amount) {
        int stored = Integer.parseInt(this.getBlockInfo(b.getLocation(), "stored"));
        this.setBlockInfo(b, "stored", String.valueOf(stored + amount));
        this.updateIndicator(b);
    }

    private void updateIndicator(Block b) {
        BlockMenu inv = BlockStorage.getInventory((Block)b);
        String stored = this.getBlockInfo(b.getLocation(), "stored");
        String type = WordUtils.capitalizeFully((String)this.getBlockInfo(b.getLocation(), "type"));
        if (stored.equals("0")) {
            this.setBlockInfo(b, "type", null);
            inv.replaceExistingItem(1, (ItemStack)new CustomItemStack(new ItemStack(Material.CHEST), "&6Melted Dust: &e0 &7(0%)", new String[]{"&bType: None", "&7Stacks: 0"}));
        } else {
            inv.replaceExistingItem(1, (ItemStack)new CustomItemStack(new ItemStack(Material.CHEST), "&6Melted Dust: &e" + stored + " &7(" + Double.parseDouble(stored) / 138240.0 * 100.0 + "%)", new String[]{"&bType: " + type, "&7Stacks: " + Double.parseDouble(stored) / 64.0}));
        }
        inv.replaceExistingItem(4, (ItemStack)new CustomItemStack(new ItemStack(Material.GUNPOWDER), "&6Dust Available: &e" + stored, new String[]{"&a> &eLeft Click &ahere to retrieve 1", "&a> &eRight Click &ahere to retrieve 64"}));
        inv.replaceExistingItem(7, (ItemStack)new CustomItemStack(new ItemStack(Material.IRON_INGOT), "&6Ingots Available: &e" + stored, new String[]{"&a> &eLeft Click &ahere to retrieve 1", "&a> &eRight Click &ahere to retrieve 64"}));
    }

    private void retrieveDust(BlockMenu menu, Block b, boolean isRightClicked) {
        if (this.getBlockInfo(b.getLocation(), "stored") == null) {
            return;
        }
        int stored = Integer.parseInt(this.getBlockInfo(b.getLocation(), "stored"));
        if (stored > 0 && (menu.getItemInSlot(13) == null || menu.getItemInSlot(13).getAmount() < 64)) {
            String type = this.getBlockInfo(b.getLocation(), "type");
            int amount = !isRightClicked ? 1 : (stored < 64 ? stored : (menu.getItemInSlot(13) == null ? 64 : 64 - menu.getItemInSlot(13).getAmount()));
            CustomItemStack dustItem = new CustomItemStack(SlimefunItem.getById((String)(type + "_DUST")).getItem().clone(), amount);
            if (menu.fits((ItemStack)dustItem, new int[]{13})) {
                this.setBlockInfo(b, "stored", String.valueOf(stored - amount));
                menu.pushItem((ItemStack)dustItem, new int[]{13});
            }
            this.updateIndicator(b);
        }
    }

    private void retrieveIngot(BlockMenu menu, Block b, boolean isRightClicked) {
        if (this.getBlockInfo(b.getLocation(), "stored") == null) {
            return;
        }
        int stored = Integer.parseInt(this.getBlockInfo(b.getLocation(), "stored"));
        if (stored > 0 && (menu.getItemInSlot(16) == null || menu.getItemInSlot(16).getAmount() < 64)) {
            String type = this.getBlockInfo(b.getLocation(), "type");
            int amount = !isRightClicked ? 1 : (stored < 64 ? stored : (menu.getItemInSlot(16) == null ? 64 : 64 - menu.getItemInSlot(16).getAmount()));
            Object ingotItem = type.equals("GOLD") ? new CustomItemStack(SlimefunItems.GOLD_4K.getItem().getItem().clone(), amount) : (type.equals("IRON") ? new ItemStack(Material.IRON_INGOT, amount) : new CustomItemStack(SlimefunItem.getById((String)(type + "_INGOT")).getItem().clone(), amount));
            if (menu.fits((ItemStack)ingotItem, new int[]{16})) {
                this.setBlockInfo(b, "stored", String.valueOf(stored - amount));
                menu.pushItem((ItemStack)ingotItem, new int[]{16});
            }
            this.updateIndicator(b);
        }
    }

    private boolean checkStructure(Block b) {
        Block relative;
        BlockFace face;
        if (b.getRelative(BlockFace.NORTH).getType() == netherite) {
            face = BlockFace.NORTH;
            relative = b.getRelative(face);
        } else if (b.getRelative(BlockFace.EAST).getType() == netherite) {
            face = BlockFace.EAST;
            relative = b.getRelative(face);
        } else {
            return false;
        }
        return b.getRelative(face).getType() == netherite && this.checkRite(relative.getRelative(0, -1, 0)) && this.checkRite(relative.getRelative(0, -2, 0)) && this.checkRite(b.getRelative(face.getOppositeFace()).getRelative(0, -1, 0)) && this.checkRite(b.getRelative(face.getOppositeFace()).getRelative(0, -2, 0)) && b.getRelative(0, -1, 0).getType() == Material.GLASS && b.getRelative(0, -2, 0).getType() == Material.CAULDRON;
    }

    private boolean checkRite(Block b) {
        return b.getType() == netherite;
    }

    private void setBlockInfo(Block b, String key, String data) {
        BlockStorage.addBlockInfo((Block)b, (String)key, (String)data);
    }

    private String getBlockInfo(Location l, String key) {
        return BlockStorage.getLocationInfo((Location)l, (String)key);
    }
}

