/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.fluffymachines.utils;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.ncbpfluffybear.fluffymachines.items.Barrel;
import io.ncbpfluffybear.fluffymachines.items.FireproofRune;
import io.ncbpfluffybear.fluffymachines.items.HelicopterHat;
import io.ncbpfluffybear.fluffymachines.items.tools.WateringCan;
import io.ncbpfluffybear.fluffymachines.machines.AlternateElevatorPlate;
import io.ncbpfluffybear.fluffymachines.utils.CancelPlace;
import io.ncbpfluffybear.fluffymachines.utils.FluffyItems;
import io.ncbpfluffybear.fluffymachines.utils.Utils;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Events
implements Listener {
    final HelicopterHat helicopterHat = (HelicopterHat)FluffyItems.HELICOPTER_HAT.getItem();
    final WateringCan wateringCan = (WateringCan)FluffyItems.WATERING_CAN.getItem();

    @EventHandler(ignoreCancelled=true)
    public void onHelicopterHatUse(PlayerToggleSneakEvent e) {
        Player p = e.getPlayer();
        if (this.helicopterHat.isItem(p.getEquipment().getHelmet())) {
            if (e.isSneaking()) {
                p.addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, 1000000, 4));
            } else {
                p.removePotionEffect(PotionEffectType.LEVITATION);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onWateringCanSplash(PlayerInteractEntityEvent e) {
        Player p = e.getPlayer();
        ItemStack item = p.getInventory().getItemInMainHand();
        if (this.wateringCan.isItem(item)) {
            e.setCancelled(true);
            Entity target = e.getRightClicked();
            if (target instanceof Player && WateringCan.updateUses(this.wateringCan, p, item, 3)) {
                Utils.send((CommandSender)p, "&bSplash!");
                Utils.send((CommandSender)((Player)target), "&bYou were splashed by " + p.getDisplayName() + "!");
                ((Player)target).addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 60, 1));
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerDamage(EntityDamageEvent e) {
        Player p;
        ItemStack helmet;
        if (e.getEntity() instanceof Player && ((Player)e.getEntity()).getEquipment() != null && e.getCause() == EntityDamageEvent.DamageCause.FALL && (helmet = (p = (Player)e.getEntity()).getEquipment().getHelmet()) != null && this.helicopterHat.isItem(helmet)) {
            e.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onNonClickableClick(InventoryClickEvent e) {
        ItemStack item = e.getCurrentItem();
        if (item != null && item.getType() != Material.AIR && item.getItemMeta().hasCustomModelData() && item.getItemMeta().getCustomModelData() == 6969 || Utils.checkNonInteractable(item)) {
            e.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onHeadRemove(PlayerArmorStandManipulateEvent e) {
        if (e.getRightClicked().getCustomName() != null && e.getRightClicked().getCustomName().equals("hehexdfluff")) {
            e.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onItemDamage(EntityDamageEvent e) {
        ItemStack item;
        Entity en = e.getEntity();
        if (en instanceof Item && FireproofRune.isFireproof(item = ((Item)en).getItemStack()) && (e.getCause() == EntityDamageEvent.DamageCause.FIRE || e.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK || e.getCause() == EntityDamageEvent.DamageCause.LAVA || e.getCause() == EntityDamageEvent.DamageCause.LIGHTNING) && !en.isDead()) {
            en.remove();
            en.getLocation().getWorld().dropItem(en.getLocation(), item);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerWarp(PlayerToggleSneakEvent e) {
        Player p;
        Block b;
        if (e.isSneaking() && BlockStorage.hasBlockInfo((Block)(b = (p = e.getPlayer()).getLocation().subtract(0.0, 1.0, 0.0).getBlock())) && BlockStorage.check((Block)b) == FluffyItems.WARP_PAD.getItem() && BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"type").equals("origin")) {
            Location l = b.getLocation();
            Location destination = new Location(b.getWorld(), (double)Integer.parseInt(BlockStorage.getLocationInfo((Location)l, (String)"x")), (double)Integer.parseInt(BlockStorage.getLocationInfo((Location)l, (String)"y")), (double)Integer.parseInt(BlockStorage.getLocationInfo((Location)l, (String)"z")));
            float yaw = p.getLocation().getYaw();
            float pitch = p.getLocation().getPitch();
            if (BlockStorage.hasBlockInfo((Location)destination) && BlockStorage.getLocationInfo((Location)destination, (String)"type") != null && BlockStorage.getLocationInfo((Location)destination, (String)"type").equals("destination") && destination.getBlock().getRelative(BlockFace.UP).getType() == Material.AIR && destination.getBlock().getRelative(BlockFace.UP, 2).getType() == Material.AIR) {
                destination.setPitch(pitch);
                destination.setYaw(yaw);
                p.teleport(destination.add(0.5, 1.0, 0.5));
                p.playSound(p.getLocation(), Sound.ITEM_CHORUS_FRUIT_TELEPORT, 0.5f, 0.5f);
                p.spawnParticle(Particle.DRAGON_BREATH, p.getLocation(), 10);
            } else {
                Utils.send((CommandSender)p, "&cMissing destination Warp Pad!");
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPressurePlateEnter(PlayerInteractEvent e) {
        if (e.getAction() != Action.PHYSICAL || e.getClickedBlock() == null) {
            return;
        }
        String id = BlockStorage.checkID((Block)e.getClickedBlock());
        if (id != null && id.equals(FluffyItems.ALTERNATE_ELEVATOR_PLATE.getItemId())) {
            AlternateElevatorPlate elevator = (AlternateElevatorPlate)FluffyItems.ALTERNATE_ELEVATOR_PLATE.getItem();
            elevator.openInterface(e.getPlayer(), e.getClickedBlock());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onExtractionNodePlace(BlockPlaceEvent e) {
        if ((e.getBlock().getY() != e.getBlockAgainst().getY() || e.getBlockAgainst().getType() != Material.ENDER_CHEST) && this.isExtractionNode(e.getItemInHand())) {
            Utils.send((CommandSender)e.getPlayer(), "&cYou can only place this on an Ender Chest!");
            e.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onDollyDispense(BlockDispenseEvent e) {
        SlimefunItem sfItem = SlimefunItem.getByItem((ItemStack)e.getItem());
        if (sfItem != null && sfItem.getId().equals(FluffyItems.DOLLY.getItemId())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBarrelBurn(BlockBurnEvent e) {
        if (BlockStorage.check((Block)e.getBlock()) instanceof Barrel) {
            e.setCancelled(true);
        }
    }

    private boolean isExtractionNode(@Nonnull ItemStack item) {
        SlimefunItem sfItem = SlimefunItem.getByItem((ItemStack)item);
        if (sfItem == null) {
            return false;
        }
        return sfItem.getId().equals(FluffyItems.ENDER_CHEST_EXTRACTION_NODE.getItemId()) || sfItem.getId().equals(FluffyItems.ENDER_CHEST_INSERTION_NODE.getItemId());
    }

    @EventHandler(ignoreCancelled=true)
    private void onCancelPlace(BlockPlaceEvent e) {
        ItemStack item = e.getItemInHand();
        SlimefunItem sfItem = SlimefunItem.getByItem((ItemStack)item);
        if (sfItem instanceof CancelPlace) {
            e.setCancelled(true);
        }
    }
}

