/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.fluffymachines.machines;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.ncbpfluffybear.fluffymachines.utils.Utils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;

public class AlternateElevatorPlate
extends SimpleSlimefunItem<BlockUseHandler> {
    private static final String DATA_KEY = "floor";
    private final Set<UUID> users = new HashSet<UUID>();
    private static final int MAX_CHEST_INDEX = 53;

    public AlternateElevatorPlate(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, ItemStack recipeOutput) {
        super(category, item, recipeType, recipe, recipeOutput);
        this.addItemHandler(new ItemHandler[]{this.onPlace()});
    }

    private BlockPlaceHandler onPlace() {
        return new BlockPlaceHandler(false){

            public void onPlayerPlace(@Nonnull BlockPlaceEvent e) {
                Block b = e.getBlock();
                BlockStorage.addBlockInfo((Block)b, (String)AlternateElevatorPlate.DATA_KEY, (String)"&fFloor #0");
                BlockStorage.addBlockInfo((Block)b, (String)"owner", (String)e.getPlayer().getUniqueId().toString());
            }
        };
    }

    @Nonnull
    public Set<UUID> getUsers() {
        return this.users;
    }

    @Nonnull
    public BlockUseHandler getItemHandler() {
        return e -> {
            Block b = (Block)e.getClickedBlock().get();
            if (BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"owner").equals(e.getPlayer().getUniqueId().toString())) {
                this.openEditor(e.getPlayer(), b);
            }
        };
    }

    @Nonnull
    public List<Block> getFloors(@Nonnull Block b) {
        LinkedList<Block> floors = new LinkedList<Block>();
        for (int y = b.getWorld().getMaxHeight(); y > -64; --y) {
            if (y == b.getY()) {
                floors.add(b);
                continue;
            }
            Block block = b.getWorld().getBlockAt(b.getX(), y, b.getZ());
            if (block.getType() != this.getItem().getType() || !BlockStorage.check((Block)block, (String)this.getId())) continue;
            floors.add(block);
        }
        return floors;
    }

    @ParametersAreNonnullByDefault
    public void openInterface(Player p, Block b) {
        if (this.users.remove(p.getUniqueId())) {
            return;
        }
        List<Block> floors = this.getFloors(b);
        if (floors.size() < 2) {
            Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.ELEVATOR.no-destinations", true);
        } else {
            this.openFloorSelector(b, floors, p);
        }
    }

    @ParametersAreNonnullByDefault
    private void openFloorSelector(Block b, List<Block> floors, Player p) {
        int i;
        ChestMenu elevatorMenu = new ChestMenu("Elevator");
        for (i = 0; i < floors.size() && i <= 53; ++i) {
            Block destination = floors.get(i);
            String floor = ChatColors.color((String)BlockStorage.getLocationInfo((Location)destination.getLocation(), (String)DATA_KEY));
            this.addFloor(elevatorMenu, i, p, floor, b, destination);
        }
        if (floors.size() < 53) {
            for (i = floors.size(); i <= 53; ++i) {
                elevatorMenu.addItem(i, (ItemStack)new CustomItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE, "", new String[0]));
                elevatorMenu.addMenuClickHandler(i, ChestMenuUtils.getEmptyClickHandler());
            }
        }
        elevatorMenu.open(new Player[]{p});
    }

    @ParametersAreNonnullByDefault
    private void teleport(Player player, String floorName, Block target) {
        Utils.runSync(() -> {
            this.users.add(player.getUniqueId());
            float yaw = player.getEyeLocation().getYaw() + 180.0f;
            if (yaw > 180.0f) {
                yaw = -180.0f + (yaw - 180.0f);
            }
            Location destination = new Location(player.getWorld(), (double)target.getX() + 0.5, (double)target.getY() + 0.4, (double)target.getZ() + 0.5, yaw, player.getEyeLocation().getPitch());
            PaperLib.teleportAsync((Entity)player, (Location)destination).thenAccept(teleported -> {
                if (teleported.booleanValue()) {
                    player.sendTitle(ChatColor.WHITE + ChatColors.color((String)floorName), null, 20, 60, 20);
                }
            });
        });
    }

    @ParametersAreNonnullByDefault
    public void openEditor(Player p, Block b) {
        ChestMenu menu = new ChestMenu("Elevator Settings");
        menu.addItem(4, (ItemStack)new CustomItemStack(Material.NAME_TAG, "&7Floor Name &e(Click to edit)", new String[]{"", "&f" + ChatColors.color((String)BlockStorage.getLocationInfo((Location)b.getLocation(), (String)DATA_KEY))}));
        menu.addMenuClickHandler(4, (pl, slot, item, action) -> {
            pl.closeInventory();
            pl.sendMessage("");
            Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.ELEVATOR.enter-name");
            pl.sendMessage("");
            ChatUtils.awaitInput((Player)pl, message -> {
                BlockStorage.addBlockInfo((Block)b, (String)DATA_KEY, (String)message.replace('\u00a7', '&'));
                pl.sendMessage("");
                Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.ELEVATOR.named", msg -> msg.replace("%floor%", (CharSequence)message));
                pl.sendMessage("");
                this.openEditor(pl, b);
            });
            return false;
        });
        menu.open(new Player[]{p});
    }

    private void addFloor(ChestMenu menu, int slot, Player p, String floor, Block b, Block destination) {
        if (destination.getY() == b.getY()) {
            menu.addItem(slot, (ItemStack)new CustomItemStack(Material.LIME_STAINED_GLASS_PANE, ChatColors.color((String)Slimefun.getLocalization().getMessage(p, "machines.ELEVATOR.current-floor")), new String[]{"", ChatColor.WHITE + floor, ""}));
            menu.addMenuClickHandler(slot, ChestMenuUtils.getEmptyClickHandler());
        } else {
            menu.addItem(slot, (ItemStack)new CustomItemStack(Material.GRAY_STAINED_GLASS_PANE, ChatColors.color((String)Slimefun.getLocalization().getMessage(p, "machines.ELEVATOR.click-to-teleport")), new String[]{"", ChatColor.WHITE + floor, ""}));
            menu.addMenuClickHandler(slot, (player, clickSlot, item, action) -> {
                this.teleport(p, floor, destination);
                return false;
            });
        }
    }
}

