/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.fluffymachines.machines;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.ncbpfluffybear.fluffymachines.utils.Constants;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class ElectricDustRecycler
extends AContainer
implements RecipeDisplayItem {
    public static final int ENERGY_CONSUMPTION = 32;
    public static final int CAPACITY = 96;

    public ElectricDustRecycler(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.addItemHandler(new ItemHandler[]{this.onBreak()});
    }

    private BlockBreakHandler onBreak() {
        return new BlockBreakHandler(false, false){

            public void onPlayerBreak(@Nonnull BlockBreakEvent e, @Nonnull ItemStack item, @Nonnull List<ItemStack> drops) {
                Block b = e.getBlock();
                BlockMenu inv = BlockStorage.getInventory((Block)b);
                if (inv != null) {
                    inv.dropItems(b.getLocation(), ElectricDustRecycler.this.getInputSlots());
                    inv.dropItems(b.getLocation(), ElectricDustRecycler.this.getOutputSlots());
                }
            }
        };
    }

    protected void registerDefaultRecipes() {
        for (SlimefunItemStack dust : Constants.dusts) {
            this.registerRecipe(1, (ItemStack)new CustomItemStack((ItemStack)dust, 8), (ItemStack)SlimefunItems.SIFTED_ORE);
        }
    }

    @Nonnull
    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> displayRecipes = new ArrayList<ItemStack>(this.recipes.size() * 2);
        for (MachineRecipe recipe : this.recipes) {
            displayRecipes.add(recipe.getInput()[0]);
            displayRecipes.add(recipe.getOutput()[recipe.getOutput().length - 1]);
        }
        return displayRecipes;
    }

    public ItemStack getProgressBar() {
        return new ItemStack(Material.PISTON);
    }

    public int getEnergyConsumption() {
        return 32;
    }

    public int getCapacity() {
        return 96;
    }

    public int getSpeed() {
        return 1;
    }

    @Nonnull
    public String getInventoryTitle() {
        return "&fElectric Dust Recycler";
    }

    @Nonnull
    public String getMachineIdentifier() {
        return "ELECTRIC_DUST_RECYCLER";
    }
}

