/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.fluffymachines.items.tools;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.DamageableItem;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.attributes.Rechargeable;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.items.cargo.TrashCan;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.ncbpfluffybear.fluffymachines.FluffyMachines;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class FluffyWrench
extends SimpleSlimefunItem<ItemUseHandler>
implements Listener,
DamageableItem,
Rechargeable {
    private final Wrench type;
    private final HashMap<UUID, Long> cooldowns = new HashMap();
    private static final int WRENCH_DELAY = 250;

    public FluffyWrench(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Wrench type) {
        super(category, item, recipeType, recipe);
        this.type = type;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)FluffyMachines.getInstance());
    }

    @Nonnull
    public ItemUseHandler getItemHandler() {
        return e -> e.setUseBlock(Event.Result.DENY);
    }

    @EventHandler
    public void onWrenchInteract(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        ItemStack wrenchItem = e.getItem();
        Long cooldown = this.cooldowns.get(p.getUniqueId());
        if (this.isItem(wrenchItem) && cooldown != null && System.currentTimeMillis() - cooldown < 250L) {
            return;
        }
        this.cooldowns.put(p.getUniqueId(), System.currentTimeMillis());
        Block block = e.getClickedBlock();
        if (this.isItem(e.getItem()) && !this.isItem(p.getInventory().getItemInOffHand()) && e.getAction().toString().endsWith("_BLOCK") && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)e.getPlayer(), block.getLocation(), Interaction.BREAK_BLOCK)) {
            e.setCancelled(true);
            SlimefunItem slimefunBlock = BlockStorage.check((Block)block);
            if (slimefunBlock == null || !(slimefunBlock instanceof EnergyNetComponent) && !slimefunBlock.getId().startsWith("CARGO_NODE") && !slimefunBlock.getId().equals(SlimefunItems.CARGO_MANAGER.getItemId()) && !(slimefunBlock instanceof TrashCan)) {
                return;
            }
            if (!this.type.isElectric) {
                this.damageItem(p, wrenchItem);
                FluffyWrench.breakBlock(block, p);
            } else if (this.removeItemCharge(wrenchItem, 1.0f)) {
                FluffyWrench.breakBlock(block, p);
            }
        }
    }

    public static void breakBlock(Block block, Player p) {
        BlockBreakEvent breakEvent = new BlockBreakEvent(block, p);
        Bukkit.getPluginManager().callEvent((Event)breakEvent);
        if (!breakEvent.isCancelled()) {
            BlockStorage.clearBlockInfo((Block)block);
            block.setType(Material.AIR);
        }
    }

    public boolean isDamageable() {
        return true;
    }

    public float getMaxItemCharge(ItemStack item) {
        if (!this.type.isElectric) {
            return 0.0f;
        }
        return this.type.getMaxCharge();
    }

    public static enum Wrench {
        DEFAULT(Material.GOLDEN_AXE, false, 0),
        REINFORCED(Material.DIAMOND_AXE, false, 0),
        CARBONADO(Material.NETHERITE_AXE, true, 5000);

        private final Material material;
        private final boolean isElectric;
        private final int maxCharge;

        private Wrench(Material material, boolean isElectric, int maxCharge) {
            this.material = material;
            this.isElectric = isElectric;
            this.maxCharge = maxCharge;
        }

        public Material getMaterial() {
            return this.material;
        }

        public boolean isElectric() {
            return this.isElectric;
        }

        public int getMaxCharge() {
            return this.maxCharge;
        }
    }
}

