/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.fluffymachines.items.tools;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.Pair;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.ncbpfluffybear.fluffymachines.FluffyMachines;
import io.ncbpfluffybear.fluffymachines.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class CargoManipulator
extends SimpleSlimefunItem<ItemUseHandler>
implements Listener {
    private static final int[] CARGO_SLOTS = new int[]{19, 20, 21, 28, 29, 30, 37, 38, 39};
    private final Map<Player, Pair<JsonObject, ItemStack[]>> storedFilters = new HashMap<Player, Pair<JsonObject, ItemStack[]>>();

    public CargoManipulator(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)FluffyMachines.getInstance());
    }

    @Nonnull
    public ItemUseHandler getItemHandler() {
        return e -> e.setUseBlock(Event.Result.DENY);
    }

    @EventHandler
    private void onCargoManipulatorUse(PlayerInteractEvent e) {
        ItemStack manipulator = e.getItem();
        if (manipulator == null || !this.isItem(manipulator)) {
            return;
        }
        e.setCancelled(true);
        Action act = e.getAction();
        Player p = e.getPlayer();
        Block b = e.getClickedBlock();
        SlimefunItemStack nodeType = this.getCargoNodeType(b);
        if (nodeType == null || nodeType != SlimefunItems.CARGO_OUTPUT_NODE && nodeType != SlimefunItems.CARGO_OUTPUT_NODE_2 && nodeType != SlimefunItems.CARGO_INPUT_NODE) {
            return;
        }
        if (!Slimefun.getProtectionManager().hasPermission((OfflinePlayer)e.getPlayer(), b.getLocation(), Interaction.INTERACT_BLOCK)) {
            return;
        }
        if (act == Action.RIGHT_CLICK_BLOCK) {
            if (p.isSneaking()) {
                this.clearNode(b, p, this.getCargoNodeType(b));
            } else {
                this.copyNode(b, p, this.getCargoNodeType(b));
            }
        } else {
            this.pasteNode(b, p, this.getCargoNodeType(b));
        }
    }

    private void copyNode(Block parent, Player p, SlimefunItemStack nodeType) {
        JsonObject nodeData = (JsonObject)new JsonParser().parse(BlockStorage.getBlockInfoAsJson((Block)parent));
        ItemStack[] filterItems = new ItemStack[9];
        if (nodeType != SlimefunItems.CARGO_OUTPUT_NODE) {
            BlockMenu parentInventory = BlockStorage.getInventory((Block)parent);
            for (int i = 0; i < 9; ++i) {
                ItemStack menuItem = parentInventory.getItemInSlot(CARGO_SLOTS[i]);
                filterItems[i] = menuItem != null ? new CustomItemStack(menuItem, 1) : null;
            }
        }
        this.storedFilters.put(p, (Pair<JsonObject, ItemStack[]>)new Pair((Object)nodeData, (Object)filterItems));
        Utils.send((CommandSender)p, "&aYour " + SlimefunItem.getById((String)nodeData.get("id").getAsString()).getItemName() + " &ahas been copied.");
        this.createParticle(parent, Color.fromRGB((int)255, (int)252, (int)51));
    }

    private void pasteNode(Block child, Player p, SlimefunItemStack nodeType) {
        Pair nodeSettings = this.storedFilters.getOrDefault(p, null);
        if (nodeSettings == null) {
            Utils.send((CommandSender)p, "&cYou have not copied a cargo node yet.");
            return;
        }
        JsonObject jsonData = (JsonObject)nodeSettings.getFirstValue();
        SlimefunItemStack savedNodeType = (SlimefunItemStack)SlimefunItem.getById((String)jsonData.get("id").getAsString()).getItem();
        if (savedNodeType != nodeType) {
            Utils.send((CommandSender)p, "&cYou copied a " + savedNodeType.getDisplayName() + " &cbut you are trying to modify a " + nodeType.getDisplayName() + "&c!");
            this.createParticle(child, Color.RED);
            return;
        }
        BlockStorage.setBlockInfo((Block)child, (String)jsonData.toString(), (boolean)false);
        if (nodeType != SlimefunItems.CARGO_OUTPUT_NODE) {
            BlockMenu nodeMenu = BlockStorage.getInventory((Block)child);
            ItemStack[] filterItems = (ItemStack[])nodeSettings.getSecondValue();
            PlayerInventory playerInventory = p.getInventory();
            block0: for (int i = 0; i < 9; ++i) {
                if (SlimefunUtils.isItemSimilar((ItemStack)filterItems[i], (ItemStack)nodeMenu.getItemInSlot(CARGO_SLOTS[i]), (boolean)true, (boolean)false)) continue;
                this.clearFilterSlot(nodeMenu, CARGO_SLOTS[i], p);
                if (filterItems[i] == null) continue;
                if (!SlimefunUtils.containsSimilarItem((Inventory)playerInventory, (ItemStack)filterItems[i], (boolean)true)) {
                    this.createParticle(child, Color.AQUA);
                    Utils.send((CommandSender)p, "&cYou do not have " + Utils.getViewableName(filterItems[i]) + "&c. Skipping this item.");
                    continue;
                }
                for (ItemStack playerItem : playerInventory) {
                    if (!SlimefunUtils.isItemSimilar((ItemStack)playerItem, (ItemStack)filterItems[i], (boolean)false, (boolean)false)) continue;
                    playerItem.setAmount(playerItem.getAmount() - 1);
                    nodeMenu.replaceExistingItem(CARGO_SLOTS[i], (ItemStack)new CustomItemStack(playerItem, 1));
                    continue block0;
                }
            }
        }
        BlockStorage.getStorage((World)child.getWorld()).reloadInventory(child.getLocation());
        Utils.send((CommandSender)p, "&aYour " + savedNodeType.getDisplayName() + " &ahas been pasted.");
        this.createParticle(child, Color.LIME);
    }

    private void clearNode(Block node, Player p, SlimefunItemStack nodeType) {
        BlockStorage.addBlockInfo((Block)node, (String)"owner", (String)p.getUniqueId().toString());
        BlockStorage.addBlockInfo((Block)node, (String)"frequency", (String)"0");
        if (nodeType != SlimefunItems.CARGO_OUTPUT_NODE) {
            BlockStorage.addBlockInfo((Block)node, (String)"index", (String)"0");
            BlockStorage.addBlockInfo((Block)node, (String)"filter-type", (String)"whitelist");
            BlockStorage.addBlockInfo((Block)node, (String)"filter-lore", (String)String.valueOf(true));
            BlockStorage.addBlockInfo((Block)node, (String)"filter-durability", (String)String.valueOf(false));
            if (nodeType == SlimefunItems.CARGO_INPUT_NODE) {
                BlockStorage.addBlockInfo((Block)node, (String)"round-robin", (String)String.valueOf(false));
                BlockStorage.addBlockInfo((Block)node, (String)"smart-fill", (String)String.valueOf(false));
            }
            this.clearNodeFilter(node, p);
            BlockStorage.getStorage((World)node.getWorld()).reloadInventory(node.getLocation());
            Utils.send((CommandSender)p, "&aThe selected Cargo Node has been cleared");
            this.createParticle(node, Color.fromRGB((int)255, (int)152, (int)56));
        }
    }

    private void clearNodeFilter(Block node, Player p) {
        BlockMenu nodeMenu = BlockStorage.getInventory((Block)node);
        for (int i = 0; i < 9; ++i) {
            this.clearFilterSlot(nodeMenu, CARGO_SLOTS[i], p);
        }
    }

    private void clearFilterSlot(BlockMenu nodeMenu, int slot, Player p) {
        ItemStack filterItem = nodeMenu.getItemInSlot(slot);
        if (filterItem != null) {
            Utils.giveOrDropItem(p, filterItem);
            nodeMenu.replaceExistingItem(slot, null);
        }
    }

    private SlimefunItemStack getCargoNodeType(Block b) {
        if (b == null) {
            return null;
        }
        String blockId = BlockStorage.checkID((Block)b);
        if (blockId == null) {
            return null;
        }
        return (SlimefunItemStack)SlimefunItem.getById((String)blockId).getItem();
    }

    private void createParticle(Block b, Color color) {
        Particle.DustOptions dustOption = new Particle.DustOptions(color, 1.0f);
        b.getLocation().getWorld().spawnParticle(Particle.REDSTONE, b.getLocation().add(0.5, 0.5, 0.5), 1, (Object)dustOption);
    }
}

