/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.fluffymachines.objects;

import io.github.thebusybiscuit.slimefun4.core.attributes.ItemAttribute;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.ncbpfluffybear.fluffymachines.utils.Utils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.util.Vector;

public interface DoubleHologramOwner
extends ItemAttribute {
    default public void updateHologram(@Nonnull Block b, @Nullable String topText, @Nonnull String bottomText) {
        Location locTop = b.getLocation().add(this.getTopHologramOffset(b));
        Location locBot = b.getLocation().add(this.getBottomHologramOffset(b));
        Slimefun.getHologramsService().setHologramLabel(locTop, Utils.color(topText));
        Slimefun.getHologramsService().setHologramLabel(locBot, Utils.color(bottomText));
    }

    default public void removeHologram(@Nonnull Block b) {
        Location locTop = b.getLocation().add(this.getTopHologramOffset(b));
        Location locBot = b.getLocation().add(this.getBottomHologramOffset(b));
        Slimefun.getHologramsService().removeHologram(locTop);
        Slimefun.getHologramsService().removeHologram(locBot);
    }

    @Nonnull
    default public Vector getHologramOffset(@Nonnull Block block) {
        return Slimefun.getHologramsService().getDefaultOffset();
    }

    @Nonnull
    default public double getHologramSpacing() {
        return 0.2;
    }

    @Nonnull
    default public Vector getTopHologramOffset(@Nonnull Block block) {
        return this.getHologramOffset(block).add(new Vector(0.0, this.getHologramSpacing(), 0.0));
    }

    @Nonnull
    default public Vector getBottomHologramOffset(@Nonnull Block block) {
        return this.getHologramOffset(block);
    }
}

