/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.fluffymachines.machines;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.backpacks.SlimefunBackpack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.ncbpfluffybear.fluffymachines.machines.BackpackLoader;
import java.util.List;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class BackpackUnloader
extends SlimefunItem
implements EnergyNetComponent {
    public static final int ENERGY_CONSUMPTION = 16;
    public static final int CAPACITY = 48;
    private static final int[] PLAIN_BORDER = new int[]{2, 3, 4, 5, 6, 7, 8, 11, 12, 13, 14, 15, 16, 17};
    private static final int[] INPUT_BORDER = new int[]{1, 9, 10};
    private static final int[] OUTPUT_BORDER = new int[]{18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 35, 36, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53};
    private static final int[] INPUT_SLOTS = new int[]{0};
    private static final int[] OUTPUT_SLOTS = new int[]{28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};

    public BackpackUnloader(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.addItemHandler(new ItemHandler[]{this.onBreak()});
        new BlockMenuPreset(this.getId(), "&eBackpack Unloader"){

            public void init() {
                BackpackLoader.buildBorder(this, PLAIN_BORDER, INPUT_BORDER, OUTPUT_BORDER);
            }

            public boolean canOpen(@Nonnull Block b, @Nonnull Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), Interaction.INTERACT_BLOCK);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return new int[0];
            }

            public int[] getSlotsAccessedByItemTransport(DirtyChestMenu menu, ItemTransportFlow flow, ItemStack item) {
                if (flow == ItemTransportFlow.WITHDRAW) {
                    return BackpackUnloader.this.getOutputSlots();
                }
                return BackpackUnloader.this.getInputSlots();
            }
        };
    }

    private BlockBreakHandler onBreak() {
        return new BlockBreakHandler(false, false){

            public void onPlayerBreak(@Nonnull BlockBreakEvent e, @Nonnull ItemStack item, @Nonnull List<ItemStack> drops) {
                Block b = e.getBlock();
                BlockMenu inv = BlockStorage.getInventory((Block)b);
                if (inv != null) {
                    inv.dropItems(b.getLocation(), BackpackUnloader.this.getInputSlots());
                    inv.dropItems(b.getLocation(), BackpackUnloader.this.getOutputSlots());
                }
            }
        };
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public void tick(Block b, SlimefunItem sf, Config data) {
                BackpackUnloader.this.tick(b);
            }

            public boolean isSynchronized() {
                return false;
            }
        }});
    }

    private void tick(@Nonnull Block b) {
        if (this.getCharge(b.getLocation()) < 16) {
            return;
        }
        BlockMenu inv = BlockStorage.getInventory((Block)b);
        for (int outputSlot : this.getOutputSlots()) {
            if (inv.getItemInSlot(outputSlot) == null) break;
            if (outputSlot != this.getOutputSlots()[13]) continue;
            return;
        }
        ItemStack inputItem = inv.getItemInSlot(this.getInputSlots()[0]);
        if (inputItem != null) {
            SlimefunItem sfItem = SlimefunItem.getByItem((ItemStack)inputItem);
            if (sfItem instanceof SlimefunBackpack) {
                List lore = inputItem.getItemMeta().getLore();
                for (String s : lore) {
                    if (!s.equals(ChatColor.GRAY + "ID: <ID>")) continue;
                    this.rejectInput(inv);
                    return;
                }
                PlayerProfile.getBackpack((ItemStack)inputItem, backpack -> {
                    Inventory bpinv = backpack.getInventory();
                    for (int slot = 0; slot < bpinv.getSize(); ++slot) {
                        if (bpinv.getItem(slot) != null) {
                            ItemStack transferItem = bpinv.getItem(slot);
                            bpinv.setItem(slot, null);
                            inv.pushItem(transferItem, this.getOutputSlots());
                            this.removeCharge(b.getLocation(), 16);
                            return;
                        }
                        if (slot != bpinv.getSize() - 1) continue;
                        this.rejectInput(inv);
                        return;
                    }
                });
            } else {
                this.rejectInput(inv);
            }
        }
    }

    private void rejectInput(BlockMenu inv) {
        ItemStack transferItem = inv.getItemInSlot(this.getInputSlots()[0]);
        inv.replaceExistingItem(this.getInputSlots()[0], null);
        inv.pushItem(transferItem, this.getOutputSlots());
    }

    @Nonnull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getCapacity() {
        return 48;
    }

    public int[] getInputSlots() {
        return INPUT_SLOTS;
    }

    public int[] getOutputSlots() {
        return OUTPUT_SLOTS;
    }
}

