/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.fluffymachines.objects;

import io.github.thebusybiscuit.slimefun4.api.events.BlockPlacerPlaceEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class AutoCrafter
extends SlimefunItem
implements EnergyNetComponent {
    public static final int ENERGY_CONSUMPTION = 128;
    public static final int CAPACITY = 384;
    private final int[] border = new int[]{0, 1, 3, 4, 5, 7, 8, 13, 14, 15, 16, 17, 50, 51, 52, 53};
    private final int[] inputBorder = new int[]{9, 10, 11, 12, 13, 18, 22, 27, 31, 36, 40, 45, 46, 47, 48, 49};
    private final int[] outputBorder = new int[]{23, 24, 25, 26, 32, 35, 41, 42, 43, 44};
    private final int[] inputSlots = new int[]{19, 20, 21, 28, 29, 30, 37, 38, 39};
    private final int[] outputSlots = new int[]{33, 34};
    private final String machineName;
    private final Material material;
    private final MultiBlockMachine mblock;

    public AutoCrafter(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, String displayName, Material material, String machineName, RecipeType machineRecipes) {
        super(category, item, recipeType, recipe);
        this.machineName = machineName;
        this.material = material;
        this.mblock = (MultiBlockMachine)machineRecipes.getMachine();
        this.constructMenu(displayName);
        this.addItemHandler(new ItemHandler[]{this.onPlace()});
        this.addItemHandler(new ItemHandler[]{this.onBreak()});
    }

    private void constructMenu(String displayName) {
        new BlockMenuPreset(this.getId(), displayName){

            public void init() {
                AutoCrafter.this.constructMenu(this);
            }

            public void newInstance(@Nonnull BlockMenu menu, @Nonnull Block b) {
                if (!BlockStorage.hasBlockInfo((Block)b) || BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"enabled") == null || BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"enabled").equals(String.valueOf(false))) {
                    menu.replaceExistingItem(6, (ItemStack)new CustomItemStack(Material.GUNPOWDER, "&7Enabled: &4\u2718", new String[]{"", "&e> Click to enable this Machine"}));
                    menu.addMenuClickHandler(6, (p, slot, item, action) -> {
                        BlockStorage.addBlockInfo((Block)b, (String)"enabled", (String)String.valueOf(true));
                        this.newInstance(menu, b);
                        return false;
                    });
                } else {
                    menu.replaceExistingItem(6, (ItemStack)new CustomItemStack(Material.REDSTONE, "&7Enabled: &2\u2714", new String[]{"", "&e> Click to disable this Machine"}));
                    menu.addMenuClickHandler(6, (p, slot, item, action) -> {
                        BlockStorage.addBlockInfo((Block)b, (String)"enabled", (String)String.valueOf(false));
                        this.newInstance(menu, b);
                        return false;
                    });
                }
            }

            public boolean canOpen(@Nonnull Block b, @Nonnull Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), Interaction.INTERACT_BLOCK);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return new int[0];
            }

            public int[] getSlotsAccessedByItemTransport(DirtyChestMenu menu, ItemTransportFlow flow, ItemStack item) {
                return AutoCrafter.this.getCustomItemTransport(menu, flow, item);
            }
        };
    }

    protected int[] getCustomItemTransport(DirtyChestMenu menu, ItemTransportFlow flow, ItemStack item) {
        if (flow == ItemTransportFlow.WITHDRAW) {
            return this.getOutputSlots();
        }
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int slot : this.getInputSlots()) {
            if (menu.getItemInSlot(slot) == null) continue;
            slots.add(slot);
        }
        slots.sort(this.compareSlots(menu));
        int[] array = new int[slots.size()];
        for (int i = 0; i < slots.size(); ++i) {
            array[i] = (Integer)slots.get(i);
        }
        return array;
    }

    private BlockPlaceHandler onPlace() {
        return new BlockPlaceHandler(true){

            public void onPlayerPlace(@Nonnull BlockPlaceEvent e) {
                BlockStorage.addBlockInfo((Block)e.getBlock(), (String)"enabled", (String)String.valueOf(false));
            }

            public void onBlockPlacerPlace(@Nonnull BlockPlacerPlaceEvent e) {
                BlockStorage.addBlockInfo((Block)e.getBlock(), (String)"enabled", (String)String.valueOf(false));
            }
        };
    }

    private BlockBreakHandler onBreak() {
        return new BlockBreakHandler(false, false){

            public void onPlayerBreak(@Nonnull BlockBreakEvent e, @Nonnull ItemStack i, @Nonnull List<ItemStack> list) {
                Block b = e.getBlock();
                BlockMenu inv = BlockStorage.getInventory((Block)b);
                if (inv != null) {
                    inv.dropItems(b.getLocation(), AutoCrafter.this.getInputSlots());
                    inv.dropItems(b.getLocation(), AutoCrafter.this.getOutputSlots());
                }
            }
        };
    }

    protected Comparator<Integer> compareSlots(DirtyChestMenu menu) {
        return Comparator.comparingInt(slot -> menu.getItemInSlot(slot.intValue()).getAmount());
    }

    protected void constructMenu(BlockMenuPreset preset) {
        AutoCrafter.borders(preset, this.border, this.inputBorder, this.outputBorder);
        for (int i : this.getOutputSlots()) {
            preset.addMenuClickHandler(i, (ChestMenu.MenuClickHandler)new ChestMenu.AdvancedMenuClickHandler(){

                public boolean onClick(Player p, int slot, ItemStack cursor, ClickAction action) {
                    return false;
                }

                public boolean onClick(InventoryClickEvent e, Player p, int slot, ItemStack cursor, ClickAction action) {
                    if (cursor == null) {
                        return true;
                    }
                    return cursor.getType() == Material.AIR;
                }
            });
        }
        preset.addItem(2, (ItemStack)new CustomItemStack(new ItemStack(this.material), "&eRecipe", new String[]{"", "&bPut in the Recipe you want to craft", this.machineName + " Recipes ONLY"}), (p, slot, item, action) -> false);
    }

    public int getEnergyConsumption() {
        return 128;
    }

    public int getCapacity() {
        return 384;
    }

    public int[] getInputSlots() {
        return this.inputSlots;
    }

    public int[] getOutputSlots() {
        return this.outputSlots;
    }

    @Nonnull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public void tick(Block b, SlimefunItem sf, Config data) {
                AutoCrafter.this.tick(b);
            }

            public boolean isSynchronized() {
                return false;
            }
        }});
    }

    protected void tick(Block block) {
        if (BlockStorage.getLocationInfo((Location)block.getLocation(), (String)"enabled").equals(String.valueOf(false))) {
            return;
        }
        if (this.getCharge(block.getLocation()) < this.getEnergyConsumption()) {
            return;
        }
        this.craftIfValid(block);
    }

    private void craftIfValid(Block block) {
        int outSlot;
        ItemStack outItem;
        BlockMenu menu = BlockStorage.getInventory((Block)block);
        Object object = this.getOutputSlots();
        int n = ((int[])object).length;
        for (int i = 0; i < n && (outItem = menu.getItemInSlot(outSlot = object[i])) != null && outItem.getAmount() >= outItem.getMaxStackSize(); ++i) {
            if (outSlot != this.getOutputSlots()[1]) continue;
            return;
        }
        object = RecipeType.getRecipeInputList((MultiBlockMachine)this.mblock).iterator();
        while (object.hasNext()) {
            ItemStack[] input = (ItemStack[])object.next();
            if (!this.isCraftable(menu, input)) continue;
            ItemStack output = RecipeType.getRecipeOutputList((MultiBlockMachine)this.mblock, (ItemStack[])input).clone();
            if (!menu.fits(output, this.getOutputSlots())) {
                return;
            }
            this.craft(output, menu);
            this.removeCharge(block.getLocation(), this.getEnergyConsumption());
            return;
        }
    }

    private boolean isCraftable(BlockMenu inv, ItemStack[] recipe) {
        for (int j = 0; j < 9; ++j) {
            ItemStack item = inv.getItemInSlot(this.getInputSlots()[j]);
            if ((item == null || item.getAmount() != 1 || item.getType().getMaxStackSize() == 1) && SlimefunUtils.isItemSimilar((ItemStack)inv.getItemInSlot(this.getInputSlots()[j]), (ItemStack)recipe[j], (boolean)true)) continue;
            return false;
        }
        return true;
    }

    private void craft(ItemStack output, BlockMenu inv) {
        for (int j = 0; j < 9; ++j) {
            ItemStack item = inv.getItemInSlot(this.getInputSlots()[j]);
            if (item == null || item.getType() == Material.AIR) continue;
            inv.consumeItem(this.getInputSlots()[j]);
        }
        inv.pushItem(output, this.outputSlots);
    }

    static void borders(BlockMenuPreset preset, int[] border, int[] inputBorder, int[] outputBorder) {
        for (int i : border) {
            preset.addItem(i, (ItemStack)new CustomItemStack(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " ", new String[0]), (p, slot, item, action) -> false);
        }
        for (int i : inputBorder) {
            preset.addItem(i, (ItemStack)new CustomItemStack(new ItemStack(Material.CYAN_STAINED_GLASS_PANE), " ", new String[0]), (p, slot, item, action) -> false);
        }
        for (int i : outputBorder) {
            preset.addItem(i, (ItemStack)new CustomItemStack(new ItemStack(Material.ORANGE_STAINED_GLASS_PANE), " ", new String[0]), (p, slot, item, action) -> false);
        }
    }
}

