/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.fluffymachines.machines;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.Rechargeable;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;

public class AdvancedChargingBench
extends AContainer {
    public static final int CAPACITY = 128;
    public static final int ENERGY_CONSUMPTION = 10;
    public static final int CHARGE = 5;
    private int tier = 0;

    public AdvancedChargingBench(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.addItemHandler(new ItemHandler[]{this.onPlace()});
    }

    private BlockPlaceHandler onPlace() {
        return new BlockPlaceHandler(true){

            public void onPlayerPlace(@Nonnull BlockPlaceEvent e) {
                Block b = e.getBlockPlaced();
                BlockStorage.addBlockInfo((Location)b.getLocation(), (String)"tier", (String)"0");
            }
        };
    }

    protected void tick(Block b) {
        if (this.getCharge(b.getLocation()) < this.getEnergyConsumption()) {
            return;
        }
        BlockMenu inv = BlockStorage.getInventory((Block)b);
        this.tier = Integer.parseInt(BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"tier"));
        for (int slot : this.getInputSlots()) {
            ItemStack item = inv.getItemInSlot(slot);
            if (!this.charge(b, inv, slot, item, this.tier)) continue;
            return;
        }
    }

    private boolean charge(Block b, BlockMenu inv, int slot, ItemStack item, int tier) {
        SlimefunItem sfItem = SlimefunItem.getByItem((ItemStack)item);
        if (sfItem instanceof Rechargeable) {
            float charge = 5 + 5 * tier;
            if (((Rechargeable)sfItem).addItemCharge(item, charge)) {
                this.removeCharge(b.getLocation(), this.getEnergyConsumption());
            } else if (inv.fits(item, this.getOutputSlots())) {
                inv.pushItem(item, this.getOutputSlots());
                inv.replaceExistingItem(slot, null);
            }
            return true;
        }
        if (sfItem != null && inv.fits(item, this.getOutputSlots())) {
            inv.pushItem(item, this.getOutputSlots());
            inv.replaceExistingItem(slot, null);
        }
        return false;
    }

    public ItemStack getProgressBar() {
        return null;
    }

    public int getCapacity() {
        return 128 + 128 * this.tier;
    }

    public int getEnergyConsumption() {
        return 10 + 10 * this.tier;
    }

    public int getSpeed() {
        return 1;
    }

    @Nonnull
    public String getMachineIdentifier() {
        return "ADVANCED_CHARGING_BENCH";
    }
}

