/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.fluffymachines.listeners;

import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.ncbpfluffybear.fluffymachines.machines.AutoCraftingTable;
import io.ncbpfluffybear.fluffymachines.machines.SmartFactory;
import io.ncbpfluffybear.fluffymachines.utils.Utils;
import java.util.Optional;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class KeyedCrafterListener
implements Listener {
    @EventHandler
    private void onSmartFactoryInteract(PlayerRightClickEvent e) {
        Optional clickedBlock = e.getClickedBlock();
        if (e.getHand() == EquipmentSlot.HAND && e.useBlock() != Event.Result.DENY && clickedBlock.isPresent() && e.getPlayer().isSneaking()) {
            Optional slimefunBlock = e.getSlimefunBlock();
            if (!slimefunBlock.isPresent()) {
                return;
            }
            SlimefunItem sfBlock = (SlimefunItem)slimefunBlock.get();
            ItemStack item = e.getItem();
            Player p = e.getPlayer();
            SlimefunItem key = SlimefunItem.getByItem((ItemStack)item);
            Block b = (Block)clickedBlock.get();
            if (sfBlock instanceof SmartFactory) {
                if (this.isCargoNode(key)) {
                    return;
                }
                e.cancel();
                if (key == null) {
                    Utils.send((CommandSender)p, "&cYou can not use vanilla items with this machine!");
                    return;
                }
                if (SmartFactory.getAcceptedItems().contains((SlimefunItemStack)key.getItem())) {
                    BlockStorage.addBlockInfo((Block)b, (String)"recipe", (String)key.getId());
                    BlockStorage.getInventory((Block)b).replaceExistingItem(43, SmartFactory.getDisplayItem(key, ((RecipeDisplayItem)sfBlock).getDisplayRecipes()));
                    Utils.send((CommandSender)p, "&aTarget recipe set to " + key.getItemName());
                } else {
                    Utils.send((CommandSender)p, "&cThis item is not supported!");
                }
            } else if (sfBlock instanceof AutoCraftingTable) {
                if (this.isCargoNode(key)) {
                    return;
                }
                e.cancel();
                if (item.getType() == Material.AIR) {
                    Utils.send((CommandSender)p, "&cRight click the machine with an item to set the vanilla recipe");
                    return;
                }
                BlockStorage.getInventory((Block)b).replaceExistingItem(16, AutoCraftingTable.createKeyItem(item.getType()));
                Utils.send((CommandSender)p, "&aTarget recipe set to " + WordUtils.capitalizeFully((String)item.getType().name().replace("_", " ")));
            }
        }
    }

    private boolean isCargoNode(@Nullable SlimefunItem recipe) {
        return recipe != null && (recipe.getItem() == SlimefunItems.CARGO_INPUT_NODE || recipe.getItem() == SlimefunItems.CARGO_OUTPUT_NODE || recipe.getItem() == SlimefunItems.CARGO_OUTPUT_NODE_2);
    }
}

