/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.extrautils.interfaces;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public interface InventoryBlock {
    public int[] getInputSlots();

    public int[] getOutputSlots();

    default public void createPreset(SlimefunItem item, Consumer<BlockMenuPreset> setup) {
        this.createPreset(item, item.getItemName(), setup);
    }

    default public void createPreset(final SlimefunItem item, String title, final Consumer<BlockMenuPreset> setup) {
        new BlockMenuPreset(item.getId(), title){

            public void init() {
                setup.accept(this);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                if (flow == ItemTransportFlow.INSERT) {
                    return InventoryBlock.this.getInputSlots();
                }
                return InventoryBlock.this.getOutputSlots();
            }

            public boolean canOpen(@Nonnull Block block, @Nonnull Player player) {
                return player.hasPermission("slimefun.inventory.bypass") || Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, block.getLocation(), Interaction.INTERACT_BLOCK) && SlimefunUtils.canPlayerUseItem((Player)player, (ItemStack)item.getItem(), (boolean)false);
            }
        };
    }
}

