/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.fluffymachines.items.tools;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.NotPlaceable;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.ToolUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.ncbpfluffybear.fluffymachines.items.tools.AlternateBreakEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Axis;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Orientable;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class UpgradedLumberAxe
extends SimpleSlimefunItem<ItemUseHandler>
implements NotPlaceable {
    private static final int MAX_BROKEN = 200;
    private static final int MAX_STRIPPED = 200;
    private static final int RANGE = 2;
    private final ItemSetting<Boolean> triggerOtherPlugins = new ItemSetting((SlimefunItem)this, "trigger-other-plugins", (Object)true);

    public UpgradedLumberAxe(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    public void preRegister() {
        super.preRegister();
        this.addItemHandler(new ItemHandler[]{this.onBlockBreak()});
        this.addItemSetting(new ItemSetting[]{this.triggerOtherPlugins});
    }

    private ToolUseHandler onBlockBreak() {
        return (e, tool, fortune, drops) -> {
            if (Tag.LOGS.getValues().contains(e.getBlock().getType())) {
                if (BlockStorage.checkID((Block)e.getBlock()) != null) {
                    return;
                }
                if (e instanceof AlternateBreakEvent) {
                    return;
                }
                List<Block> logs = UpgradedLumberAxe.find(e.getBlock(), 200, b -> Tag.LOGS.isTagged((Keyed)b.getType()));
                logs.remove(e.getBlock());
                for (Block b2 : logs) {
                    if (!Slimefun.getProtectionManager().hasPermission((OfflinePlayer)e.getPlayer(), b2, Interaction.BREAK_BLOCK) || BlockStorage.checkID((Block)b2) != null) continue;
                    if (((Boolean)this.triggerOtherPlugins.getValue()).booleanValue()) {
                        Bukkit.getPluginManager().callEvent((Event)new AlternateBreakEvent(b2, e.getPlayer()));
                    }
                    b2.breakNaturally(tool);
                }
            }
        };
    }

    @Nonnull
    public ItemUseHandler getItemHandler() {
        return e -> {
            Block block;
            if (e.getClickedBlock().isPresent() && this.isUnstrippedLog(block = (Block)e.getClickedBlock().get())) {
                List<Block> logs = UpgradedLumberAxe.find(block, 200, this::isUnstrippedLog);
                logs.remove(block);
                for (Block b : logs) {
                    if (!Slimefun.getProtectionManager().hasPermission((OfflinePlayer)e.getPlayer(), b, Interaction.BREAK_BLOCK) || BlockStorage.checkID((Block)b) != null) continue;
                    this.stripLog(b);
                }
            }
        };
    }

    private boolean isUnstrippedLog(Block block) {
        return Tag.LOGS.isTagged((Keyed)block.getType()) && !block.getType().name().startsWith("STRIPPED_");
    }

    private void stripLog(Block b) {
        b.getWorld().playSound(b.getLocation(), Sound.ITEM_AXE_STRIP, 1.0f, 1.0f);
        Axis axis = ((Orientable)b.getBlockData()).getAxis();
        b.setType(Material.valueOf((String)("STRIPPED_" + b.getType().name())));
        Orientable orientable = (Orientable)b.getBlockData();
        orientable.setAxis(axis);
        b.setBlockData((BlockData)orientable);
    }

    public static List<Block> find(Block b, int limit, Predicate<Block> predicate) {
        LinkedList<Block> list = new LinkedList<Block>();
        UpgradedLumberAxe.expand(b, list, limit, predicate);
        return list;
    }

    private static void expand(Block anchor, List<Block> list, int limit, Predicate<Block> predicate) {
        if (list.size() < limit) {
            list.add(anchor);
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    for (int y = -2; y <= 2; ++y) {
                        Block next = anchor.getRelative(x, y, z);
                        if (list.contains(next) || !predicate.test(next)) continue;
                        UpgradedLumberAxe.expand(next, list, limit, predicate);
                    }
                }
            }
        }
    }
}

