/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.fluffymachines.machines;

import io.github.thebusybiscuit.slimefun4.api.events.BlockPlacerPlaceEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.Pair;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.ncbpfluffybear.fluffymachines.FluffyMachines;
import io.ncbpfluffybear.fluffymachines.machines.AutoAncientAltar;
import io.ncbpfluffybear.fluffymachines.utils.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.meta.ItemMeta;

public class AutoCraftingTable
extends SlimefunItem
implements EnergyNetComponent {
    public static final int ENERGY_CONSUMPTION = 128;
    public static final int CAPACITY = 384;
    public static final int KEY_SLOT = 16;
    private static final int statusSlot = 23;
    private final int[] border = new int[]{0, 1, 3, 5, 13, 14, 50, 51, 52, 53};
    private final int[] inputBorder = new int[]{9, 10, 11, 12, 13, 18, 22, 27, 31, 36, 40, 45, 46, 47, 48, 49};
    private final int[] outputBorder = new int[]{32, 33, 34, 35, 41, 44, 50, 51, 52, 53};
    private final int[] keyBorder = new int[]{6, 7, 8, 15, 17, 24, 25, 26};

    public AutoCraftingTable(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        new BlockMenuPreset(this.getId(), "&6Auto Crafting Table"){

            public void init() {
                AutoCraftingTable.this.constructMenu(this);
            }

            public void newInstance(@Nonnull BlockMenu menu, @Nonnull Block b) {
                if (!BlockStorage.hasBlockInfo((Block)b) || BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"enabled") == null || BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"enabled").equals(String.valueOf(false))) {
                    menu.replaceExistingItem(4, (ItemStack)new CustomItemStack(Material.GUNPOWDER, "&7Enabled: &4\u2718", new String[]{"", "&e> Click to enable this Machine"}));
                    menu.replaceExistingItem(23, (ItemStack)new CustomItemStack(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), "&7&lDisabled", new String[0]));
                    menu.addMenuClickHandler(4, (p, slot, item, action) -> {
                        BlockStorage.addBlockInfo((Block)b, (String)"enabled", (String)String.valueOf(true));
                        this.newInstance(menu, b);
                        return false;
                    });
                } else {
                    menu.replaceExistingItem(4, (ItemStack)new CustomItemStack(Material.REDSTONE, "&7Enabled: &2\u2714", new String[]{"", "&e> Click to disable this Machine"}));
                    menu.addMenuClickHandler(4, (p, slot, item, action) -> {
                        BlockStorage.addBlockInfo((Block)b, (String)"enabled", (String)String.valueOf(false));
                        this.newInstance(menu, b);
                        return false;
                    });
                }
                ItemStack keyItem = menu.getItemInSlot(16);
                if (keyItem == null) {
                    menu.replaceExistingItem(16, (ItemStack)new CustomItemStack(Material.BARRIER, "&cNo Recipe", new String[]{"&cSneak and Right Click the", "&cAuto Crafting Table with an item", "&cto change the target recipe"}));
                } else {
                    ItemMeta keyMeta = keyItem.getItemMeta();
                    List lore = keyMeta.getLore();
                    if (lore == null || !ChatColor.stripColor((String)((String)lore.get(0))).equals("Sneak and Right Click the")) {
                        menu.replaceExistingItem(16, AutoCraftingTable.createKeyItem(keyItem.getType()));
                        if (menu.fits(keyItem, AutoCraftingTable.this.getOutputSlots())) {
                            menu.pushItem(keyItem, AutoCraftingTable.this.getOutputSlots());
                        } else {
                            b.getLocation().getWorld().dropItemNaturally(b.getLocation().add(0.0, 1.0, 0.0), keyItem);
                        }
                    }
                }
                menu.addMenuClickHandler(16, ChestMenuUtils.getEmptyClickHandler());
            }

            public boolean canOpen(@Nonnull Block b, @Nonnull Player p) {
                return Utils.canOpen(b, p);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return new int[0];
            }

            public int[] getSlotsAccessedByItemTransport(DirtyChestMenu menu, ItemTransportFlow flow, ItemStack item) {
                if (flow == ItemTransportFlow.WITHDRAW) {
                    return AutoCraftingTable.this.getOutputSlots();
                }
                ArrayList<Integer> slots = new ArrayList<Integer>();
                for (int slot : AutoCraftingTable.this.getInputSlots()) {
                    if (menu.getItemInSlot(slot) == null) continue;
                    slots.add(slot);
                }
                slots.sort(AutoCraftingTable.this.compareSlots(menu));
                int[] array = new int[slots.size()];
                for (int i = 0; i < slots.size(); ++i) {
                    array[i] = (Integer)slots.get(i);
                }
                return array;
            }
        };
        this.addItemHandler(new ItemHandler[]{this.onPlace()});
        this.addItemHandler(new ItemHandler[]{this.onBreak()});
    }

    private BlockBreakHandler onBreak() {
        return new BlockBreakHandler(false, false){

            public void onPlayerBreak(@Nonnull BlockBreakEvent e, @Nonnull ItemStack item, @Nonnull List<ItemStack> drops) {
                Block b = e.getBlock();
                BlockMenu inv = BlockStorage.getInventory((Block)b);
                Location location = b.getLocation();
                if (inv != null) {
                    inv.dropItems(location, AutoCraftingTable.this.getInputSlots());
                    inv.dropItems(location, AutoCraftingTable.this.getOutputSlots());
                }
            }
        };
    }

    private BlockPlaceHandler onPlace() {
        return new BlockPlaceHandler(true){

            public void onPlayerPlace(@Nonnull BlockPlaceEvent e) {
                BlockStorage.addBlockInfo((Block)e.getBlock(), (String)"enabled", (String)String.valueOf(false));
            }

            public void onBlockPlacerPlace(@Nonnull BlockPlacerPlaceEvent e) {
                BlockStorage.addBlockInfo((Block)e.getBlock(), (String)"enabled", (String)String.valueOf(false));
            }
        };
    }

    private Comparator<Integer> compareSlots(DirtyChestMenu menu) {
        return Comparator.comparingInt(slot -> menu.getItemInSlot(slot.intValue()).getAmount());
    }

    protected void constructMenu(BlockMenuPreset preset) {
        AutoAncientAltar.borders(preset, this.border, this.inputBorder, this.outputBorder);
        for (int i : this.keyBorder) {
            preset.addItem(i, (ItemStack)new CustomItemStack(new ItemStack(Material.YELLOW_STAINED_GLASS_PANE), " ", new String[0]), (p, slot, item, action) -> false);
        }
        preset.addItem(23, (ItemStack)new CustomItemStack(new ItemStack(Material.YELLOW_STAINED_GLASS_PANE), "&e&lIdle", new String[0]), (p, slot, item, action) -> false);
        for (int i : this.getOutputSlots()) {
            preset.addMenuClickHandler(i, (ChestMenu.MenuClickHandler)new ChestMenu.AdvancedMenuClickHandler(){

                public boolean onClick(Player p, int slot, ItemStack cursor, ClickAction action) {
                    return false;
                }

                public boolean onClick(InventoryClickEvent e, Player p, int slot, ItemStack cursor, ClickAction action) {
                    if (cursor == null) {
                        return true;
                    }
                    return cursor.getType() == Material.AIR;
                }
            });
        }
        preset.addItem(2, (ItemStack)new CustomItemStack(new ItemStack(Material.CRAFTING_TABLE), "&eRecipe", new String[]{"", "&bPut in the Recipe you want to craft", "&4Vanilla Crafting Table Recipes ONLY"}), (p, slot, item, action) -> false);
    }

    public int[] getInputSlots() {
        return new int[]{19, 20, 21, 28, 29, 30, 37, 38, 39};
    }

    public int[] getOutputSlots() {
        return new int[]{42, 43};
    }

    @Nonnull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getCapacity() {
        return 384;
    }

    public int getEnergyConsumption() {
        return 128;
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public void tick(Block b, SlimefunItem sf, Config data) {
                AutoCraftingTable.this.tick(b);
            }

            public boolean isSynchronized() {
                return false;
            }
        }});
    }

    protected void tick(Block block) {
        if (BlockStorage.getLocationInfo((Location)block.getLocation(), (String)"enabled").equals("false")) {
            return;
        }
        if (this.getCharge(block.getLocation()) < this.getEnergyConsumption()) {
            BlockMenu menu = BlockStorage.getInventory((Block)block);
            if (menu.hasViewer()) {
                menu.replaceExistingItem(23, (ItemStack)new CustomItemStack(new ItemStack(Material.RED_STAINED_GLASS_PANE), "&c&lNo Power", new String[0]));
            }
            return;
        }
        this.getResult(block);
    }

    private void getResult(Block block) {
        int outSlot;
        ItemStack outItem;
        BlockMenu menu = BlockStorage.getInventory((Block)block);
        ItemStack invItem = menu.getItemInSlot(16);
        if (invItem == null || invItem.getType() == Material.BARRIER) {
            if (menu.hasViewer()) {
                menu.replaceExistingItem(23, (ItemStack)new CustomItemStack(new ItemStack(Material.RED_STAINED_GLASS_PANE), "&c&lKey Item Missing", new String[0]));
            }
            return;
        }
        ItemStack keyItem = new ItemStack(invItem.getType());
        int[] nArray = this.getOutputSlots();
        int n = nArray.length;
        for (int i = 0; i < n && (outItem = menu.getItemInSlot(outSlot = nArray[i])) != null && outItem.getAmount() >= outItem.getMaxStackSize(); ++i) {
            if (outSlot != this.getOutputSlots()[1]) continue;
            if (menu.hasViewer()) {
                menu.replaceExistingItem(23, (ItemStack)new CustomItemStack(new ItemStack(Material.RED_STAINED_GLASS_PANE), "&c&lOutput Full", new String[0]));
            }
            return;
        }
        ArrayList<ItemStack> existingItems = new ArrayList<ItemStack>();
        int blankCounter = 0;
        for (int i = 0; i < 9; ++i) {
            ItemStack slotItem = menu.getItemInSlot(this.getInputSlots()[i]);
            if (slotItem == null) {
                if (++blankCounter != 9) continue;
                if (menu.hasViewer()) {
                    menu.replaceExistingItem(23, (ItemStack)new CustomItemStack(new ItemStack(Material.RED_STAINED_GLASS_PANE), "&c&lInput Missing", new String[0]));
                }
                return;
            }
            ItemStack existingItem = new ItemStack(slotItem.getType());
            if (slotItem.getAmount() == 1) {
                if (menu.hasViewer()) {
                    menu.replaceExistingItem(23, (ItemStack)new CustomItemStack(new ItemStack(Material.RED_STAINED_GLASS_PANE), "&c&lYou need to have enough supplies", new String[]{"&c&lto craft more than one item"}));
                }
                return;
            }
            existingItems.add(existingItem);
        }
        if (FluffyMachines.shapedVanillaRecipes.containsKey(keyItem)) {
            for (Pair<ItemStack, List<RecipeChoice>> recipe : FluffyMachines.shapedVanillaRecipes.get(keyItem)) {
                boolean passOn = false;
                List rc = (List)recipe.getSecondValue();
                if (existingItems.size() != rc.size()) {
                    if (menu.hasViewer()) {
                        menu.replaceExistingItem(23, (ItemStack)new CustomItemStack(new ItemStack(Material.RED_STAINED_GLASS_PANE), "&c&lIncorrect Recipe", new String[0]));
                    }
                    passOn = true;
                }
                if (!passOn) {
                    for (int i = 0; i < rc.size(); ++i) {
                        if (((RecipeChoice)rc.get(i)).test((ItemStack)existingItems.get(i))) continue;
                        if (menu.hasViewer()) {
                            menu.replaceExistingItem(23, (ItemStack)new CustomItemStack(new ItemStack(Material.RED_STAINED_GLASS_PANE), "&c&lIncorrect Recipe", new String[0]));
                        }
                        passOn = true;
                        break;
                    }
                }
                if (passOn) continue;
                this.craft(menu, ((ItemStack)recipe.getFirstValue()).clone());
                return;
            }
        }
        if (FluffyMachines.shapelessVanillaRecipes.containsKey(keyItem)) {
            for (Pair<ItemStack, List<RecipeChoice>> recipe : FluffyMachines.shapelessVanillaRecipes.get(keyItem)) {
                List rc = (List)recipe.getSecondValue();
                ArrayList rcCheck = new ArrayList(rc);
                if (existingItems.size() != rc.size() && menu.hasViewer()) {
                    menu.replaceExistingItem(23, (ItemStack)new CustomItemStack(new ItemStack(Material.RED_STAINED_GLASS_PANE), "&c&lIncorrect Recipe", new String[0]));
                }
                block5: for (RecipeChoice r : rc) {
                    for (ItemStack item : existingItems) {
                        if (!r.test(item)) continue;
                        existingItems.remove(item);
                        rcCheck.remove(r);
                        continue block5;
                    }
                }
                if (existingItems.isEmpty() && rcCheck.isEmpty()) {
                    if (menu.hasViewer()) {
                        menu.replaceExistingItem(23, (ItemStack)new CustomItemStack(new ItemStack(Material.GREEN_STAINED_GLASS_PANE), "&a&lCrafting", new String[0]));
                    }
                    this.craft(menu, ((ItemStack)recipe.getFirstValue()).clone());
                    return;
                }
                if (!menu.hasViewer()) continue;
                menu.replaceExistingItem(23, (ItemStack)new CustomItemStack(new ItemStack(Material.RED_STAINED_GLASS_PANE), "&c&lIncorrect Recipe", new String[0]));
            }
            if (menu.hasViewer()) {
                menu.replaceExistingItem(23, (ItemStack)new CustomItemStack(new ItemStack(Material.RED_STAINED_GLASS_PANE), "&c&lInvalid Key!", new String[0]));
            }
        }
    }

    private void craft(BlockMenu menu, ItemStack item) {
        if (!menu.fits(item, this.getOutputSlots())) {
            if (menu.hasViewer()) {
                menu.replaceExistingItem(23, (ItemStack)new CustomItemStack(new ItemStack(Material.RED_STAINED_GLASS_PANE), "&c&lOutput slots full", new String[0]));
            }
            return;
        }
        if (menu.hasViewer()) {
            menu.replaceExistingItem(23, (ItemStack)new CustomItemStack(new ItemStack(Material.GREEN_STAINED_GLASS_PANE), "&a&lCrafting", new String[0]));
        }
        for (int slot : this.getInputSlots()) {
            if (menu.getItemInSlot(slot) == null) continue;
            menu.consumeItem(slot, 1);
        }
        menu.pushItem(item, this.getOutputSlots());
    }

    public static ItemStack createKeyItem(Material material) {
        return new CustomItemStack(material, "", new String[]{"&eSneak and Right Click the", "&eAuto Crafting Table with an item", "&eto change the target recipe"});
    }
}

