/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.fluffymachines.items.tools;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.items.settings.DoubleRangeSetting;
import io.github.thebusybiscuit.slimefun4.api.items.settings.IntRangeSetting;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.ncbpfluffybear.fluffymachines.FluffyMachines;
import io.ncbpfluffybear.fluffymachines.utils.CancelPlace;
import io.ncbpfluffybear.fluffymachines.utils.Constants;
import io.ncbpfluffybear.fluffymachines.utils.Utils;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.TreeType;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.RayTraceResult;

public class WateringCan
extends SimpleSlimefunItem<ItemUseHandler>
implements CancelPlace {
    public final ItemSetting<Integer> maxUses = new IntRangeSetting((SlimefunItem)this, "max-uses", 0, 10, Integer.MAX_VALUE);
    public final ItemSetting<Double> sugarCaneSuccessChance = new DoubleRangeSetting((SlimefunItem)this, "sugar-cane-success-chance", 0.0, 0.3, 1.0);
    public final ItemSetting<Double> cropSuccessChance = new DoubleRangeSetting((SlimefunItem)this, "crop-success-chance", 0.0, 0.3, 1.0);
    public final ItemSetting<Double> treeSuccessChance = new DoubleRangeSetting((SlimefunItem)this, "tree-success-chance", 0.0, 0.3, 1.0);
    public final ItemSetting<Double> exoticGardenSuccessChance = new DoubleRangeSetting((SlimefunItem)this, "exotic-garden-success-chance", 0.0, 0.3, 1.0);
    private static final int USE_INDEX = 7;
    private static final int MAX_SUGAR_GROW_HEIGHT = 5;
    private static final NamespacedKey usageKey = new NamespacedKey((Plugin)FluffyMachines.getInstance(), "watering_can_usage");

    public WateringCan(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.addItemSetting(new ItemSetting[]{this.maxUses});
        this.addItemSetting(new ItemSetting[]{this.sugarCaneSuccessChance});
        this.addItemSetting(new ItemSetting[]{this.cropSuccessChance});
        this.addItemSetting(new ItemSetting[]{this.treeSuccessChance});
        this.addItemSetting(new ItemSetting[]{this.exoticGardenSuccessChance});
    }

    @Nonnull
    public ItemUseHandler getItemHandler() {
        return e -> {
            Player p = e.getPlayer();
            if (!this.isItem(p.getInventory().getItemInMainHand())) {
                return;
            }
            e.cancel();
            RayTraceResult rayResult = p.rayTraceBlocks(5.0, FluidCollisionMode.SOURCE_ONLY);
            if (rayResult != null) {
                Block b = rayResult.getHitBlock();
                Location blockLocation = b.getLocation();
                if (Slimefun.getProtectionManager().hasPermission((OfflinePlayer)e.getPlayer(), blockLocation, Interaction.BREAK_BLOCK)) {
                    ItemStack item = e.getItem();
                    BlockData blockData = b.getBlockData();
                    if (b.getType() == Material.WATER) {
                        WateringCan.updateUses(this, p, item, 2);
                    } else if (b.getType() == Material.SUGAR_CANE) {
                        int distance = 2;
                        Block above = b.getRelative(BlockFace.UP);
                        while (above.getType() == Material.SUGAR_CANE) {
                            if (distance >= 5) {
                                return;
                            }
                            above = b.getRelative(BlockFace.UP, distance);
                            ++distance;
                        }
                        if (above.getType() == Material.AIR) {
                            if (!WateringCan.updateUses(this, p, item, 1)) {
                                return;
                            }
                            blockLocation.getWorld().spawnParticle(Particle.WATER_SPLASH, blockLocation, 0);
                            double random = ThreadLocalRandom.current().nextDouble();
                            if (random < (Double)this.sugarCaneSuccessChance.getValue()) {
                                above.setType(Material.SUGAR_CANE);
                                blockLocation.getWorld().playEffect(blockLocation, Effect.VILLAGER_PLANT_GROW, 0);
                            }
                        }
                    } else if (blockData instanceof Ageable) {
                        int maxAge;
                        Ageable crop = (Ageable)blockData;
                        int currentAge = crop.getAge();
                        if (currentAge < (maxAge = crop.getMaximumAge())) {
                            if (WateringCan.updateUses(this, p, item, 1)) {
                                blockLocation.getWorld().spawnParticle(Particle.WATER_SPLASH, blockLocation, 0);
                                double random = ThreadLocalRandom.current().nextDouble();
                                if (random < (Double)this.cropSuccessChance.getValue()) {
                                    crop.setAge(currentAge + 1);
                                    blockLocation.getWorld().playEffect(blockLocation, Effect.VILLAGER_PLANT_GROW, 0);
                                }
                            }
                        } else {
                            return;
                        }
                        b.setBlockData(blockData);
                    } else if (Tag.SAPLINGS.isTagged((Keyed)b.getType())) {
                        if (!WateringCan.updateUses(this, p, item, 1)) {
                            return;
                        }
                        blockLocation.getWorld().spawnParticle(Particle.WATER_SPLASH, blockLocation, 0);
                        double random = ThreadLocalRandom.current().nextDouble();
                        Material saplingMaterial = b.getType();
                        if (BlockStorage.hasBlockInfo((Block)b)) {
                            if ((Double)this.exoticGardenSuccessChance.getValue() == 0.0) {
                                Utils.send((CommandSender)p, "&cYou can not water Exotic Garden plants!");
                                return;
                            }
                            if (random < (Double)this.exoticGardenSuccessChance.getValue()) {
                                Bukkit.getPluginManager().callEvent((Event)new StructureGrowEvent(b.getLocation(), WateringCan.getTreeFromSapling(saplingMaterial), false, p, Collections.singletonList(b.getState())));
                                blockLocation.getWorld().playEffect(blockLocation, Effect.VILLAGER_PLANT_GROW, 0);
                            }
                        } else if (Constants.SERVER_VERSION < 1163) {
                            if (random < (Double)this.treeSuccessChance.getValue()) {
                                b.setType(Material.AIR);
                                if (!blockLocation.getWorld().generateTree(blockLocation, WateringCan.getTreeFromSapling(saplingMaterial))) {
                                    b.setType(saplingMaterial);
                                }
                                blockLocation.getWorld().playEffect(blockLocation, Effect.VILLAGER_PLANT_GROW, 0);
                            }
                        } else {
                            b.applyBoneMeal(p.getFacing());
                        }
                    }
                }
            }
        };
    }

    public static boolean updateUses(WateringCan can, Player p, ItemStack item, int updateType) {
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        int usesLeft = (Integer)meta.getPersistentDataContainer().getOrDefault(usageKey, PersistentDataType.INTEGER, (Object)0);
        if (updateType == 1) {
            if (usesLeft == 0) {
                Utils.send((CommandSender)p, "&cYou need to refill your Watering Can!");
                return false;
            }
            p.playSound(p.getLocation(), Sound.ENTITY_DROWNED_AMBIENT_WATER, 0.5f, 1.0f);
            --usesLeft;
        } else if (updateType == 2) {
            p.playSound(p.getLocation(), Sound.ENTITY_DROWNED_DEATH_WATER, 0.5f, 1.0f);
            Utils.send((CommandSender)p, "&aYou have filled your Watering Can");
            usesLeft = (Integer)can.getUses().getValue();
        } else if (updateType == 3) {
            if (usesLeft == 0) {
                Utils.send((CommandSender)p, "&cYou need to refill your Watering Can!");
                return false;
            }
            usesLeft = 0;
            p.playSound(p.getLocation(), Sound.ITEM_BUCKET_EMPTY, 0.5f, 1.0f);
        } else {
            p.sendMessage("Error");
        }
        lore.set(7, ChatColors.color((String)("&aUses Left: &e" + usesLeft)));
        meta.setLore(lore);
        meta.getPersistentDataContainer().set(usageKey, PersistentDataType.INTEGER, (Object)usesLeft);
        item.setItemMeta(meta);
        return true;
    }

    private static TreeType getTreeFromSapling(Material m) {
        TreeType treeType = TreeType.TREE;
        String parseSapling = m.toString().replace("_SAPLING", "");
        if (!parseSapling.equals("OAK")) {
            if (parseSapling.equals("JUNGLE")) {
                parseSapling = "SMALL_JUNGLE";
            }
            return TreeType.valueOf((String)parseSapling);
        }
        return treeType;
    }

    public ItemSetting<Integer> getUses() {
        return this.maxUses;
    }
}

