/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.fluffymachines.items.tools;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.HologramOwner;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.ncbpfluffybear.fluffymachines.FluffyMachines;
import io.ncbpfluffybear.fluffymachines.utils.FluffyItems;
import io.ncbpfluffybear.fluffymachines.utils.Utils;
import java.util.List;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class WarpPadConfigurator
extends SlimefunItem
implements HologramOwner,
Listener {
    private final NamespacedKey xCoord = new NamespacedKey((Plugin)FluffyMachines.getInstance(), "xCoordinate");
    private final NamespacedKey yCoord = new NamespacedKey((Plugin)FluffyMachines.getInstance(), "yCoordinate");
    private final NamespacedKey zCoord = new NamespacedKey((Plugin)FluffyMachines.getInstance(), "zCoordinate");
    private final NamespacedKey world = new NamespacedKey((Plugin)FluffyMachines.getInstance(), "world");
    private static final int LORE_COORDINATE_INDEX = 4;
    private final ItemSetting<Integer> MAX_DISTANCE = new ItemSetting((SlimefunItem)this, "max-distance", (Object)100);

    public WarpPadConfigurator(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)FluffyMachines.getInstance());
        this.addItemSetting(new ItemSetting[]{this.MAX_DISTANCE});
    }

    @EventHandler
    private void onInteract(PlayerInteractEvent e) {
        if (e.getClickedBlock() == null || e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Block b = e.getClickedBlock();
        Player p = e.getPlayer();
        if (BlockStorage.hasBlockInfo((Block)b) && BlockStorage.check((Block)b) == FluffyItems.WARP_PAD.getItem() && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), Interaction.PLACE_BLOCK)) {
            if (SlimefunUtils.isItemSimilar((ItemStack)p.getInventory().getItemInMainHand(), (ItemStack)FluffyItems.WARP_PAD_CONFIGURATOR, (boolean)false)) {
                ItemStack item = p.getInventory().getItemInMainHand();
                ItemMeta meta = item.getItemMeta();
                List lore = meta.getLore();
                PersistentDataContainer pdc = meta.getPersistentDataContainer();
                if (e.getAction() == Action.RIGHT_CLICK_BLOCK) {
                    if (p.isSneaking()) {
                        pdc.set(this.world, PersistentDataType.STRING, (Object)b.getWorld().getName());
                        pdc.set(this.xCoord, PersistentDataType.INTEGER, (Object)b.getX());
                        pdc.set(this.yCoord, PersistentDataType.INTEGER, (Object)b.getY());
                        pdc.set(this.zCoord, PersistentDataType.INTEGER, (Object)b.getZ());
                        lore.set(4, ChatColor.translateAlternateColorCodes((char)'&', (String)("&eLinked Coordinates: &7" + b.getX() + ", " + b.getY() + ", " + b.getZ())));
                        meta.setLore(lore);
                        item.setItemMeta(meta);
                        this.updateHologram(b, "&a&lDestination");
                        BlockStorage.addBlockInfo((Block)b, (String)"type", (String)"destination");
                        Utils.send((CommandSender)p, "&3This pad has been marked as a &aDestination &3and bound to your configurator");
                    } else if (pdc.has(this.world, PersistentDataType.STRING) && b.getWorld().getName().equals(pdc.get(this.world, PersistentDataType.STRING))) {
                        int x = (Integer)pdc.getOrDefault(this.xCoord, PersistentDataType.INTEGER, (Object)0);
                        int y = (Integer)pdc.getOrDefault(this.yCoord, PersistentDataType.INTEGER, (Object)0);
                        int z = (Integer)pdc.getOrDefault(this.zCoord, PersistentDataType.INTEGER, (Object)0);
                        if (Math.abs(x - b.getX()) > (Integer)this.MAX_DISTANCE.getValue() || Math.abs(z - b.getZ()) > (Integer)this.MAX_DISTANCE.getValue()) {
                            Utils.send((CommandSender)p, "&cYou can not link blocks more than " + this.MAX_DISTANCE.getValue() + " blocks apart!");
                            return;
                        }
                        this.registerOrigin(b, x, y, z);
                        Utils.send((CommandSender)p, "&3This pad has been marked as an &aOrigin &3and your configurator's settings have been pasted onto this pad");
                    } else {
                        Utils.send((CommandSender)p, "&cSneak and right click on a Warp Pad to set the destination, then right click another Warp Pad tp set the origin!");
                    }
                }
            } else {
                Utils.send((CommandSender)p, "&cConfigure this Warp Pad using a Warp Pad Configurator");
            }
        }
    }

    private void registerOrigin(Block b, int x, int y, int z) {
        BlockStorage.addBlockInfo((Block)b, (String)"type", (String)"origin");
        BlockStorage.addBlockInfo((Block)b, (String)"x", (String)String.valueOf(x));
        BlockStorage.addBlockInfo((Block)b, (String)"y", (String)String.valueOf(y));
        BlockStorage.addBlockInfo((Block)b, (String)"z", (String)String.valueOf(z));
        this.updateHologram(b, "&a&lOrigin");
    }
}

