/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.fluffymachines.machines;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.items.settings.IntRangeSetting;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.BlockPosition;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.ncbpfluffybear.fluffymachines.utils.FluffyItems;
import io.ncbpfluffybear.fluffymachines.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.apache.commons.lang.WordUtils;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class AdvancedAutoDisenchanter
extends SlimefunItem
implements EnergyNetComponent {
    private static final int[] BACKGROUND = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 12, 14, 21, 22, 23, 36, 37, 38, 42, 43, 44, 45, 46, 47, 51, 52, 53};
    private static final int[] INPUT_BORDER = new int[]{9, 10, 11, 18, 20, 27, 28, 29};
    private static final int[] OUTPUT_BORDER = new int[]{21, 22, 23, 30, 32, 39, 41, 48, 49, 50};
    private static final int[] BOOK_BORDER = new int[]{15, 16, 17, 24, 26, 33, 34, 35};
    private static final int ITEM_SLOT = 19;
    private static final int BOOK_SLOT = 25;
    private static final int[] OUTPUT_SLOTS = new int[]{31, 40};
    private static final int SELECTION_SLOT = 4;
    private static final int PROGRESS_SLOT = 13;
    public static final int ENERGY_CONSUMPTION = 1024;
    public static final int CAPACITY = 4096;
    private static final int PROCESS_TIME_TICKS = 60;
    private final ItemSetting<Boolean> useLevelLimit = new ItemSetting((SlimefunItem)this, "use-enchant-level-limit", (Object)false);
    private final IntRangeSetting levelLimit = new IntRangeSetting((SlimefunItem)this, "enchant-level-limit", 0, 10, Short.MAX_VALUE);
    private static final Map<BlockPosition, Integer> progress = new HashMap<BlockPosition, Integer>();
    private static final ItemStack DEFAULT_SELECTION_ITEM = new CustomItemStack(Material.ENCHANTED_BOOK, "&5Enchant Selector", new String[]{"", "&e> Click to rescan input slot <"});
    private static final ItemStack PROGRESS_ITEM = new CustomItemStack(Material.EXPERIENCE_BOTTLE, "&aProgress", new String[0]);

    public AdvancedAutoDisenchanter(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.addItemHandler(new ItemHandler[]{this.onBreak()});
        this.addItemSetting(new ItemSetting[]{this.useLevelLimit, this.levelLimit});
        new BlockMenuPreset(this.getId(), "&cAdvanced Auto Disenchanter"){

            public void init() {
                AdvancedAutoDisenchanter.this.constructMenu(this);
            }

            public void newInstance(@Nonnull BlockMenu menu, @Nonnull Block b) {
                menu.replaceExistingItem(4, DEFAULT_SELECTION_ITEM.clone());
                menu.addMenuClickHandler(4, (p, slot, item, action) -> {
                    AdvancedAutoDisenchanter.this.cycleEnchants(menu, b);
                    return false;
                });
                menu.addMenuClickHandler(19, (p, slot, item, action) -> {
                    menu.replaceExistingItem(4, DEFAULT_SELECTION_ITEM.clone());
                    AdvancedAutoDisenchanter.this.setSelectedIndex(b, -2);
                    return true;
                });
                AdvancedAutoDisenchanter.this.setSelectedIndex(b, -2);
            }

            public boolean canOpen(@Nonnull Block b, @Nonnull Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), Interaction.INTERACT_BLOCK);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow itemTransportFlow) {
                return new int[0];
            }

            public int[] getSlotsAccessedByItemTransport(DirtyChestMenu menu, ItemTransportFlow flow, ItemStack item) {
                if (flow == ItemTransportFlow.INSERT) {
                    if (item.getType() == Material.BOOK) {
                        return new int[]{25};
                    }
                    return new int[]{19};
                }
                if (flow == ItemTransportFlow.WITHDRAW) {
                    return OUTPUT_SLOTS;
                }
                return new int[0];
            }
        };
    }

    private BlockBreakHandler onBreak() {
        return new BlockBreakHandler(false, false){

            public void onPlayerBreak(@Nonnull BlockBreakEvent e, @Nonnull ItemStack item, @Nonnull List<ItemStack> drops) {
                Block b = e.getBlock();
                BlockMenu inv = BlockStorage.getInventory((Block)b);
                if (inv != null) {
                    inv.dropItems(b.getLocation(), new int[]{19});
                    inv.dropItems(b.getLocation(), new int[]{25});
                    inv.dropItems(b.getLocation(), OUTPUT_SLOTS);
                }
            }
        };
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public void tick(Block b, SlimefunItem sf, Config data) {
                AdvancedAutoDisenchanter.this.tick(b);
            }

            public boolean isSynchronized() {
                return false;
            }
        }});
    }

    protected void tick(Block b) {
        if (this.getCharge(b.getLocation()) < 1024) {
            return;
        }
        BlockMenu inv = BlockStorage.getInventory((Block)b);
        BlockPosition pos = new BlockPosition(b.getWorld(), b.getX(), b.getY(), b.getZ());
        int currentProgress = progress.getOrDefault(pos, 0);
        int selectedEnchant = this.getSelectedIndex(b.getLocation());
        if (selectedEnchant < 0) {
            return;
        }
        for (int slot : OUTPUT_SLOTS) {
            if (inv.getItemInSlot(slot) == null) continue;
            return;
        }
        ItemStack input = inv.getItemInSlot(19);
        SlimefunItem sfItem = SlimefunItem.getByItem((ItemStack)input);
        if (input == null || input.getEnchantments().isEmpty() || sfItem != null && !sfItem.isDisenchantable()) {
            return;
        }
        if (!SlimefunUtils.isItemSimilar((ItemStack)inv.getItemInSlot(25), (ItemStack)FluffyItems.ANCIENT_BOOK.getItem().getItem(), (boolean)false, (boolean)false)) {
            return;
        }
        if (currentProgress < 60) {
            progress.put(pos, ++currentProgress);
            ChestMenuUtils.updateProgressbar((ChestMenu)inv, (int)13, (int)(60 - currentProgress), (int)60, (ItemStack)PROGRESS_ITEM);
            this.removeCharge(b.getLocation(), 1024);
            return;
        }
        Map<Enchantment, Integer> disenchants = this.getValidDisenchants(input);
        Enchantment outputEnchant = disenchants.keySet().toArray(new Enchantment[0])[selectedEnchant];
        if (outputEnchant == null) {
            return;
        }
        ItemStack enchantedBook = new ItemStack(Material.ENCHANTED_BOOK);
        EnchantmentStorageMeta enchantedMeta = (EnchantmentStorageMeta)enchantedBook.getItemMeta();
        enchantedMeta.addStoredEnchant(outputEnchant, disenchants.get(outputEnchant).intValue(), true);
        enchantedBook.setItemMeta((ItemMeta)enchantedMeta);
        input.removeEnchantment(outputEnchant);
        inv.pushItem(input, OUTPUT_SLOTS);
        inv.pushItem(enchantedBook, OUTPUT_SLOTS);
        inv.consumeItem(19);
        inv.consumeItem(25);
        progress.put(pos, 0);
        currentProgress = progress.getOrDefault(pos, 0);
        ChestMenuUtils.updateProgressbar((ChestMenu)inv, (int)13, (int)(60 - currentProgress), (int)60, (ItemStack)PROGRESS_ITEM);
        this.setSelectedIndex(b, -2);
        inv.replaceExistingItem(4, DEFAULT_SELECTION_ITEM.clone());
    }

    private void cycleEnchants(BlockMenu inv, Block b) {
        int currentSelection = this.getSelectedIndex(b.getLocation());
        Map<Enchantment, Integer> itemEnchants = this.getValidDisenchants(inv.getItemInSlot(19));
        ArrayList<String> lore = new ArrayList<String>();
        if (inv.getItemInSlot(19) == null) {
            lore.add(Utils.color("&cPlace an item into the item slot first"));
            lore.add("");
            lore.add(Utils.color("&e> Click to rescan input slot <"));
            this.setSelectionItem(inv, lore);
            this.setSelectedIndex(b, -2);
            return;
        }
        if (itemEnchants.isEmpty()) {
            lore.add(Utils.color("&cThis item has no available disenchants!"));
            lore.add("");
            lore.add(Utils.color("&e> Click to rescan input slot <"));
            this.setSelectionItem(inv, lore);
            this.setSelectedIndex(b, -2);
            return;
        }
        if (++currentSelection > itemEnchants.size() - 1) {
            currentSelection = -1;
        }
        this.buildAndSetSelectionItem(itemEnchants, inv, currentSelection);
        this.setSelectedIndex(b, currentSelection);
    }

    private void constructMenu(BlockMenuPreset preset) {
        ChestMenuUtils.drawBackground((ChestMenu)preset, (int[])BACKGROUND);
        for (int i : INPUT_BORDER) {
            preset.addItem(i, ChestMenuUtils.getInputSlotTexture(), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : BOOK_BORDER) {
            preset.addItem(i, (ItemStack)new CustomItemStack(new ItemStack(Material.YELLOW_STAINED_GLASS_PANE), " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : OUTPUT_BORDER) {
            preset.addItem(i, ChestMenuUtils.getOutputSlotTexture(), ChestMenuUtils.getEmptyClickHandler());
        }
        preset.addItem(13, PROGRESS_ITEM, ChestMenuUtils.getEmptyClickHandler());
    }

    private void buildAndSetSelectionItem(Map<Enchantment, Integer> disenchants, BlockMenu menu, int selectionIndex) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(Utils.color("&e> Click to cycle through enchants <"));
        lore.add("");
        if (selectionIndex == -1) {
            lore.add(Utils.color("&a- None"));
        } else {
            lore.add(Utils.color("&c- None"));
        }
        Enchantment[] disenchantKeys = disenchants.keySet().toArray(new Enchantment[0]);
        for (int i = 0; i < disenchantKeys.length; ++i) {
            ChatColor textColor = ChatColor.RED;
            if (i == selectionIndex) {
                textColor = ChatColor.GREEN;
            }
            lore.add(textColor + WordUtils.capitalizeFully((String)("- " + disenchantKeys[i].getKey().getKey().replace('_', ' '))) + " " + Utils.toRoman(disenchants.get(disenchantKeys[i])));
        }
        this.setSelectionItem(menu, lore);
    }

    private Map<Enchantment, Integer> getValidDisenchants(ItemStack item) {
        if (item == null) {
            return new HashMap<Enchantment, Integer>();
        }
        SlimefunItem sfItem = SlimefunItem.getByItem((ItemStack)item);
        if (sfItem != null && !sfItem.isDisenchantable()) {
            return new HashMap<Enchantment, Integer>();
        }
        Map disenchants = item.getEnchantments();
        HashMap<Enchantment, Integer> filteredDisenchants = new HashMap<Enchantment, Integer>(item.getEnchantments());
        for (Map.Entry disenchantEntry : disenchants.entrySet()) {
            if (!((Boolean)this.useLevelLimit.getValue()).booleanValue() || (Integer)disenchantEntry.getValue() <= (Integer)this.levelLimit.getValue()) continue;
            filteredDisenchants.remove(disenchantEntry.getKey());
        }
        return filteredDisenchants;
    }

    private void setSelectionItem(BlockMenu menu, List<String> lore) {
        ItemStack selectionItem = new ItemStack(Material.ENCHANTED_BOOK);
        ItemMeta itemMeta = selectionItem.getItemMeta();
        itemMeta.setDisplayName(Utils.color("&5Enchant Selector"));
        itemMeta.setLore(lore);
        selectionItem.setItemMeta(itemMeta);
        menu.replaceExistingItem(4, selectionItem);
    }

    private int getSelectedIndex(Location l) {
        return Integer.parseInt(BlockStorage.getLocationInfo((Location)l, (String)"selection"));
    }

    private void setSelectedIndex(Block b, int index) {
        BlockStorage.addBlockInfo((Block)b, (String)"selection", (String)String.valueOf(index));
    }

    @Nonnull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getCapacity() {
        return 4096;
    }
}

