/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.fluffymachines.machines;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks.OreWasher;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.ncbpfluffybear.fluffymachines.utils.Constants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ElectricDustFabricator
extends AContainer
implements RecipeDisplayItem {
    public static final int ENERGY_CONSUMPTION = 256;
    public static final int CAPACITY = 768;
    private OreWasher oreWasher;
    private final List<ItemStack> acceptableInputs = new ArrayList<ItemStack>(Arrays.asList(new ItemStack(Material.COBBLESTONE), new ItemStack(Material.ANDESITE), new ItemStack(Material.DIORITE), new ItemStack(Material.GRANITE)));

    public ElectricDustFabricator(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    public void preRegister() {
        super.preRegister();
        this.oreWasher = (OreWasher)SlimefunItems.ORE_WASHER.getItem();
    }

    @Nonnull
    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> displayRecipes = new ArrayList<ItemStack>();
        for (SlimefunItemStack dust : Constants.dusts) {
            displayRecipes.add((ItemStack)new CustomItemStack(Material.COBBLESTONE, "&fAny Cobblestone Variant", new String[]{"&7Cobblestone", "&7Andesite", "&7Diorite", "&7Granite"}));
            displayRecipes.add((ItemStack)dust);
        }
        return displayRecipes;
    }

    protected MachineRecipe findNextRecipe(BlockMenu menu) {
        for (int slot : this.getInputSlots()) {
            for (ItemStack acceptableInput : this.acceptableInputs) {
                if (!SlimefunUtils.isItemSimilar((ItemStack)menu.getItemInSlot(slot), (ItemStack)acceptableInput, (boolean)true, (boolean)false)) continue;
                if (!this.hasFreeSlot(menu)) {
                    return null;
                }
                ItemStack dust = this.oreWasher.getRandomDust();
                MachineRecipe recipe = new MachineRecipe(4 / this.getSpeed(), new ItemStack[]{acceptableInput}, new ItemStack[]{dust});
                if (!menu.fits(recipe.getOutput()[0], this.getOutputSlots())) continue;
                menu.consumeItem(slot);
                return recipe;
            }
        }
        return null;
    }

    private boolean hasFreeSlot(BlockMenu menu) {
        for (int slot : this.getOutputSlots()) {
            ItemStack item = menu.getItemInSlot(slot);
            if (item != null && item.getType() != Material.AIR) continue;
            return true;
        }
        return false;
    }

    public ItemStack getProgressBar() {
        return new ItemStack(Material.CAULDRON);
    }

    @Nonnull
    public String getMachineIdentifier() {
        return "DUST_FABRICATOR";
    }

    public int getCapacity() {
        return 768;
    }

    public int getEnergyConsumption() {
        return 256;
    }

    public int getSpeed() {
        return 10;
    }
}

