/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.fluffymachines.items.tools;

import io.github.thebusybiscuit.slimefun4.api.events.ExplosiveToolBreakBlocksEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.ToolUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.tools.ExplosiveTool;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.tags.SlimefunTag;
import io.ncbpfluffybear.fluffymachines.items.tools.AlternateBreakEvent;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.inventory.ItemStack;

class UpgradedExplosiveTool
extends ExplosiveTool {
    private final ItemSetting<Boolean> damageOnUse;
    private final ItemSetting<Boolean> callExplosionEvent;
    private final ItemSetting<Boolean> breakFromCenter = new ItemSetting((SlimefunItem)this, "break-from-center", (Object)false);
    private final ItemSetting<Boolean> triggerOtherPlugins = new ItemSetting((SlimefunItem)this, "trigger-other-plugins", (Object)true);

    public UpgradedExplosiveTool(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.addItemSetting(new ItemSetting[]{this.breakFromCenter, this.triggerOtherPlugins});
        this.damageOnUse = (ItemSetting)this.getItemSetting("damage-on-use", Boolean.class).get();
        this.callExplosionEvent = (ItemSetting)this.getItemSetting("call-explosion-event", Boolean.class).get();
    }

    @Nonnull
    public ToolUseHandler getItemHandler() {
        return (e, tool, fortune, drops) -> {
            if (e instanceof AlternateBreakEvent) {
                return;
            }
            Player p = e.getPlayer();
            Block b = e.getBlock();
            b.getWorld().createExplosion(b.getLocation(), 0.0f);
            b.getWorld().playSound(b.getLocation(), Sound.ENTITY_GENERIC_EXPLODE, 0.2f, 1.0f);
            BlockFace face = p.getFacing();
            if ((double)p.getLocation().getPitch() > 67.5) {
                face = BlockFace.DOWN;
            } else if ((double)p.getLocation().getPitch() < -67.5) {
                face = BlockFace.UP;
            }
            List<Block> blocks = this.findBlocks(b, face);
            this.breakBlocks(p, tool, b, blocks, drops);
        };
    }

    private void breakBlocks(Player p, ItemStack item, Block b, List<Block> blocks, List<ItemStack> drops) {
        ArrayList<Block> blocksToDestroy = new ArrayList<Block>();
        if (((Boolean)this.callExplosionEvent.getValue()).booleanValue()) {
            BlockExplodeEvent blockExplodeEvent = new BlockExplodeEvent(b, blocks, 0.0f);
            Bukkit.getServer().getPluginManager().callEvent((Event)blockExplodeEvent);
            if (!blockExplodeEvent.isCancelled()) {
                for (Block block : blockExplodeEvent.blockList()) {
                    if (!this.canBreak(p, block)) continue;
                    blocksToDestroy.add(block);
                }
            }
        } else {
            for (Block block : blocks) {
                if (!this.canBreak(p, block)) continue;
                blocksToDestroy.add(block);
            }
        }
        ExplosiveToolBreakBlocksEvent event = new ExplosiveToolBreakBlocksEvent(p, b, blocksToDestroy, item, (ExplosiveTool)this);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            for (Block block : blocksToDestroy) {
                this.breakBlock(p, item, block, drops);
            }
        }
    }

    private List<Block> findBlocks(Block b, BlockFace face) {
        ArrayList<Block> blocks = new ArrayList<Block>(26);
        Block center = b;
        if (!((Boolean)this.breakFromCenter.getValue()).booleanValue()) {
            center = b.getRelative(face, 2);
        }
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    Block relative = center.getRelative(x, y, z);
                    if (relative.getLocation().equals((Object)b.getLocation()) || relative.getType() == Material.AIR) continue;
                    blocks.add(relative);
                }
            }
        }
        return blocks;
    }

    public boolean isDamageable() {
        return (Boolean)this.damageOnUse.getValue();
    }

    protected boolean canBreak(@Nonnull Player p, @Nonnull Block b) {
        if (b.isEmpty() || b.isLiquid()) {
            return false;
        }
        if (SlimefunTag.UNBREAKABLE_MATERIALS.isTagged(b.getType())) {
            return false;
        }
        if (!b.getWorld().getWorldBorder().isInside(b.getLocation())) {
            return false;
        }
        if (Slimefun.getIntegrations().isCustomBlock(b)) {
            return false;
        }
        return Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), Interaction.BREAK_BLOCK);
    }

    private void breakBlock(Player p, ItemStack item, Block b, List<ItemStack> drops) {
        Slimefun.getProtectionManager().logAction((OfflinePlayer)p, b, Interaction.BREAK_BLOCK);
        Material material = b.getType();
        b.getWorld().playEffect(b.getLocation(), Effect.STEP_SOUND, (Object)material);
        SlimefunItem sfItem = BlockStorage.check((Block)b);
        if (sfItem != null) {
            return;
        }
        if (((Boolean)this.triggerOtherPlugins.getValue()).booleanValue()) {
            AlternateBreakEvent breakEvent = new AlternateBreakEvent(b, p);
            Bukkit.getServer().getPluginManager().callEvent((Event)breakEvent);
        }
        b.breakNaturally(item);
        this.damageItem(p, item);
    }
}

