/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.fluffymachines.items;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import io.ncbpfluffybear.fluffymachines.items.Barrel;
import io.ncbpfluffybear.fluffymachines.utils.Utils;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;

public class MiniBarrel
extends Barrel {
    private static final int MAX_STORAGE = 172800;

    public MiniBarrel(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe, 172800);
        this.addItemHandler(new ItemHandler[]{this.onPlace()});
    }

    private BlockPlaceHandler onPlace() {
        return new BlockPlaceHandler(false){

            public void onPlayerPlace(@Nonnull BlockPlaceEvent e) {
                BlockStorage.addBlockInfo((Block)e.getBlock(), (String)"max-size", (String)String.valueOf(MiniBarrel.this.barrelCapacity.getValue()));
            }
        };
    }

    @Override
    protected void buildMenu(BlockMenu menu, Block b) {
        super.buildMenu(menu, b);
        menu.replaceExistingItem(13, (ItemStack)new CustomItemStack(Material.YELLOW_STAINED_GLASS_PANE, "&eChange barrel size", new String[]{"&7> Click to change max size", "&eCurrent size: " + this.getCapacity(b), "&eSize limit: " + this.barrelCapacity.getValue()}));
        menu.addMenuClickHandler(13, (p, slot, item, action) -> {
            p.closeInventory();
            Utils.send((CommandSender)p, "&eType the new size of the barrel. Max size: " + this.barrelCapacity.getValue());
            ChatUtils.awaitInput((Player)p, message -> {
                int renameSize = NumberUtils.getInt((String)message, (int)0);
                if (renameSize == 0 || renameSize > (Integer)this.barrelCapacity.getValue()) {
                    Utils.send((CommandSender)p, "&cThe new size must be between 0 and " + this.barrelCapacity.getValue());
                    return;
                }
                if (renameSize < this.getStored(b)) {
                    Utils.send((CommandSender)p, "&cRemove items from the barrel before changing it to this size!");
                    return;
                }
                BlockStorage.addBlockInfo((Block)b, (String)"max-size", (String)String.valueOf(renameSize));
                menu.replaceExistingItem(13, (ItemStack)new CustomItemStack(Material.YELLOW_STAINED_GLASS_PANE, "&eChange barrel size", new String[]{"&7> Click to change max size", "&eCurrent size: " + renameSize, "&eSize limit: " + this.barrelCapacity.getValue()}));
                Utils.send((CommandSender)p, "&aMax size has been changed to " + renameSize);
                this.updateMenu(b, menu, true, renameSize);
            });
            return false;
        });
    }

    @Override
    public int getCapacity(Block b) {
        String capacity = BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"max-size");
        if (capacity == null) {
            BlockStorage.addBlockInfo((Block)b, (String)"max-size", (String)String.valueOf(this.barrelCapacity.getValue()));
            return (Integer)this.barrelCapacity.getValue();
        }
        return Integer.parseInt(capacity);
    }

    public static int getDisplayCapacity() {
        int capacity = Slimefun.getItemCfg().getInt("MINI_FLUFFY_BARREL.capacity");
        if (capacity == 0) {
            capacity = 172800;
        }
        return capacity;
    }
}

