/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.fluffymachines.machines;

import io.github.thebusybiscuit.slimefun4.api.events.BlockPlacerPlaceEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;

public class AutoTableSaw
extends SlimefunItem
implements EnergyNetComponent {
    public static final int ENERGY_CONSUMPTION = 128;
    public static final int CAPACITY = 384;
    private final int[] border = new int[]{0, 1, 3, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 22, 27, 31, 36, 40, 45, 46, 47, 48, 49, 50, 51, 52, 53};
    private final int[] inputBorder = new int[]{19, 20, 21, 28, 30, 37, 38, 39};
    private final int[] outputBorder = new int[]{23, 24, 25, 26, 32, 35, 41, 42, 43, 44};
    private final int[] inputSlots = new int[]{29};
    private final int[] outputSlots = new int[]{33, 34};
    private final Map<ItemStack, ItemStack> tableSawRecipes = new HashMap<ItemStack, ItemStack>();

    public AutoTableSaw(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        for (Material log : Tag.LOGS.getValues()) {
            Optional<Material> planks = this.getPlanks(log);
            planks.ifPresent(material -> this.tableSawRecipes.put(new ItemStack(log), new ItemStack(material, 8)));
        }
        for (Material plank : Tag.PLANKS.getValues()) {
            this.tableSawRecipes.put(new ItemStack(plank), new ItemStack(Material.STICK, 4));
        }
        new BlockMenuPreset(this.getId(), "&6Auto Table Saw"){

            public void init() {
                AutoTableSaw.this.constructMenu(this);
            }

            public void newInstance(@Nonnull BlockMenu menu, @Nonnull Block b) {
                if (!BlockStorage.hasBlockInfo((Block)b) || BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"enabled") == null || BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"enabled").equals(String.valueOf(false))) {
                    menu.replaceExistingItem(6, (ItemStack)new CustomItemStack(Material.GUNPOWDER, "&7Enabled: &4\u2718", new String[]{"", "&e> Click to enable this Machine"}));
                    menu.addMenuClickHandler(6, (p, slot, item, action) -> {
                        BlockStorage.addBlockInfo((Block)b, (String)"enabled", (String)String.valueOf(true));
                        this.newInstance(menu, b);
                        return false;
                    });
                } else {
                    menu.replaceExistingItem(6, (ItemStack)new CustomItemStack(Material.REDSTONE, "&7Enabled: &2\u2714", new String[]{"", "&e> Click to disable this Machine"}));
                    menu.addMenuClickHandler(6, (p, slot, item, action) -> {
                        BlockStorage.addBlockInfo((Block)b, (String)"enabled", (String)String.valueOf(false));
                        this.newInstance(menu, b);
                        return false;
                    });
                }
            }

            public boolean canOpen(@Nonnull Block b, @Nonnull Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), Interaction.INTERACT_BLOCK);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return new int[0];
            }

            public int[] getSlotsAccessedByItemTransport(DirtyChestMenu menu, ItemTransportFlow flow, ItemStack item) {
                if (flow == ItemTransportFlow.WITHDRAW) {
                    return AutoTableSaw.this.outputSlots;
                }
                return AutoTableSaw.this.inputSlots;
            }
        };
        this.addItemHandler(new ItemHandler[]{this.onPlace()});
        this.addItemHandler(new ItemHandler[]{this.onBreak()});
    }

    private BlockBreakHandler onBreak() {
        return new BlockBreakHandler(false, false){

            public void onPlayerBreak(@Nonnull BlockBreakEvent e, @Nonnull ItemStack item, @Nonnull List<ItemStack> drops) {
                Block b = e.getBlock();
                BlockMenu inv = BlockStorage.getInventory((Block)b);
                Location location = b.getLocation();
                if (inv != null) {
                    inv.dropItems(location, AutoTableSaw.this.inputSlots);
                    inv.dropItems(location, AutoTableSaw.this.outputSlots);
                }
            }
        };
    }

    private BlockPlaceHandler onPlace() {
        return new BlockPlaceHandler(true){

            public void onPlayerPlace(@Nonnull BlockPlaceEvent e) {
                BlockStorage.addBlockInfo((Block)e.getBlock(), (String)"enabled", (String)String.valueOf(false));
            }

            public void onBlockPlacerPlace(@Nonnull BlockPlacerPlaceEvent e) {
                BlockStorage.addBlockInfo((Block)e.getBlock(), (String)"enabled", (String)String.valueOf(false));
            }
        };
    }

    protected void constructMenu(BlockMenuPreset preset) {
        AutoTableSaw.borders(preset, this.border, this.inputBorder, this.outputBorder);
        preset.addItem(2, (ItemStack)new CustomItemStack(new ItemStack(Material.STONECUTTER), "&eRecipe", new String[]{"", "&bPut in the Recipe you want to craft", "&4Table Saw Recipes ONLY"}), ChestMenuUtils.getEmptyClickHandler());
    }

    @Nonnull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getCapacity() {
        return 384;
    }

    public int getEnergyConsumption() {
        return 128;
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public void tick(Block b, SlimefunItem sf, Config data) {
                AutoTableSaw.this.tick(b);
            }

            public boolean isSynchronized() {
                return false;
            }
        }});
    }

    protected void tick(Block block) {
        if (BlockStorage.getLocationInfo((Location)block.getLocation(), (String)"enabled").equals(String.valueOf(false))) {
            return;
        }
        if (this.getCharge(block.getLocation()) < this.getEnergyConsumption()) {
            return;
        }
        BlockMenu menu = BlockStorage.getInventory((Block)block);
        this.tableSawRecipes.forEach((input, output) -> {
            if (menu.getItemInSlot(this.inputSlots[0]) != null && SlimefunUtils.isItemSimilar((ItemStack)menu.getItemInSlot(this.inputSlots[0]), (ItemStack)input, (boolean)true, (boolean)false) && menu.fits(output, this.outputSlots)) {
                menu.consumeItem(this.inputSlots[0]);
                menu.pushItem(output.clone(), this.outputSlots);
            }
        });
    }

    @Nonnull
    private Optional<Material> getPlanks(@Nonnull Material log) {
        Object materialName = log.name().replace("STRIPPED_", "");
        materialName = ((String)materialName).substring(0, ((String)materialName).lastIndexOf(95)) + "_PLANKS";
        return Optional.ofNullable(Material.getMaterial((String)materialName));
    }

    static void borders(BlockMenuPreset preset, int[] border, int[] inputBorder, int[] outputBorder) {
        for (int i : border) {
            preset.addItem(i, (ItemStack)new CustomItemStack(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " ", new String[0]), (p, slot, item, action) -> false);
        }
        for (int i : inputBorder) {
            preset.addItem(i, (ItemStack)new CustomItemStack(new ItemStack(Material.CYAN_STAINED_GLASS_PANE), " ", new String[0]), (p, slot, item, action) -> false);
        }
        for (int i : outputBorder) {
            preset.addItem(i, (ItemStack)new CustomItemStack(new ItemStack(Material.ORANGE_STAINED_GLASS_PANE), " ", new String[0]), (p, slot, item, action) -> false);
        }
    }
}

