/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.fluffymachines.items.tools;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerBackpack;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.ncbpfluffybear.fluffymachines.utils.Utils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Chest;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.scheduler.BukkitRunnable;

public class Dolly
extends SimpleSlimefunItem<ItemUseHandler> {
    private static final ItemStack LOCK_ITEM = Utils.buildNonInteractable(Material.DIRT, "&4&lDolly empty", "&cHow did you get in here?");
    private static final int DELAY = 500;
    private final Map<Player, Long> timeouts = new HashMap<Player, Long>();

    public Dolly(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Nonnull
    public ItemUseHandler getItemHandler() {
        return e -> {
            e.cancel();
            Player p = e.getPlayer();
            if (this.timeouts.containsKey(p) && this.timeouts.get(p) + 500L > System.currentTimeMillis()) {
                Utils.send((CommandSender)p, "&cPlease wait before using the dolly again!");
                return;
            }
            this.timeouts.put(p, System.currentTimeMillis());
            ItemStack dolly = e.getItem();
            if (!e.getClickedBlock().isPresent()) {
                return;
            }
            Block b = (Block)e.getClickedBlock().get();
            if (BlockStorage.hasBlockInfo((Block)b)) {
                return;
            }
            if (b.getType() == Material.CHEST && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)e.getPlayer(), b.getLocation(), Interaction.BREAK_BLOCK)) {
                this.buildDolly(dolly, p);
                this.pickupChest(dolly, b, p);
            } else if (Slimefun.getProtectionManager().hasPermission((OfflinePlayer)e.getPlayer(), b.getLocation(), Interaction.PLACE_BLOCK)) {
                this.placeChest(dolly, b.getRelative(e.getClickedFace()), p);
            }
        };
    }

    private void buildDolly(ItemStack dolly, Player p) {
        ItemMeta dollyMeta = dolly.getItemMeta();
        for (String line : dollyMeta.getLore()) {
            if (!line.contains("ID: <ID>")) continue;
            PlayerProfile.get((OfflinePlayer)p, profile -> {
                int backpackId = profile.createBackpack(54).getId();
                Slimefun.getBackpackListener().setBackpackId((OfflinePlayer)p, dolly, 3, backpackId);
                PlayerProfile.getBackpack((ItemStack)dolly, backpack -> backpack.getInventory().setItem(0, LOCK_ITEM));
            });
        }
    }

    private void pickupChest(ItemStack dolly, Block chest, Player p) {
        Inventory chestInventory = ((InventoryHolder)chest.getState()).getInventory();
        AtomicBoolean validOperation = new AtomicBoolean(false);
        AtomicBoolean isDoubleChest = new AtomicBoolean(false);
        PlayerProfile.getBackpack((ItemStack)dolly, backpack -> {
            if (backpack == null) {
                return;
            }
            if (!this.isLockItem(backpack.getInventory().getItem(0))) {
                Utils.send((CommandSender)p, "&cThis dolly is already carrying a chest!");
                return;
            }
            if (backpack.getSize() < 54) {
                backpack.setSize(54);
            }
            backpack.getInventory().setStorageContents(chestInventory.getContents());
            if (chestInventory.getSize() == 54) {
                isDoubleChest.set(true);
            } else {
                backpack.getInventory().setItem(27, LOCK_ITEM);
            }
            chestInventory.clear();
            PlayerProfile.getBackpack((ItemStack)dolly, PlayerBackpack::markDirty);
            validOperation.set(true);
            dolly.setType(Material.CHEST_MINECART);
        });
        if (validOperation.get()) {
            if (isDoubleChest.get()) {
                DoubleChest doubleChest = (DoubleChest)((org.bukkit.block.Chest)chest.getState()).getInventory().getHolder();
                if (((org.bukkit.block.Chest)doubleChest.getLeftSide()).getLocation().equals((Object)chest.getLocation())) {
                    ((org.bukkit.block.Chest)doubleChest.getRightSide()).getLocation().getBlock().setType(Material.AIR);
                } else {
                    ((org.bukkit.block.Chest)doubleChest.getLeftSide()).getLocation().getBlock().setType(Material.AIR);
                }
            }
            chest.setType(Material.AIR);
            Utils.send((CommandSender)p, "&aYou have picked up this chest");
        }
    }

    private void placeChest(ItemStack dolly, final Block chestBlock, final Player p) {
        PlayerProfile.getBackpack((ItemStack)dolly, backpack -> {
            ItemStack[][] bpContents;
            if (backpack == null) {
                return;
            }
            if (backpack.getSize() == 27) {
                backpack.setSize(54);
                backpack.getInventory().setItem(27, LOCK_ITEM);
            }
            if (this.isLockItem((bpContents = new ItemStack[][]{backpack.getInventory().getContents()})[0][0])) {
                Utils.send((CommandSender)p, "&cYou must pick up a chest first!");
                return;
            }
            final boolean singleChest = this.isLockItem(bpContents[0][27]);
            if (!this.canChestFit(chestBlock, p, singleChest)) {
                Utils.send((CommandSender)p, "&cYou can't fit your chest there!");
                return;
            }
            Utils.runSync((Runnable)new BukkitRunnable((PlayerBackpack)backpack, bpContents, dolly){
                final /* synthetic */ PlayerBackpack val$backpack;
                final /* synthetic */ ItemStack[][] val$bpContents;
                final /* synthetic */ ItemStack val$dolly;
                {
                    this.val$backpack = playerBackpack;
                    this.val$bpContents = itemStackArray;
                    this.val$dolly = itemStack;
                }

                public void run() {
                    Dolly.this.createChest(chestBlock, p, singleChest);
                    this.val$backpack.getInventory().clear();
                    this.val$backpack.getInventory().setItem(0, LOCK_ITEM);
                    if (singleChest) {
                        this.val$bpContents[0] = Arrays.copyOf(this.val$bpContents[0], 27);
                    }
                    ((InventoryHolder)chestBlock.getState()).getInventory().setStorageContents(this.val$bpContents[0]);
                    this.val$dolly.setType(Material.MINECART);
                    Utils.send((CommandSender)p, "&aChest has been placed");
                }
            });
        });
    }

    private boolean canChestFit(Block singleChestBlock, Player p, boolean singleChest) {
        boolean fits;
        boolean bl = fits = singleChestBlock.getType() == Material.AIR;
        if (!singleChest) {
            fits = fits && this.getRightBlock(singleChestBlock, p.getFacing().getOppositeFace()).getType() == Material.AIR;
        }
        return fits;
    }

    private void createChest(Block firstChest, Player p, boolean singleChest) {
        BlockFace chestFace = p.getFacing().getOppositeFace();
        firstChest.setType(Material.CHEST);
        Directional firstDirectional = (Directional)firstChest.getBlockData();
        firstDirectional.setFacing(chestFace);
        firstChest.setBlockData((BlockData)firstDirectional);
        if (!singleChest) {
            Block secondChest = this.getRightBlock(firstChest, chestFace);
            secondChest.setType(Material.CHEST);
            Directional secondDirectional = (Directional)secondChest.getBlockData();
            secondDirectional.setFacing(chestFace);
            secondChest.setBlockData((BlockData)secondDirectional);
            Chest firstChestType = (Chest)firstChest.getBlockData();
            Chest secondChestType = (Chest)secondChest.getBlockData();
            firstChestType.setType(Chest.Type.RIGHT);
            secondChestType.setType(Chest.Type.LEFT);
            firstChest.setBlockData((BlockData)firstChestType);
            secondChest.setBlockData((BlockData)secondChestType);
        }
    }

    @Nonnull
    private Block getRightBlock(Block b, BlockFace face) {
        return b.getRelative(switch (face) {
            case BlockFace.NORTH -> BlockFace.WEST;
            case BlockFace.EAST -> BlockFace.NORTH;
            case BlockFace.SOUTH -> BlockFace.EAST;
            case BlockFace.WEST -> BlockFace.SOUTH;
            default -> throw new IllegalStateException("Unexpected value: " + face);
        });
    }

    private boolean isLockItem(@Nullable ItemStack lockItem) {
        return lockItem != null && (Utils.checkNonInteractable(lockItem) || lockItem.getItemMeta().hasCustomModelData() && lockItem.getItemMeta().getCustomModelData() == 6969);
    }
}

