/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.fluffymachines.machines;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.handlers.SimpleBlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.BlockPosition;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.Pair;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.ncbpfluffybear.fluffymachines.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SmartFactory
extends SlimefunItem
implements EnergyNetComponent,
RecipeDisplayItem {
    private static final int[] BORDER = new int[]{5, 6, 7, 8, 41, 42, 44, 50, 51, 52, 53};
    private static final int[] BORDER_IN = new int[]{0, 1, 2, 3, 4, 9, 13, 18, 22, 27, 31, 36, 40, 45, 46, 47, 48, 49};
    private static final int[] BORDER_OUT = new int[]{14, 15, 16, 17, 23, 26, 32, 33, 34, 35};
    private static final int[] COAL_SLOTS = new int[]{10, 11, 12};
    private static final int[] MISC_SLOTS = new int[]{19, 20, 21, 28, 29, 30, 37, 38, 39};
    private static final int[] INPUT_SLOTS = new int[]{10, 11, 12, 19, 20, 21, 28, 29, 30, 37, 38, 39};
    private static final int PROGRESS_SLOT = 42;
    public static final int RECIPE_SLOT = 43;
    private static final ItemStack PROGRESS_ITEM = new CustomItemStack(Material.FLINT_AND_STEEL, "&aProgress", new String[0]);
    private static final Map<BlockPosition, Integer> progress = new HashMap<BlockPosition, Integer>();
    private static final int PROCESS_TIME_TICKS = 10;
    private static final List<SlimefunItemStack> ACCEPTED_ITEMS = new ArrayList<SlimefunItemStack>(Arrays.asList(SlimefunItems.BILLON_INGOT, SlimefunItems.SOLDER_INGOT, SlimefunItems.NICKEL_INGOT, SlimefunItems.COBALT_INGOT, SlimefunItems.DURALUMIN_INGOT, SlimefunItems.BRONZE_INGOT, SlimefunItems.BRASS_INGOT, SlimefunItems.ALUMINUM_BRASS_INGOT, SlimefunItems.STEEL_INGOT, SlimefunItems.DAMASCUS_STEEL_INGOT, SlimefunItems.ALUMINUM_BRONZE_INGOT, SlimefunItems.CORINTHIAN_BRONZE_INGOT, SlimefunItems.GILDED_IRON, SlimefunItems.REDSTONE_ALLOY, SlimefunItems.HARDENED_METAL_INGOT, SlimefunItems.REINFORCED_ALLOY_INGOT, SlimefunItems.FERROSILICON, SlimefunItems.ELECTRO_MAGNET, SlimefunItems.ELECTRIC_MOTOR, SlimefunItems.HEATING_COIL, SlimefunItems.SYNTHETIC_EMERALD, SlimefunItems.GOLD_4K, SlimefunItems.GOLD_6K, SlimefunItems.GOLD_8K, SlimefunItems.GOLD_10K, SlimefunItems.GOLD_12K, SlimefunItems.GOLD_14K, SlimefunItems.GOLD_16K, SlimefunItems.GOLD_18K, SlimefunItems.GOLD_20K, SlimefunItems.GOLD_22K, SlimefunItems.GOLD_24K));
    private final Map<SlimefunItem, ItemStack[]> ITEM_RECIPES = new HashMap<SlimefunItem, ItemStack[]>();

    public SmartFactory(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        for (SlimefunItemStack sfItem : ACCEPTED_ITEMS) {
            this.ITEM_RECIPES.put(sfItem.getItem(), this.collectRawRecipe(sfItem.getItem()));
        }
        this.buildPreset();
        this.addItemHandler(new ItemHandler[]{this.onBreak()});
    }

    private void buildPreset() {
        new BlockMenuPreset(this.getId(), "&cSmart Factory"){

            public void init() {
                ChestMenuUtils.drawBackground((ChestMenu)this, (int[])BORDER);
                Utils.createBorder((ChestMenu)this, ChestMenuUtils.getInputSlotTexture(), BORDER_IN);
                Utils.createBorder((ChestMenu)this, ChestMenuUtils.getOutputSlotTexture(), BORDER_OUT);
                this.addItem(42, PROGRESS_ITEM);
                this.addItem(9, (ItemStack)new CustomItemStack(Material.BLACK_STAINED_GLASS_PANE, "&7Coal Slots", new String[]{"&eThis row is reserved for coal for cargo"}));
                this.addItem(18, (ItemStack)new CustomItemStack(Material.YELLOW_STAINED_GLASS_PANE, "&bMisc Slots", new String[]{"&eThe remaining rows accept any item", "&eCargo will only complete the stacks"}));
                this.addMenuClickHandler(43, ChestMenuUtils.getEmptyClickHandler());
            }

            public boolean canOpen(@Nonnull Block b, @Nonnull Player p) {
                return Utils.canOpen(b, p);
            }

            public void newInstance(@Nonnull BlockMenu menu, @Nonnull Block b) {
                SlimefunItem recipe = SlimefunItem.getByItem((ItemStack)menu.getItemInSlot(43));
                if (recipe == null) {
                    menu.replaceExistingItem(43, (ItemStack)new CustomItemStack(Material.BARRIER, "&bRecipe", new String[]{"&cSneak and Right Click the", "&cfactory with a supported resource", "&cto set the recipe"}));
                } else {
                    menu.replaceExistingItem(43, SmartFactory.getDisplayItem(recipe, SmartFactory.this.getDisplayRecipes()));
                }
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return new int[0];
            }

            public int[] getSlotsAccessedByItemTransport(DirtyChestMenu menu, ItemTransportFlow flow, ItemStack item) {
                if (flow == ItemTransportFlow.WITHDRAW) {
                    return SmartFactory.this.getOutputSlots();
                }
                if (item.getType() == Material.COAL) {
                    return COAL_SLOTS;
                }
                ArrayList<Integer> slots = new ArrayList<Integer>();
                for (int slot : MISC_SLOTS) {
                    if (menu.getItemInSlot(slot) == null) continue;
                    slots.add(slot);
                }
                slots.sort(SmartFactory.this.compareSlots(menu));
                int[] array = new int[slots.size()];
                for (int i = 0; i < slots.size(); ++i) {
                    array[i] = (Integer)slots.get(i);
                }
                return array;
            }
        };
    }

    private BlockBreakHandler onBreak() {
        return new SimpleBlockBreakHandler(){

            public void onBlockBreak(@Nonnull Block b) {
                BlockMenu inv = BlockStorage.getInventory((Block)b);
                if (inv != null) {
                    inv.dropItems(b.getLocation(), SmartFactory.this.getInputSlots());
                    inv.dropItems(b.getLocation(), SmartFactory.this.getOutputSlots());
                }
                progress.remove(new BlockPosition(b.getWorld(), b.getX(), b.getY(), b.getZ()));
            }
        };
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public void tick(Block b, SlimefunItem sf, Config data) {
                SmartFactory.this.tick(b);
            }

            public boolean isSynchronized() {
                return false;
            }
        }});
    }

    protected void tick(Block b) {
        if (this.getCharge(b.getLocation()) < SmartFactory.getEnergyConsumption()) {
            return;
        }
        BlockMenu inv = BlockStorage.getInventory((Block)b);
        BlockPosition pos = new BlockPosition(b.getWorld(), b.getX(), b.getY(), b.getZ());
        int currentProgress = progress.getOrDefault(pos, 0);
        HashMap<Integer, Integer> ingredients = this.getIngredientSlots(b, inv);
        if (ingredients == null) {
            this.resetProgress(pos, inv);
            return;
        }
        if (currentProgress < 10) {
            progress.put(pos, ++currentProgress);
            ChestMenuUtils.updateProgressbar((ChestMenu)inv, (int)42, (int)(10 - currentProgress), (int)10, (ItemStack)PROGRESS_ITEM);
            this.removeCharge(b.getLocation(), SmartFactory.getEnergyConsumption());
            return;
        }
        this.craft(b);
        for (Map.Entry<Integer, Integer> ingredient : ingredients.entrySet()) {
            inv.consumeItem(ingredient.getKey().intValue(), ingredient.getValue().intValue());
        }
        this.resetProgress(pos, inv);
    }

    private HashMap<Integer, Integer> getIngredientSlots(Block b, BlockMenu inv) {
        SlimefunItem key = SlimefunItem.getByItem((ItemStack)inv.getItemInSlot(43));
        if (key == null) {
            return null;
        }
        if (!inv.fits(key.getItem(), this.getOutputSlots())) {
            return null;
        }
        HashMap<Integer, Integer> ingredientSlots = new HashMap<Integer, Integer>();
        for (ItemStack recipeItem : this.ITEM_RECIPES.get(key)) {
            boolean exists = false;
            for (int slot : this.getInputSlots()) {
                ItemStack slotItem = inv.getItemInSlot(slot);
                if (slotItem == null || !SlimefunUtils.isItemSimilar((ItemStack)recipeItem, (ItemStack)slotItem, (boolean)true, (boolean)false) || (recipeItem.getType() == Material.COAL ? slotItem.getAmount() < recipeItem.getAmount() : slotItem.getAmount() < recipeItem.getAmount() + 1)) continue;
                exists = true;
                ingredientSlots.put(slot, recipeItem.getAmount());
                break;
            }
            if (exists) continue;
            return null;
        }
        return ingredientSlots;
    }

    private void craft(Block b) {
        SlimefunItem key = SlimefunItem.getByItem((ItemStack)BlockStorage.getInventory((Block)b).getItemInSlot(43));
        BlockStorage.getInventory((Block)b).pushItem(key.getItem().clone(), this.getOutputSlots());
    }

    private void resetProgress(BlockPosition pos, BlockMenu inv) {
        progress.put(pos, 0);
        ChestMenuUtils.updateProgressbar((ChestMenu)inv, (int)42, (int)10, (int)10, (ItemStack)PROGRESS_ITEM);
    }

    private ItemStack[] collectRawRecipe(SlimefunItem key) {
        Pair<HashMap<Material, Integer>, HashMap<SlimefunItem, Integer>> ingredients = this.reduceRecipe(key);
        ItemStack[] rawRecipe = new ItemStack[((HashMap)ingredients.getFirstValue()).size() + ((HashMap)ingredients.getSecondValue()).size()];
        int index = 0;
        for (Map.Entry materialEntry : ((HashMap)ingredients.getFirstValue()).entrySet()) {
            rawRecipe[index] = new ItemStack((Material)materialEntry.getKey(), ((Integer)materialEntry.getValue()).intValue());
            ++index;
        }
        for (Map.Entry sfItemEntry : ((HashMap)ingredients.getSecondValue()).entrySet()) {
            rawRecipe[index] = new CustomItemStack(((SlimefunItem)sfItemEntry.getKey()).getItem(), ((Integer)sfItemEntry.getValue()).intValue());
            ++index;
        }
        return rawRecipe;
    }

    private Pair<HashMap<Material, Integer>, HashMap<SlimefunItem, Integer>> reduceRecipe(SlimefunItem key) {
        HashMap<Material, Integer> rawVanilla = new HashMap<Material, Integer>();
        HashMap<SlimefunItem, Integer> rawSlimefun = new HashMap<SlimefunItem, Integer>();
        block5: for (ItemStack item : key.getRecipe()) {
            if (item == null) continue;
            if (!this.isReduced(item)) {
                Pair<HashMap<Material, Integer>, HashMap<SlimefunItem, Integer>> reduced = this.reduceRecipe(SlimefunItem.getByItem((ItemStack)item));
                ((HashMap)reduced.getFirstValue()).forEach((recipeItem, amt) -> rawVanilla.put((Material)recipeItem, rawVanilla.getOrDefault(recipeItem, 0) + amt * item.getAmount()));
                ((HashMap)reduced.getSecondValue()).forEach((recipeItem, amt) -> rawSlimefun.put((SlimefunItem)recipeItem, rawSlimefun.getOrDefault(recipeItem, 0) + amt * item.getAmount()));
                continue;
            }
            if (item instanceof SlimefunItemStack) {
                rawSlimefun.put(SlimefunItem.getByItem((ItemStack)item), rawSlimefun.getOrDefault(SlimefunItem.getByItem((ItemStack)item), 0) + item.getAmount());
                continue;
            }
            switch (item.getType()) {
                case IRON_INGOT: {
                    rawSlimefun.put(SlimefunItems.IRON_DUST.getItem(), rawSlimefun.getOrDefault(SlimefunItems.IRON_DUST.getItem(), 0) + item.getAmount());
                    continue block5;
                }
                case QUARTZ_BLOCK: {
                    rawVanilla.put(Material.QUARTZ, rawVanilla.getOrDefault(Material.QUARTZ, 0) + item.getAmount() * 4);
                    continue block5;
                }
                case REDSTONE_BLOCK: {
                    rawVanilla.put(Material.REDSTONE, rawVanilla.getOrDefault(Material.REDSTONE, 0) + item.getAmount() * 9);
                    continue block5;
                }
                default: {
                    rawVanilla.put(item.getType(), rawVanilla.getOrDefault(item.getType(), 0) + item.getAmount());
                }
            }
        }
        return new Pair(rawVanilla, rawSlimefun);
    }

    private boolean isReduced(ItemStack test) {
        SlimefunItem sfTest = SlimefunItem.getByItem((ItemStack)test);
        return sfTest == null || sfTest.getId().endsWith("_DUST");
    }

    public static ItemStack getDisplayItem(SlimefunItem key, List<ItemStack> displayRecipes) {
        ItemStack item = displayRecipes.get(ACCEPTED_ITEMS.indexOf(key.getItem())).clone();
        ItemMeta displayMeta = item.getItemMeta();
        List lore = displayMeta.getLore();
        lore.add("");
        lore.add(Utils.color("&eSneak and Right Click the factory with a"));
        lore.add(Utils.color("&ecompatible resource to change the recipe"));
        displayMeta.setLore(lore);
        item.setItemMeta(displayMeta);
        return item;
    }

    @Nonnull
    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> recipes = new ArrayList<ItemStack>();
        for (SlimefunItemStack sfStack : ACCEPTED_ITEMS) {
            ItemStack display = sfStack.clone();
            ItemMeta displayMeta = display.getItemMeta();
            ArrayList<String> lore = new ArrayList<String>();
            for (ItemStack item : this.ITEM_RECIPES.get(sfStack.getItem())) {
                lore.add(Utils.color("&e" + item.getAmount() + "x " + Utils.getViewableName(item)));
            }
            displayMeta.setLore(lore);
            display.setItemMeta(displayMeta);
            recipes.add(display);
        }
        return recipes;
    }

    private Comparator<Integer> compareSlots(DirtyChestMenu menu) {
        return Comparator.comparingInt(slot -> menu.getItemInSlot(slot.intValue()).getAmount());
    }

    public static int getEnergyConsumption() {
        return 1024;
    }

    public static int getEnergyCapacity() {
        return SmartFactory.getEnergyConsumption() * 3;
    }

    private int[] getInputSlots() {
        return INPUT_SLOTS;
    }

    private int[] getOutputSlots() {
        return new int[]{24, 25};
    }

    public static List<SlimefunItemStack> getAcceptedItems() {
        return ACCEPTED_ITEMS;
    }

    @Nonnull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getCapacity() {
        return SmartFactory.getEnergyCapacity();
    }
}

