/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.fluffymachines.machines;

import io.github.thebusybiscuit.slimefun4.api.events.BlockPlacerPlaceEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.items.altar.AltarRecipe;
import io.github.thebusybiscuit.slimefun4.implementation.items.altar.AncientAltar;
import io.github.thebusybiscuit.slimefun4.implementation.items.blocks.BrokenSpawner;
import io.github.thebusybiscuit.slimefun4.implementation.items.blocks.RepairedSpawner;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.ncbpfluffybear.fluffymachines.utils.Constants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class AutoAncientAltar
extends SlimefunItem
implements EnergyNetComponent {
    public static final int ENERGY_CONSUMPTION = 128;
    public static final int CAPACITY = 384;
    private final int[] border = new int[]{0, 1, 3, 4, 5, 7, 8, 13, 14, 15, 16, 17, 50, 51, 52, 53};
    private final int[] inputBorder = new int[]{9, 10, 11, 12, 13, 18, 22, 27, 31, 36, 40, 45, 46, 47, 48, 49};
    private final int[] outputBorder = new int[]{23, 24, 25, 26, 32, 35, 41, 42, 43, 44};
    private final int[] mockPedestalSlots = new int[]{19, 20, 21, 30, 39, 38, 37, 28};
    private final AncientAltar altarItem = (AncientAltar)SlimefunItems.ANCIENT_ALTAR.getItem();
    private final ItemStack ironBars = new ItemStack(Material.IRON_BARS);
    private final ItemStack earthRune = new SlimefunItemStack(SlimefunItems.EARTH_RUNE.getItemId(), (ItemStack)SlimefunItems.EARTH_RUNE);
    private final List<ItemStack> jarInputs = new ArrayList<ItemStack>(Arrays.asList(this.ironBars, this.earthRune, this.ironBars, this.earthRune, this.ironBars, this.earthRune, this.ironBars, this.earthRune));

    public AutoAncientAltar(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        new BlockMenuPreset(this.getId(), "&5Auto Ancient Altar"){

            public void init() {
                AutoAncientAltar.this.constructMenu(this);
            }

            public void newInstance(@Nonnull BlockMenu menu, @Nonnull Block b) {
                BlockStorage.addBlockInfo((Block)b, (String)"craftOnce", (String)String.valueOf(false));
                if (!BlockStorage.hasBlockInfo((Block)b) || BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"enabled") == null || BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"enabled").equals(String.valueOf(false))) {
                    menu.replaceExistingItem(6, (ItemStack)new CustomItemStack(Material.GUNPOWDER, "&7Enabled: &4\u2718", new String[]{"", "&e> Click to enable this Machine"}));
                    menu.addMenuClickHandler(6, (p, slot, item, action) -> {
                        BlockStorage.addBlockInfo((Block)b, (String)"enabled", (String)String.valueOf(true));
                        this.newInstance(menu, b);
                        return false;
                    });
                } else {
                    menu.replaceExistingItem(6, (ItemStack)new CustomItemStack(Material.REDSTONE, "&7Enabled: &2\u2714", new String[]{"", "&e> Click to disable this Machine"}));
                    menu.addMenuClickHandler(6, (p, slot, item, action) -> {
                        BlockStorage.addBlockInfo((Block)b, (String)"enabled", (String)String.valueOf(false));
                        this.newInstance(menu, b);
                        return false;
                    });
                }
                menu.replaceExistingItem(7, (ItemStack)new CustomItemStack(Material.ENCHANTING_TABLE, "&cCraft Once", new String[]{"", "&e> Click to craft recipe once"}));
                menu.addMenuClickHandler(7, (p, slot, item, action) -> {
                    BlockStorage.addBlockInfo((Block)b, (String)"craftOnce", (String)String.valueOf(true));
                    return false;
                });
            }

            public boolean canOpen(@Nonnull Block b, @Nonnull Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), Interaction.INTERACT_BLOCK);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return new int[0];
            }

            public int[] getSlotsAccessedByItemTransport(DirtyChestMenu menu, ItemTransportFlow flow, ItemStack item) {
                if (flow == ItemTransportFlow.WITHDRAW) {
                    return AutoAncientAltar.this.getOutputSlots();
                }
                if (item.getType().getMaxStackSize() == 1) {
                    return AutoAncientAltar.this.getInputSlots();
                }
                ArrayList<Integer> slots = new ArrayList<Integer>();
                for (int slot : AutoAncientAltar.this.getInputSlots()) {
                    if (menu.getItemInSlot(slot) == null) continue;
                    slots.add(slot);
                }
                slots.sort(AutoAncientAltar.this.compareSlots(menu));
                int[] array = new int[slots.size()];
                for (int i = 0; i < slots.size(); ++i) {
                    array[i] = (Integer)slots.get(i);
                }
                return array;
            }
        };
        this.addItemHandler(new ItemHandler[]{this.onPlace()});
        this.addItemHandler(new ItemHandler[]{this.onBreak()});
    }

    private BlockBreakHandler onBreak() {
        return new BlockBreakHandler(false, false){

            public void onPlayerBreak(@Nonnull BlockBreakEvent e, @Nonnull ItemStack item, @Nonnull List<ItemStack> drops) {
                Block b = e.getBlock();
                BlockMenu inv = BlockStorage.getInventory((Block)b);
                if (inv != null) {
                    inv.dropItems(b.getLocation(), AutoAncientAltar.this.getInputSlots());
                    inv.dropItems(b.getLocation(), AutoAncientAltar.this.getOutputSlots());
                }
            }
        };
    }

    private BlockPlaceHandler onPlace() {
        return new BlockPlaceHandler(true){

            public void onPlayerPlace(@Nonnull BlockPlaceEvent e) {
                BlockStorage.addBlockInfo((Block)e.getBlock(), (String)"enabled", (String)String.valueOf(false));
                BlockStorage.addBlockInfo((Block)e.getBlock(), (String)"craftOnce", (String)String.valueOf(false));
            }

            public void onBlockPlacerPlace(@Nonnull BlockPlacerPlaceEvent e) {
                BlockStorage.addBlockInfo((Block)e.getBlock(), (String)"enabled", (String)String.valueOf(false));
                BlockStorage.addBlockInfo((Block)e.getBlock(), (String)"craftOnce", (String)String.valueOf(false));
            }
        };
    }

    private Comparator<Integer> compareSlots(DirtyChestMenu menu) {
        return Comparator.comparingInt(slot -> menu.getItemInSlot(slot.intValue()).getAmount());
    }

    protected void constructMenu(BlockMenuPreset preset) {
        AutoAncientAltar.borders(preset, this.border, this.inputBorder, this.outputBorder);
        for (int i : this.getOutputSlots()) {
            preset.addMenuClickHandler(i, (ChestMenu.MenuClickHandler)new ChestMenu.AdvancedMenuClickHandler(){

                public boolean onClick(Player p, int slot, ItemStack cursor, ClickAction action) {
                    return false;
                }

                public boolean onClick(InventoryClickEvent e, Player p, int slot, ItemStack cursor, ClickAction action) {
                    if (cursor == null) {
                        return true;
                    }
                    return cursor.getType() == Material.AIR;
                }
            });
        }
        preset.addItem(2, (ItemStack)new CustomItemStack(new ItemStack(Material.ENCHANTING_TABLE), "&eRecipe", new String[]{"", "&bPut in the Recipe you want to craft", "&4Ancient Altar Recipes ONLY"}), (p, slot, item, action) -> false);
    }

    public int getEnergyConsumption() {
        return 128;
    }

    public int getCapacity() {
        return 384;
    }

    public int[] getInputSlots() {
        return new int[]{19, 20, 21, 28, 29, 30, 37, 38, 39};
    }

    public int[] getOutputSlots() {
        return new int[]{33, 34};
    }

    @Nonnull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public void tick(Block b, SlimefunItem sf, Config data) {
                AutoAncientAltar.this.tick(b);
            }

            public boolean isSynchronized() {
                return false;
            }
        }});
    }

    protected void tick(Block block) {
        String craftOnce = BlockStorage.getLocationInfo((Location)block.getLocation(), (String)"craftOnce");
        if (BlockStorage.getLocationInfo((Location)block.getLocation(), (String)"enabled").equals(String.valueOf(false)) && craftOnce.equals("false")) {
            return;
        }
        if (this.getCharge(block.getLocation()) < this.getEnergyConsumption()) {
            return;
        }
        BlockStorage.addBlockInfo((Block)block, (String)"craftOnce", (String)String.valueOf(false));
        this.craftIfValid(block, Boolean.parseBoolean(craftOnce));
    }

    private void craftIfValid(Block block, boolean craftOnce) {
        Optional<ItemStack> result;
        ItemStack catalyst;
        int outSlot;
        ItemStack outItem;
        BlockMenu menu = BlockStorage.getInventory((Block)block);
        ArrayList<ItemStack> pedestalItems = new ArrayList<ItemStack>();
        int[] nArray = this.getOutputSlots();
        int n = nArray.length;
        for (int i = 0; i < n && (outItem = menu.getItemInSlot(outSlot = nArray[i])) != null && outItem.getAmount() >= outItem.getMaxStackSize(); ++i) {
            if (outSlot != this.getOutputSlots()[1]) continue;
            return;
        }
        for (int slot : this.getInputSlots()) {
            ItemStack slotItem = menu.getItemInSlot(slot);
            if (slotItem == null) {
                return;
            }
            Material type = slotItem.getType();
            if (craftOnce || type.getMaxStackSize() == 1 || slotItem.getAmount() != 1) continue;
            return;
        }
        for (int i = 0; i < 8; ++i) {
            int slot = this.mockPedestalSlots[i];
            ItemStack pedestalItem = menu.getItemInSlot(slot);
            SlimefunItem sfPedestalItem = SlimefunItem.getByItem((ItemStack)pedestalItem);
            if (sfPedestalItem != null) {
                pedestalItems.add(sfPedestalItem.getItem());
                continue;
            }
            pedestalItems.add((ItemStack)new CustomItemStack(pedestalItem, 1));
        }
        int mockAltarSlot = 29;
        ItemStack catalystItem = menu.getItemInSlot(mockAltarSlot);
        SlimefunItem sfCatalyst = SlimefunItem.getByItem((ItemStack)catalystItem);
        if (sfCatalyst != null) {
            SlimefunItemStack catalystStack = new SlimefunItemStack(sfCatalyst.getId(), catalystItem);
            catalyst = new SlimefunItemStack(catalystStack, 1);
        } else if (!catalystItem.hasItemMeta()) {
            catalyst = new ItemStack(catalystItem.getType(), 1);
        } else {
            return;
        }
        if (Constants.isSoulJarsInstalled && sfCatalyst != null && sfCatalyst.getId().startsWith("FILLED") && sfCatalyst.getId().endsWith("SOUL_JAR")) {
            try {
                EntityType entityType = EntityType.valueOf((String)sfCatalyst.getId().replace("FILLED_", "").replace("_SOUL_JAR", ""));
                if (entityType == EntityType.UNKNOWN) {
                    return;
                }
                BrokenSpawner brokenSpawner = (BrokenSpawner)SlimefunItems.BROKEN_SPAWNER.getItem(BrokenSpawner.class);
                ItemStack spawnerItem = brokenSpawner.getItemForEntityType(entityType);
                if (pedestalItems.equals(this.jarInputs)) {
                    this.removeCharge(block.getLocation(), 128);
                    for (int slot : this.getInputSlots()) {
                        menu.consumeItem(slot);
                    }
                    menu.pushItem(spawnerItem.clone(), this.getOutputSlots());
                }
            }
            catch (IllegalArgumentException entityType) {}
        } else if (SlimefunUtils.isItemSimilar((ItemStack)catalystItem, (ItemStack)SlimefunItems.BROKEN_SPAWNER, (boolean)false, (boolean)false)) {
            result = this.checkRecipe((ItemStack)SlimefunItems.BROKEN_SPAWNER, pedestalItems);
            if (result.isPresent()) {
                RepairedSpawner spawner = (RepairedSpawner)SlimefunItems.REPAIRED_SPAWNER.getItem();
                ItemStack spawnerResult = spawner.getItemForEntityType(spawner.getEntityType(catalystItem).orElse(EntityType.PIG));
                this.craft(block, menu, spawnerResult);
            }
        } else {
            result = this.checkRecipe(catalyst, pedestalItems);
            result.ifPresent(itemStack -> this.craft(block, menu, (ItemStack)itemStack));
        }
    }

    private Optional<ItemStack> checkRecipe(ItemStack catalyst, List<ItemStack> pedestalItems) {
        for (AltarRecipe recipe : this.altarItem.getRecipes()) {
            if (!SlimefunUtils.isItemSimilar((ItemStack)recipe.getCatalyst(), (ItemStack)catalyst, (boolean)true) || !recipe.getInput().equals(pedestalItems)) continue;
            return Optional.of(recipe.getOutput().clone());
        }
        return Optional.empty();
    }

    private void craft(Block b, BlockMenu menu, ItemStack result) {
        if (!menu.fits(result, this.getOutputSlots())) {
            return;
        }
        this.removeCharge(b.getLocation(), 128);
        for (int slot : this.getInputSlots()) {
            menu.consumeItem(slot);
        }
        menu.pushItem(result, this.getOutputSlots());
    }

    static void borders(BlockMenuPreset preset, int[] border, int[] inputBorder, int[] outputBorder) {
        for (int i : border) {
            preset.addItem(i, (ItemStack)new CustomItemStack(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " ", new String[0]), (p, slot, item, action) -> false);
        }
        for (int i : inputBorder) {
            preset.addItem(i, (ItemStack)new CustomItemStack(new ItemStack(Material.CYAN_STAINED_GLASS_PANE), " ", new String[0]), (p, slot, item, action) -> false);
        }
        for (int i : outputBorder) {
            preset.addItem(i, (ItemStack)new CustomItemStack(new ItemStack(Material.ORANGE_STAINED_GLASS_PANE), " ", new String[0]), (p, slot, item, action) -> false);
        }
    }
}

