/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.fluffymachines.items;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockUseHandler;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.ncbpfluffybear.fluffymachines.utils.Utils;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class EnderChestInsertionNode
extends SlimefunItem {
    private static final Material material = Material.ENDER_CHEST;

    public EnderChestInsertionNode(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.addItemHandler(new ItemHandler[]{this.onPlace()});
        this.addItemHandler(new ItemHandler[]{this.onInteract()});
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public void tick(Block b, SlimefunItem sf, Config data) {
                EnderChestInsertionNode.this.tick(b);
            }

            public boolean isSynchronized() {
                return true;
            }
        }});
    }

    private void tick(@Nonnull Block b) {
        Player p;
        BlockFace face;
        if (b.getRelative(BlockFace.NORTH).getType() == material) {
            face = BlockFace.SOUTH;
        } else if (b.getRelative(BlockFace.SOUTH).getType() == material) {
            face = BlockFace.NORTH;
        } else if (b.getRelative(BlockFace.EAST).getType() == material) {
            face = BlockFace.WEST;
        } else if (b.getRelative(BlockFace.WEST).getType() == material) {
            face = BlockFace.EAST;
        } else {
            return;
        }
        BlockState state = PaperLib.getBlockState((Block)b.getRelative(face), (boolean)false).getState();
        if (b.getRelative(face).getState() instanceof InventoryHolder && (p = Bukkit.getOfflinePlayer((UUID)UUID.fromString(BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"owner"))).getPlayer()) != null) {
            boolean enderValid = false;
            boolean containerValid = false;
            int enderIndex = -1;
            int containerIndex = -1;
            Inventory containerInv = ((InventoryHolder)state).getInventory();
            for (int i = 0; i < containerInv.getSize(); ++i) {
                if (containerInv.getItem(i) == null) continue;
                containerIndex = i;
                containerValid = true;
                break;
            }
            Inventory enderInv = p.getEnderChest();
            for (int i = 0; i < enderInv.getSize(); ++i) {
                if (enderInv.getItem(i) != null) continue;
                enderIndex = i;
                enderValid = true;
                break;
            }
            if (enderValid && containerValid) {
                ItemStack transferItemStack = containerInv.getItem(containerIndex);
                containerInv.setItem(containerIndex, null);
                enderInv.setItem(enderIndex, transferItemStack);
            }
        }
    }

    private BlockPlaceHandler onPlace() {
        return new BlockPlaceHandler(false){

            public void onPlayerPlace(@Nonnull BlockPlaceEvent e) {
                Player p = e.getPlayer();
                Block b = e.getBlock();
                if (!e.isCancelled()) {
                    BlockStorage.addBlockInfo((Block)b, (String)"owner", (String)p.getUniqueId().toString());
                    BlockStorage.addBlockInfo((Block)b, (String)"playername", (String)p.getDisplayName());
                    Utils.send((CommandSender)p, "&aEnder Chest Insertion Node registered to " + p.getDisplayName() + " &7(UUID: " + p.getUniqueId() + ")");
                }
            }
        };
    }

    private BlockUseHandler onInteract() {
        return e -> {
            Player p = e.getPlayer();
            Block b = (Block)e.getClickedBlock().get();
            Utils.send((CommandSender)p, "&eThis Ender Chest Insertion Node belongs to " + BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"playername") + " &7(UUID: " + BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"owner") + ")");
        };
    }
}

