/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.fluffymachines;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.Pair;
import io.github.thebusybiscuit.slimefun4.libraries.dough.config.Config;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.GitHubBuildsUpdater;
import io.ncbpfluffybear.fluffymachines.FluffyItemSetup;
import io.ncbpfluffybear.fluffymachines.listeners.KeyedCrafterListener;
import io.ncbpfluffybear.fluffymachines.utils.Events;
import io.ncbpfluffybear.fluffymachines.utils.McMMOEvents;
import io.ncbpfluffybear.fluffymachines.utils.Utils;
import io.ncbpfluffybear.shaded.bstats.bukkit.Metrics;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.RayTraceResult;

public class FluffyMachines
extends JavaPlugin
implements SlimefunAddon {
    private static FluffyMachines instance;
    public static final HashMap<ItemStack, List<Pair<ItemStack, List<RecipeChoice>>>> shapedVanillaRecipes;
    public static final HashMap<ItemStack, List<Pair<ItemStack, List<RecipeChoice>>>> shapelessVanillaRecipes;

    public void onEnable() {
        instance = this;
        Config cfg = new Config((Plugin)this);
        if (cfg.getBoolean("options.auto-update") && this.getDescription().getVersion().startsWith("DEV - ")) {
            new GitHubBuildsUpdater((Plugin)this, this.getFile(), "NCBPFluffyBear/FluffyMachines/master/").start();
        }
        try {
            Field accepting = Enchantment.class.getDeclaredField("acceptingNew");
            accepting.setAccessible(true);
            if (!accepting.getBoolean(null)) {
                accepting.set(null, true);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException ignored) {
            this.getLogger().warning("Failed to register enchantment.");
        }
        Iterator recipeIterator = Bukkit.recipeIterator();
        while (recipeIterator.hasNext()) {
            Recipe r = (Recipe)recipeIterator.next();
            if (r instanceof ShapedRecipe) {
                ShapedRecipe sr = (ShapedRecipe)r;
                ArrayList<RecipeChoice> rc = new ArrayList<RecipeChoice>();
                ItemStack key = new ItemStack(sr.getResult().getType(), 1);
                for (Map.Entry choice : sr.getChoiceMap().entrySet()) {
                    if (choice.getValue() == null) continue;
                    rc.add((RecipeChoice)choice.getValue());
                }
                if (!shapedVanillaRecipes.containsKey(key)) {
                    shapedVanillaRecipes.put(key, new ArrayList<Pair>(Collections.singletonList(new Pair((Object)sr.getResult(), rc))));
                    continue;
                }
                shapedVanillaRecipes.get(key).add((Pair<ItemStack, List<RecipeChoice>>)new Pair((Object)sr.getResult(), rc));
                continue;
            }
            if (!(r instanceof ShapelessRecipe)) continue;
            ShapelessRecipe slr = (ShapelessRecipe)r;
            ItemStack key = new ItemStack(slr.getResult().getType(), 1);
            if (!shapelessVanillaRecipes.containsKey(key)) {
                shapelessVanillaRecipes.put(key, new ArrayList<Pair>(Collections.singletonList(new Pair((Object)slr.getResult(), (Object)slr.getChoiceList()))));
                continue;
            }
            shapelessVanillaRecipes.get(key).add((Pair<ItemStack, List<RecipeChoice>>)new Pair((Object)slr.getResult(), (Object)slr.getChoiceList()));
        }
        if (this.getServer().getPluginManager().isPluginEnabled("McMMO")) {
            Bukkit.getLogger().log(Level.INFO, "McMMO found!");
            this.getServer().getPluginManager().registerEvents((Listener)new McMMOEvents(), (Plugin)this);
        }
        FluffyItemSetup.setup(this);
        FluffyItemSetup.setupBarrels(this);
        this.getServer().getPluginManager().registerEvents((Listener)new Events(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new KeyedCrafterListener(), (Plugin)this);
        Metrics metrics = new Metrics(this, 8927);
        this.getLogger().log(Level.INFO, ChatColor.GREEN + "Hi there! Want to share your server with the Slimefun community?");
        this.getLogger().log(Level.INFO, ChatColor.GREEN + "Join the official Slimefun Discord server at https://discord.gg/slimefun");
    }

    public void onDisable() {
    }

    public boolean onCommand(@Nonnull CommandSender sender, @Nonnull Command cmd, @Nonnull String label, String[] args) {
        if (args.length == 0) {
            Utils.send(sender, "&cInvalid command");
            return true;
        }
        if (!(sender instanceof Player)) {
            Utils.send(sender, "&cThere are no console commands available");
            return true;
        }
        Player p = (Player)sender;
        switch (args[0].toUpperCase()) {
            case "META": {
                Utils.send((CommandSender)p, String.valueOf(p.getInventory().getItemInMainHand().getItemMeta()));
                return true;
            }
            case "RAWMETA": {
                p.sendMessage(String.valueOf(p.getInventory().getItemInMainHand().getItemMeta()).replace("\u00a7", "&"));
                return true;
            }
            case "VERSION": 
            case "V": {
                Utils.send((CommandSender)p, "&eThe current version is " + this.getPluginVersion());
                return true;
            }
        }
        if (p.hasPermission("fluffymachines.admin")) {
            switch (args[0].toUpperCase()) {
                case "ADDINFO": {
                    if (args.length != 3) {
                        Utils.send((CommandSender)p, "&cPlease specify the key and the data");
                    } else {
                        RayTraceResult rayResult = p.rayTraceBlocks(5.0);
                        if (rayResult != null && rayResult.getHitBlock() != null && BlockStorage.hasBlockInfo((Block)rayResult.getHitBlock())) {
                            BlockStorage.addBlockInfo((Block)rayResult.getHitBlock(), (String)args[1], (String)args[2]);
                            Utils.send((CommandSender)p, "&aInfo has been added.");
                        } else {
                            Utils.send((CommandSender)p, "&cYou must be looking at a Slimefun block");
                        }
                    }
                    return true;
                }
                case "SAVEPLAYERS": {
                    this.saveAllPlayers();
                    return true;
                }
            }
        }
        Utils.send((CommandSender)p, "&cCommand not found");
        return false;
    }

    private void saveAllPlayers() {
        Iterator iterator = PlayerProfile.iterator();
        int players = 0;
        while (iterator.hasNext()) {
            PlayerProfile profile = (PlayerProfile)iterator.next();
            profile.save();
            ++players;
        }
        if (players > 0) {
            Bukkit.getLogger().log(Level.INFO, "Auto-saved all player data for {0} player(s)!", players);
        }
    }

    private void registerGlow() {
    }

    public String getBugTrackerURL() {
        return "https://github.com/NCBPFluffyBear/FluffyMachines/issues";
    }

    @Nonnull
    public JavaPlugin getJavaPlugin() {
        return this;
    }

    public static FluffyMachines getInstance() {
        return instance;
    }

    static {
        shapedVanillaRecipes = new HashMap();
        shapelessVanillaRecipes = new HashMap();
    }
}

